/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.interact;

import java.util.ArrayList;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorActionSetting;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.helpers.ElevatorMenuHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class InteractActionSettingsMenu {
    public static void openInteractActionSettingsMenu(Player player, IElevator elevator, IElevatorAction action, Runnable onReturn) {
        if (!elevator.isValid()) {
            onReturn.run();
            return;
        }
        ArrayList settings = new ArrayList(action.getSettings());
        settings.removeIf(i -> i.isSettingGlobalOnly(elevator));
        int inventorySize = Math.floorDiv(settings.size() + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Settings > Actions > Action");
        ElevatorMenuHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory);
        action.onStartEditing(player, display, elevator);
        display.onReturn(() -> {
            action.onStopEditing(player, display, elevator);
            onReturn.run();
        });
        for (int i2 = 0; i2 < settings.size(); ++i2) {
            IElevatorActionSetting setting = (IElevatorActionSetting)settings.get(i2);
            display.setItemSimple(i2 + 9, setting.createIcon(setting.getIndividualValue(elevator), false), (event, myDisplay) -> {
                myDisplay.stopReturn();
                setting.clickIndividual(player, elevator, () -> InteractActionSettingsMenu.openInteractActionSettingsMenu(player, elevator, action, onReturn), (InventoryClickEvent)event);
            }, new DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "BACK", Material.ARROW, 1), new DisplayClickFlag[0]);
        display.open();
    }
}

