/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.interact;

import java.util.List;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.helpers.ElevatorMenuHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.menus.interact.InteractActionSettingsMenu;
import me.keehl.elevators.menus.interact.InteractSettingsMenu;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class InteractActionsMenu {
    public static void openInteractActionsMenu(Player player, IElevator elevator, List<IElevatorAction> actions) {
        if (!elevator.isValid()) {
            InteractSettingsMenu.openInteractSettingsMenu(player, elevator);
            return;
        }
        int inventorySize = Math.floorDiv(actions.size() + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Elevator > Settings > Actions");
        ElevatorMenuHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> InteractSettingsMenu.openInteractSettingsMenu(player, elevator));
        for (int i = 0; i < actions.size(); ++i) {
            IElevatorAction action = actions.get(i);
            display.setItemSimple(i + 9, action.getIcon(), (event, myDisplay) -> {
                myDisplay.stopReturn();
                InteractActionSettingsMenu.openInteractActionSettingsMenu(player, elevator, action, () -> InteractActionsMenu.openInteractActionsMenu(player, elevator, actions));
            }, new DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "BACK", Material.ARROW, 1), new DisplayClickFlag[0]);
        display.open();
    }
}

