/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.interact;

import elevators.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import elevators.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.ArrayList;
import java.util.List;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.IProtectionHook;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.ElevatorMenuHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.menus.interact.InteractNameMenu;
import me.keehl.elevators.menus.interact.InteractProtectMenu;
import me.keehl.elevators.menus.interact.InteractSettingsMenu;
import me.keehl.elevators.models.ElevatorEventData;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class InteractMenu {
    public static void openInteractMenu(Player player, IElevator elevator) {
        if (!elevator.isValid()) {
            Elevators.getLocale().getElevatorChangedKickedOutMessage().sendFormatted((CommandSender)player, new ElevatorEventData(player, elevator, elevator, 1, 0.0));
            if (elevator.getShulkerBox() != null && ElevatorHelper.isElevatorDisabled(elevator.getShulkerBox())) {
                ElevatorHelper.setElevatorEnabled(elevator.getShulkerBox());
                ShulkerBoxHelper.playClose(elevator.getShulkerBox());
            }
            elevator.getShulkerBox().removeMetadata("open-player", (Plugin)Elevators.getInstance());
            player.closeInventory();
            return;
        }
        elevator.getShulkerBox().setMetadata("open-player", (MetadataValue)new FixedMetadataValue((Plugin)Elevators.getInstance(), (Object)player.getUniqueId().toString()));
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)"Elevator");
        ElevatorHelper.setElevatorDisabled(elevator.getShulkerBox());
        ShulkerBoxHelper.playOpen(elevator.getShulkerBox());
        ElevatorMenuHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        ArrayList<String> nameLore = new ArrayList<String>();
        nameLore.add("");
        nameLore.add(String.valueOf(ChatColor.GRAY) + "Current Value: ");
        nameLore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + Elevators.getDataContainerService().getFloorName(elevator));
        ItemStack protectionItem = ItemStackHelper.createItem(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Protection", Material.DIAMOND_SWORD, 1);
        ItemStack nameItem = ItemStackHelper.createItem(String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + "Floor Name", Material.NAME_TAG, 1, nameLore);
        ItemStack settingsItem = ItemStackHelper.createItem(String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "Settings", Material.SEA_LANTERN, 1);
        List<IProtectionHook> protectionHooks = J_U_S_Stream.toList(Elevators.getHooksService().getProtectionHooks().stream().filter(i -> i.getConfig().doesAllowCustomization()).filter(i -> i.createIconForElevator(player, elevator) != null));
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> {
            ElevatorHelper.setElevatorEnabled(elevator.getShulkerBox());
            ShulkerBoxHelper.playClose(elevator.getShulkerBox());
            elevator.getShulkerBox().removeMetadata("open-player", (Plugin)Elevators.getInstance());
        });
        boolean canRename = Elevators.getHooksService().canRenameElevator(player, elevator, false);
        if (protectionHooks.isEmpty()) {
            if (canRename) {
                display.setItemSimple(11, nameItem, (event, myDisplay) -> InteractNameMenu.openInteractNameMenu(myDisplay, player, elevator), new DisplayClickFlag[0]);
                display.setItemSimple(15, settingsItem, (event, myDisplay) -> ElevatorMenuHelper.openMenuFromDisplay(myDisplay, player, elevator, InteractSettingsMenu::openInteractSettingsMenu), new DisplayClickFlag[0]);
            } else {
                display.setItemSimple(13, settingsItem, (event, myDisplay) -> ElevatorMenuHelper.openMenuFromDisplay(myDisplay, player, elevator, InteractSettingsMenu::openInteractSettingsMenu), new DisplayClickFlag[0]);
            }
            display.open();
            return;
        }
        if (canRename) {
            display.setItemSimple(10, protectionItem, (event, myDisplay) -> ElevatorMenuHelper.openMenuFromDisplay(myDisplay, player, elevator, InteractProtectMenu::openInteractProtectMenu), new DisplayClickFlag[0]);
            display.setItemSimple(13, nameItem, (event, myDisplay) -> InteractNameMenu.openInteractNameMenu(myDisplay, player, elevator), new DisplayClickFlag[0]);
            display.setItemSimple(16, settingsItem, (event, myDisplay) -> ElevatorMenuHelper.openMenuFromDisplay(myDisplay, player, elevator, InteractSettingsMenu::openInteractSettingsMenu), new DisplayClickFlag[0]);
        } else {
            display.setItemSimple(11, protectionItem, (event, myDisplay) -> ElevatorMenuHelper.openMenuFromDisplay(myDisplay, player, elevator, InteractProtectMenu::openInteractProtectMenu), new DisplayClickFlag[0]);
            display.setItemSimple(15, settingsItem, (event, myDisplay) -> ElevatorMenuHelper.openMenuFromDisplay(myDisplay, player, elevator, InteractSettingsMenu::openInteractSettingsMenu), new DisplayClickFlag[0]);
        }
        if (protectionHooks.size() == 1) {
            IProtectionHook hook = J_U_List.getFirst(protectionHooks);
            ItemStack protectionIcon = hook.createIconForElevator(player, elevator);
            display.setItemSimple(canRename ? 10 : 11, protectionIcon, (event, myDisplay) -> {
                myDisplay.stopReturn();
                hook.onProtectionClick(player, elevator, () -> InteractMenu.openInteractMenu(player, elevator));
            }, new DisplayClickFlag[0]);
        }
        display.open();
    }
}

