/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.interact;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.IProtectionHook;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.api.services.interaction.ISimpleDisplay;
import me.keehl.elevators.helpers.ElevatorMenuHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.menus.interact.InteractMenu;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InteractProtectMenu {
    public static void openInteractProtectMenu(Player player, IElevator elevator) {
        if (!elevator.isValid()) {
            InteractMenu.openInteractMenu(player, elevator);
            return;
        }
        List protectionHooks = Elevators.getHooksService().getProtectionHooks().stream().filter(i -> i.getConfig().doesAllowCustomization()).filter(i -> i.createIconForElevator(player, elevator) != null).collect(Collectors.toList());
        Inventory inventory = ElevatorMenuHelper.createInventoryWithMinSlots(protectionHooks.size() + 9, "Elevator > Protection");
        ElevatorMenuHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> InteractMenu.openInteractMenu(player, elevator));
        for (Map.Entry hookData : ElevatorMenuHelper.mapToInventorySlot(protectionHooks).entrySet()) {
            int slot = hookData.getValue() + 9;
            ItemStack icon = ((IProtectionHook)hookData.getKey()).createIconForElevator(player, elevator);
            BiConsumer<InventoryClickEvent, ISimpleDisplay> onClick = (event, myDisplay) -> {
                myDisplay.stopReturn();
                ((IProtectionHook)hookData.getKey()).onProtectionClick(player, elevator, () -> InteractProtectMenu.openInteractProtectMenu(player, elevator));
            };
            display.setItemSimple(slot, icon, onClick, new DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "BACK", Material.ARROW, 1), new DisplayClickFlag[0]);
        display.open();
    }
}

