/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.interact;

import elevators.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import java.util.List;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorSetting;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.helpers.ElevatorMenuHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.menus.interact.InteractActionsMenu;
import me.keehl.elevators.menus.interact.InteractMenu;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class InteractSettingsMenu {
    public static void openInteractSettingsMenu(Player player, IElevator elevator) {
        if (!elevator.isValid()) {
            InteractMenu.openInteractMenu(player, elevator);
            return;
        }
        List<IElevatorSetting> settings = J_U_S_Stream.toList(Elevators.getSettingService().getElevatorSettings().stream().filter(i -> !i.isSettingGlobalOnly(elevator)));
        int itemAmount = settings.size();
        List<IElevatorAction> upActions = ElevatorMenuHelper.getActionsWithSettings(elevator, true);
        List<IElevatorAction> downActions = ElevatorMenuHelper.getActionsWithSettings(elevator, false);
        if (!upActions.isEmpty()) {
            ++itemAmount;
        }
        if (!downActions.isEmpty()) {
            ++itemAmount;
        }
        int inventorySize = Math.floorDiv(itemAmount + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Elevator > Settings");
        ElevatorMenuHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> InteractMenu.openInteractMenu(player, elevator));
        for (int i2 = 0; i2 < settings.size(); ++i2) {
            IElevatorSetting setting = settings.get(i2);
            display.setItemSimple(i2 + 9, setting.createIcon(setting.getIndividualValue(elevator), false), (event, myDisplay) -> {
                myDisplay.stopReturn();
                setting.clickIndividual(player, elevator, () -> InteractSettingsMenu.openInteractSettingsMenu(player, elevator), (InventoryClickEvent)event);
            }, new DisplayClickFlag[0]);
        }
        if (!downActions.isEmpty()) {
            display.setItemSimple(inventory.getSize() - 1, ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Downwards Actions", Material.SPECTRAL_ARROW, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                InteractActionsMenu.openInteractActionsMenu(player, elevator, downActions);
            }, new DisplayClickFlag[0]);
        }
        if (!upActions.isEmpty()) {
            display.setItemSimple(inventory.getSize() - (downActions.isEmpty() ? 1 : 2), ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Upwards Actions", Material.TIPPED_ARROW, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                InteractActionsMenu.openInteractActionsMenu(player, elevator, upActions);
            }, new DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "BACK", Material.ARROW, 1), new DisplayClickFlag[0]);
        display.open();
    }
}

