/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models;

import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorType;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.ShulkerBox;

public class Elevator
implements IElevator {
    private final ShulkerBox shulkerBox;
    private final IElevatorType elevatorType;

    public Elevator(ShulkerBox shulkerBox, IElevatorType elevatorType) {
        this.shulkerBox = shulkerBox;
        this.elevatorType = elevatorType;
    }

    @Override
    public ShulkerBox getShulkerBox() {
        return this.shulkerBox;
    }

    @Override
    public IElevatorType getElevatorType() {
        return this.elevatorType;
    }

    @Override
    public IElevatorType getElevatorType(boolean useSnapshot) {
        if (useSnapshot) {
            return this.getElevatorType();
        }
        return Elevators.getElevatorTypeService().getElevatorType(this.elevatorType.getTypeKey());
    }

    @Override
    public Location getLocation() {
        return this.shulkerBox.getLocation();
    }

    @Override
    public DyeColor getDyeColor() {
        return this.shulkerBox.getColor();
    }

    @Override
    public boolean isValid() {
        return this.getLocation().getBlock().getType() == this.shulkerBox.getType() && this.elevatorType == this.getElevatorType(false);
    }
}

