/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models;

import elevators.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorRecipeGroup;
import me.keehl.elevators.api.models.IElevatorSetting;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.models.settings.ElevatorSetting;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigElevatorType;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigSettings;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;

public class ElevatorType
extends ConfigElevatorType
implements IElevatorType {
    private transient String elevatorTypeKey;
    private final transient List<IElevatorAction> actionsUp = new ArrayList<IElevatorAction>();
    private final transient List<IElevatorAction> actionsDown = new ArrayList<IElevatorAction>();

    @Override
    public String getTypeKey() {
        return this.elevatorTypeKey.toUpperCase();
    }

    @Override
    public List<IElevatorAction> getActionsUp() {
        return this.actionsUp;
    }

    @Override
    public List<IElevatorAction> getActionsDown() {
        return this.actionsDown;
    }

    @Override
    public List<IElevatorRecipeGroup> getRecipeGroups() {
        return new ArrayList<IElevatorRecipeGroup>(this.recipes.values());
    }

    public ConfigElevatorType getConfig() {
        return this;
    }

    public ConfigSettings getSettingsConfig() {
        return this.settings;
    }

    @Override
    public void setDisplayName(ILocaleComponent displayName) {
        this.settings.displayName = displayName;
        Elevators.getRecipeService().refreshRecipes();
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setUsePermission(String usePermission) {
        this.settings.usePermission = usePermission;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setDyePermission(String dyePermission) {
        this.settings.dyePermission = dyePermission;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setMaxDistanceAllowedBetweenElevators(int maxDistance) {
        this.settings.maxDistance = maxDistance;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setMaxStackSize(int maxStackSize) {
        this.settings.maxStackSize = maxStackSize;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setMaxSolidBlocksAllowedBetweenElevators(int maxSolidBlocks) {
        this.settings.maxSolidBlocks = maxSolidBlocks;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setCheckDestinationElevatorType(boolean checkType) {
        this.settings.classCheck = checkType;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setElevatorRequiresPermissions(boolean checkPerms) {
        this.settings.checkPerms = checkPerms;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setCanElevatorExplode(boolean canExplode) {
        this.settings.canExplode = canExplode;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setCanDye(boolean supportDying) {
        this.settings.supportDying = supportDying;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setStopsObstructedTeleportation(boolean stopsObstruction) {
        this.settings.stopObstruction = stopsObstruction;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setShouldValidateColor(boolean checkColor) {
        this.settings.checkColor = checkColor;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setShouldAllowIndividualEdit(boolean allowIndividualEdit) {
        this.settings.canEditIndividually = allowIndividualEdit;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void setHologramLines(List<ILocaleComponent> holoLines) {
        boolean checkCreate = this.settings.hologramLines.isEmpty();
        this.settings.hologramLines = holoLines;
        Elevators.getInstance().saveConfig();
        if (!Elevators.getHologramService().canUseHolograms()) {
            return;
        }
        this.updateAllHolograms(checkCreate);
    }

    @Override
    public void updateAllHolograms(boolean chunkCheck) {
        Elevators.getFoliaLib().getScheduler().runNextTick(task -> Elevators.getHologramService().updateHologramsOfElevatorType(this));
        if (!chunkCheck) {
            return;
        }
        Elevators.getFoliaLib().getScheduler().runNextTick(task -> {
            for (World world : Bukkit.getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    Elevators.getHologramService().updateHologramsInChunk(chunk);
                }
            }
        });
    }

    @Override
    public void setLore(List<ILocaleComponent> loreLines) {
        this.settings.loreLines = loreLines;
        Elevators.getRecipeService().refreshRecipes();
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void onSave() {
        this.actions.up = this.getActionsUp().stream().map(IElevatorAction::serialize).collect(Collectors.toList());
        this.actions.down = this.getActionsDown().stream().map(IElevatorAction::serialize).collect(Collectors.toList());
        for (IElevatorSetting<?> apiSetting : Elevators.getSettingService().getElevatorSettings()) {
            if (!(apiSetting instanceof ElevatorSetting)) {
                return;
            }
            ElevatorSetting setting = (ElevatorSetting)apiSetting;
            setting.applyToElevatorSettings(this, this.settings);
        }
        HashMap<String, IElevatorRecipeGroup> newRecipes = new HashMap<String, IElevatorRecipeGroup>();
        for (String key : this.recipes.keySet()) {
            IElevatorRecipeGroup recipeGroup = (IElevatorRecipeGroup)this.recipes.get(key);
            newRecipes.put(key.toUpperCase(), recipeGroup);
            recipeGroup.setKey(key.toUpperCase());
        }
        this.recipes = newRecipes;
    }

    @Override
    public void onLoad() {
        this.getActionsUp().clear();
        this.getActionsDown().clear();
        this.getActionsUp().addAll(J_U_S_Stream.toList(this.actions.up.stream().map(i -> Elevators.getActionService().createActionFromString(this, (String)i)).filter(Objects::nonNull)));
        this.getActionsDown().addAll(J_U_S_Stream.toList(this.actions.down.stream().map(i -> Elevators.getActionService().createActionFromString(this, (String)i)).filter(Objects::nonNull)));
    }

    @Override
    public void setKey(String key) {
        this.elevatorTypeKey = key.toUpperCase();
    }
}

