/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.actions.settings.ElevatorActionSetting;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorActionSetting;
import me.keehl.elevators.api.models.IElevatorActionVariable;
import me.keehl.elevators.api.models.IElevatorEventData;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.interaction.ISimpleDisplay;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.actions.ElevatorActionBuilder;
import me.keehl.elevators.models.actions.ElevatorActionVariable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.Subst;

public abstract class ElevatorAction
implements IElevatorAction {
    static Pattern subPattern = Pattern.compile("([a-zA-Z]+)=(.*?(?= [a-zA-Z]+=)|.*\\S)");
    private static final IElevatorActionVariable<UUID> keyGrouping = new ElevatorActionVariable<UUID>(null, UUID::fromString, "identifier", "identifier", "i");
    private final JavaPlugin plugin;
    private final IElevatorType elevatorType;
    protected String value;
    private final String key;
    private final String defaultVariableAlias;
    private final Map<IElevatorActionVariable<?>, Object> variableData = new HashMap();
    private final List<IElevatorActionVariable<?>> variables;
    private final Map<IElevatorActionVariable<?>, IElevatorActionSetting<?>> settings = new HashMap();
    private ItemStack icon;
    private boolean initialized = false;

    protected ElevatorAction(JavaPlugin plugin, IElevatorType elevatorType, String key, IElevatorActionVariable<?> ... variables) {
        this.plugin = plugin;
        this.elevatorType = elevatorType;
        this.key = key;
        this.defaultVariableAlias = variables.length > 0 ? variables[0].getMainAlias() : null;
        this.variables = new ArrayList(Arrays.asList(variables));
        this.variables.add(keyGrouping);
        this.icon = ItemStackHelper.createItem(key, Material.EGG, 1);
    }

    @Override
    public void setIcon(ItemStack item) {
        this.icon = item;
    }

    @Override
    public final void initialize(String value) {
        if (value.contains(":")) {
            value = value.substring(value.indexOf(58) + 1);
        }
        this.value = value = value.trim();
        boolean defaultVariableSet = false;
        Matcher matcher = subPattern.matcher(this.value);
        while (matcher.find()) {
            String alias = matcher.group(1);
            if (this.calculateVariableFromAlias(alias, matcher.group(2))) {
                defaultVariableSet = true;
            }
            value = value.replace(this.value.substring(matcher.start(), matcher.end()), "");
        }
        if (!defaultVariableSet && this.defaultVariableAlias != null) {
            this.calculateVariableFromAlias(this.defaultVariableAlias, value);
        }
        for (IElevatorActionVariable<?> grouping : this.variables) {
            if (this.variableData.containsKey(grouping)) continue;
            this.variableData.put(grouping, grouping.getDefaultObject());
        }
        this.initialized = true;
        this.onInitialize(this.value);
        this.initIdentifier();
    }

    @Override
    public IElevatorType getElevatorType() {
        return this.elevatorType;
    }

    @Override
    @Subst(value="test_key")
    public String getKey() {
        return this.key;
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public String serialize() {
        StringBuilder builder = new StringBuilder(this.key + ": ");
        for (IElevatorActionVariable<?> variable : this.variableData.keySet()) {
            Object value = this.variableData.get(variable);
            builder.append(variable.getMainAlias());
            builder.append("=");
            builder.append(variable.getStringFromObject(value));
            builder.append(" ");
        }
        return builder.toString().trim();
    }

    @Override
    public <T> T getVariableValue(IElevatorActionVariable<T> grouping) {
        return this.getVariableValue(grouping, null);
    }

    @Override
    public <T> T getVariableValue(IElevatorActionVariable<T> variable, IElevator elevator) {
        ElevatorActionSetting data;
        if (elevator != null && this.settings.containsKey(variable) && !(data = (ElevatorActionSetting)this.settings.get(variable)).isSettingGlobalOnly(elevator)) {
            return variable.getObjectFromString((String)data.getIndividualValue(elevator), this);
        }
        if (this.variableData.containsKey(variable)) {
            return (T)this.variableData.get(variable);
        }
        return variable.getDefaultObject();
    }

    protected Optional<IElevatorActionVariable<?>> getGroupingByAlias(String alias) {
        return this.variables.stream().filter(i -> i.isGroupingAlias(alias)).findFirst();
    }

    @Override
    public <T> void setGroupingObject(IElevatorActionVariable<T> grouping, T value) {
        if (value.equals(grouping.getDefaultObject())) {
            this.variableData.remove(grouping);
        } else {
            this.variableData.put(grouping, value);
        }
        if (Elevators.getConfigService().isConfigLoaded()) {
            Elevators.getInstance().saveConfig();
        }
    }

    private boolean calculateVariableFromAlias(String groupingAlias, String groupingValue) {
        String groupingAliasFixed = groupingAlias.trim().toLowerCase();
        String groupingValueFixed = groupingValue.trim().isEmpty() ? null : groupingValue.trim();
        Optional<IElevatorActionVariable> grouping = this.variables.stream().filter(i -> i.isGroupingAlias(groupingAliasFixed)).findFirst();
        grouping.ifPresent(elevatorActionGrouping -> this.variableData.put((IElevatorActionVariable<?>)elevatorActionGrouping, elevatorActionGrouping.getObjectFromString(groupingValueFixed, this)));
        return grouping.map(elevatorActionGrouping -> elevatorActionGrouping.getMainAlias().equalsIgnoreCase(this.defaultVariableAlias)).orElse(false);
    }

    protected <T> IElevatorActionSetting<T> mapSetting(IElevatorActionVariable<T> grouping, String settingName, String settingDisplayName, String description, Material icon, ChatColor textColor, boolean setupDataStore) {
        if (!this.initialized) {
            throw new RuntimeException("Elevator Action Setting mapped prior to initialization. Please move all mapSetting calls to the onInitialize method.");
        }
        ElevatorActionSetting<T> setting = new ElevatorActionSetting<T>(this.plugin, this, grouping, settingName, String.valueOf(textColor) + String.valueOf(ChatColor.BOLD) + settingDisplayName, description, icon, setupDataStore);
        this.settings.put(grouping, setting);
        this.initIdentifier();
        return setting;
    }

    protected <T> IElevatorActionSetting<T> mapSetting(IElevatorActionVariable<T> grouping, String settingName, String settingDisplayName, String description, Material icon, boolean setupDataStore) {
        if (!this.initialized) {
            throw new RuntimeException("Elevator Action Setting mapped prior to initialization. Please move all mapSetting calls to the onInitialize method.");
        }
        ElevatorActionSetting<T> setting = new ElevatorActionSetting<T>(this.plugin, this, grouping, settingName, settingDisplayName, description, icon, setupDataStore);
        this.settings.put(grouping, setting);
        this.initIdentifier();
        return setting;
    }

    protected <T> IElevatorActionSetting<T> mapSetting(IElevatorActionVariable<T> grouping, String settingName, String settingDisplayName, String description, Material icon, ChatColor textColor) {
        return this.mapSetting(grouping, settingName, settingDisplayName, description, icon, textColor, false);
    }

    protected <T> IElevatorActionSetting<T> mapSetting(IElevatorActionVariable<T> grouping, String settingName, String settingDisplayName, String description, Material icon) {
        return this.mapSetting(grouping, settingName, settingDisplayName, description, icon, false);
    }

    @Override
    public UUID getIdentifier() {
        return this.getVariableValue(keyGrouping);
    }

    @Override
    public List<IElevatorActionSetting<?>> getSettings() {
        return new ArrayList(this.settings.values());
    }

    @Override
    public void initIdentifier() {
        UUID currentIdent = this.getVariableValue(keyGrouping);
        if (currentIdent != null) {
            return;
        }
        this.setGroupingObject(keyGrouping, UUID.randomUUID());
    }

    @Override
    public void onStartEditing(Player player, ISimpleDisplay display, IElevator elevator) {
    }

    @Override
    public void onStopEditing(Player player, ISimpleDisplay display, IElevator elevator) {
    }

    public static ElevatorActionBuilder builder(String actionKey) {
        return new ElevatorActionBuilder(actionKey);
    }

    @Override
    public boolean meetsConditions(IElevatorEventData eventData, Player player) {
        return true;
    }

    protected abstract void onInitialize(String var1);

    @Override
    public abstract void execute(IElevatorEventData var1, Player var2);
}

