/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models.actions;

import java.util.Optional;
import me.keehl.elevators.api.models.IElevatorActionVariable;
import me.keehl.elevators.api.models.IElevatorEventData;
import me.keehl.elevators.api.models.actions.IElevatorActionExecuteContext;
import me.keehl.elevators.models.actions.ElevatorAction;
import org.bukkit.entity.Player;

public class ElevatorActionExecuteContext
implements IElevatorActionExecuteContext {
    private final ElevatorAction action;
    private final IElevatorEventData eventData;
    private final Player player;

    protected ElevatorActionExecuteContext(ElevatorAction action, IElevatorEventData eventData, Player player) {
        this.action = action;
        this.eventData = eventData;
        this.player = player;
    }

    @Override
    public <T> T getVariable(String alias) {
        Optional<IElevatorActionVariable<?>> groupingOptional = this.action.getGroupingByAlias(alias);
        if (groupingOptional.isEmpty()) {
            throw new RuntimeException("Attempt to pull Elevator Action Variable with alias that was not setup: " + this.action.getKey() + " -> " + alias);
        }
        return (T)this.action.getVariableValue(groupingOptional.get(), this.eventData.getOrigin());
    }

    @Override
    public ElevatorAction getAction() {
        return this.action;
    }

    @Override
    public IElevatorEventData getEventData() {
        return this.eventData;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }
}

