/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models.hooks;

import java.util.List;
import java.util.UUID;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.hooks.IElevatorHologram;
import me.keehl.elevators.api.models.hooks.IWrappedHologram;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class WrappedHologram
implements IWrappedHologram {
    private final String uuid;
    private final Location elevatorLocation;
    private final String elevatorTypeKey;
    private final IElevatorHologram wrappedHologram;

    public WrappedHologram(UUID uuid, IElevatorHologram wrappedHologram, IElevator elevator) {
        this.uuid = uuid.toString();
        this.wrappedHologram = wrappedHologram;
        this.elevatorLocation = elevator.getLocation();
        this.elevatorTypeKey = elevator.getElevatorType().getTypeKey();
        Elevators.getHologramService().registerHologram(this);
    }

    @Override
    public void addLine(String text) {
        this.wrappedHologram.addLine(text);
    }

    @Override
    public void setLines(List<String> text) {
        this.wrappedHologram.setLines(text);
    }

    @Override
    public double getHeight() {
        return this.wrappedHologram.getHeight();
    }

    @Override
    public void teleportTo(Location location) {
        this.wrappedHologram.teleportTo(location);
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public Location getElevatorLocation() {
        return this.elevatorLocation;
    }

    @Override
    public IElevatorType getElevatorType() {
        return Elevators.getElevatorTypeService().getElevatorType(this.elevatorTypeKey);
    }

    @Override
    public IElevator getElevatorRecord() {
        Block block = this.elevatorLocation.getBlock();
        return ElevatorsAPI.createElevatorRecord(block);
    }

    @Override
    public void update() {
        if (!this.getElevatorLocation().getChunk().isLoaded()) {
            return;
        }
        IElevator elevator = this.getElevatorRecord();
        if (elevator == null) {
            this.delete();
            return;
        }
        Elevators.getHologramService().updateElevatorHologram(this.getElevatorRecord());
    }

    @Override
    public final void delete() {
        this.wrappedHologram.onDelete();
        Elevators.getHologramService().unregisterHologram(this);
    }
}

