/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorSetting;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.api.util.persistantDataTypes.ElevatorsDataType;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.models.settings.BuilderElevatorSetting;
import me.keehl.elevators.models.settings.ElevatorSettingBuilder;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigSettings;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.Pattern;
import org.intellij.lang.annotations.Subst;

public abstract class ElevatorSetting<T>
implements IElevatorSetting<T> {
    private final JavaPlugin plugin;
    protected final List<String> comments;
    protected final String settingName;
    protected final ItemStack iconTemplate;
    private NamespacedKey containerKey;
    private final Map<String, String> actions = new HashMap<String, String>();

    public ElevatorSetting(JavaPlugin plugin, @Subst(value="test_key") @Pattern(value="[a-z0-9/._-]+") String settingName, ItemStack icon) {
        this.plugin = plugin;
        this.settingName = settingName;
        this.iconTemplate = icon.clone();
        this.comments = new ArrayList<String>();
        if (!plugin.getName().equalsIgnoreCase(Elevators.getInstance().getName())) {
            this.comments.add("Setting provided by the plugin: " + plugin.getName());
        }
    }

    public ElevatorSetting(JavaPlugin plugin, @Subst(value="test_key") @Pattern(value="[a-z0-9/._-]+") String settingName, String settingDisplayName, String description, Material icon) {
        this(plugin, settingName, ItemStackHelper.createItem(settingDisplayName, icon, 1, MessageHelper.formatLore(description, ChatColor.GRAY)));
    }

    public ElevatorSetting(JavaPlugin plugin, @Subst(value="test_key") @Pattern(value="[a-z0-9/._-]+") String settingName, String settingDisplayName, String description, Material icon, ChatColor textColor) {
        this(plugin, settingName, String.valueOf(textColor) + String.valueOf(ChatColor.BOLD) + settingDisplayName, description, icon);
    }

    @Override
    public IElevatorSetting<T> addAction(String action, String description) {
        this.actions.put(action, description);
        return this;
    }

    protected IElevatorSetting<T> setupDataStore(String settingKey, PersistentDataType<?, T> dataType) {
        this.containerKey = Elevators.getDataContainerService().getKeyFromKey("per-ele-" + settingKey, dataType);
        return this;
    }

    @Override
    public final boolean isSettingGlobalOnly(IElevator elevator) {
        return elevator.getElevatorType(false).getDisabledSettings().contains(this.settingName) || !this.canBeEditedIndividually(elevator);
    }

    @Override
    public abstract boolean canBeEditedIndividually(IElevator var1);

    @Override
    public ItemStack createIcon(Object value, boolean global) {
        ArrayList<Object> lore = new ArrayList<Object>();
        ItemMeta templateMeta = this.iconTemplate.getItemMeta();
        if (templateMeta.hasLore()) {
            lore.addAll(Objects.requireNonNull(templateMeta.getLore()));
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Current Value: ");
        if (value instanceof Boolean) {
            lore.add((Boolean)value != false ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        } else if (value instanceof ILocaleComponent) {
            ILocaleComponent localeComponent = (ILocaleComponent)value;
            lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + localeComponent.toLegacyText());
        } else {
            lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + MessageHelper.formatLineColors(value.toString()));
        }
        if (!this.actions.isEmpty()) {
            lore.add("");
            this.actions.forEach((action, description) -> lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + action + ": " + String.valueOf(ChatColor.GRAY) + description));
        }
        ItemStack icon = this.iconTemplate.clone();
        ItemMeta iconMeta = icon.getItemMeta();
        iconMeta.setLore(lore);
        icon.setItemMeta(iconMeta);
        return icon;
    }

    @Override
    public final void clickGlobal(Player player, IElevatorType elevatorType, Runnable returnMethod, InventoryClickEvent clickEvent) {
        this.onClickGlobal(player, elevatorType, returnMethod, clickEvent, this.getGlobalValue(elevatorType));
    }

    @Override
    public final void clickIndividual(Player player, IElevator elevator, Runnable returnMethod, InventoryClickEvent clickEvent) {
        this.onClickIndividual(player, elevator, returnMethod, clickEvent, this.getIndividualValue(elevator));
    }

    @Override
    public abstract void onClickGlobal(Player var1, IElevatorType var2, Runnable var3, InventoryClickEvent var4, T var5);

    @Override
    public abstract void onClickIndividual(Player var1, IElevator var2, Runnable var3, InventoryClickEvent var4, T var5);

    @Override
    public abstract T getGlobalValue(IElevatorType var1);

    @Override
    public final T getIndividualValue(IElevator elevator) {
        T value;
        if (!this.isSettingGlobalOnly(elevator) && this.containerKey != null && (value = Elevators.getDataContainerService().getElevatorValue(elevator.getShulkerBox(), this.containerKey, this.getGlobalValue(elevator.getElevatorType(false)))) != null) {
            return value;
        }
        return this.getGlobalValue(elevator.getElevatorType(false));
    }

    @Override
    public void setIndividualValue(IElevator elevator, T value) {
        if (this.containerKey == null) {
            throw new RuntimeException("Setting does not have a method for setting individual value.");
        }
        if (Objects.equals(value, this.getGlobalValue(elevator.getElevatorType(false)))) {
            value = null;
        }
        Elevators.getDataContainerService().setElevatorValue(elevator.getShulkerBox(), this.containerKey, value);
        elevator.getShulkerBox().update();
    }

    public final void applyToElevatorSettings(IElevatorType elevatorType, ConfigSettings settings) {
        if (!(this instanceof BuilderElevatorSetting)) {
            return;
        }
        settings.setData(this.settingName, this.getGlobalValue(elevatorType), this.getComments());
    }

    public static <T> ElevatorSettingBuilder<T> builder(@Subst(value="test_key") @Pattern(value="[a-z0-9/._-]+") String settingKey, T defaultValue, ElevatorsDataType dataType) {
        return new ElevatorSettingBuilder<T>(settingKey, defaultValue, dataType);
    }

    public static <T> ElevatorSettingBuilder<T> builder(@Subst(value="test_key") @Pattern(value="[a-z0-9/._-]+") String settingKey, T defaultValue, PersistentDataType<?, T> dataType) {
        return new ElevatorSettingBuilder<T>(settingKey, defaultValue, dataType);
    }

    @Override
    public String getSettingName() {
        return this.settingName;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    private List<String> getComments() {
        return new ArrayList<String>(this.comments);
    }
}

