/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.settings.IElevatorSettingBuilder;
import me.keehl.elevators.api.models.settings.IElevatorSettingClickContext;
import me.keehl.elevators.api.util.persistantDataTypes.ElevatorsDataType;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.settings.BuilderElevatorSetting;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;

public class ElevatorSettingBuilder<T>
implements IElevatorSettingBuilder<T> {
    protected final String settingKey;
    protected final T defaultValue;
    protected final PersistentDataType<?, T> persistentDataType;
    protected Consumer<IElevatorSettingClickContext<T>> onClick = IElevatorSettingClickContext::close;
    protected Function<IElevator, Boolean> canEditIndividuallyFunc;
    protected final Map<String, String> actions = new HashMap<String, String>();
    protected final List<String> comments = new ArrayList<String>();

    public ElevatorSettingBuilder(String settingKey, T defaultValue, PersistentDataType<?, T> persistentDataType) {
        this.settingKey = settingKey;
        this.defaultValue = defaultValue;
        this.persistentDataType = persistentDataType;
    }

    public ElevatorSettingBuilder(String settingKey, T defaultValue, ElevatorsDataType elevatorsDataType) {
        this(settingKey, defaultValue, elevatorsDataType.getDataType());
    }

    @Override
    public BuilderElevatorSetting<T> register(JavaPlugin plugin, ItemStack icon) {
        BuilderElevatorSetting setting = new BuilderElevatorSetting(plugin, this.settingKey, icon, this);
        Elevators.getSettingService().addSetting(setting);
        return setting;
    }

    @Override
    public void register(JavaPlugin plugin, String chatColor, String displayName, Material itemType) {
        this.register(plugin, ItemStackHelper.createItem(chatColor + String.valueOf(ChatColor.BOLD) + displayName, itemType, 1));
    }

    @Override
    public ElevatorSettingBuilder<T> addAction(String trigger, String action) {
        this.actions.put(trigger, action);
        return this;
    }

    @Override
    public ElevatorSettingBuilder<T> addComment(String comment) {
        this.comments.add(comment);
        return this;
    }

    @Override
    public ElevatorSettingBuilder<T> setCanEditIndividually(Function<IElevator, Boolean> canEditFunc) {
        this.canEditIndividuallyFunc = canEditFunc;
        return this;
    }

    @Override
    public ElevatorSettingBuilder<T> allowPerEleCustomization() {
        this.canEditIndividuallyFunc = elevator -> true;
        return this;
    }

    @Override
    public ElevatorSettingBuilder<T> onClick(Consumer<IElevatorSettingClickContext<T>> onClick) {
        this.onClick = onClick;
        return this;
    }
}

