/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import elevators.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import elevators.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.api.models.hooks.IElevatorHologram;
import me.keehl.elevators.api.models.hooks.IWrappedHologram;
import me.keehl.elevators.api.services.IElevatorHologramService;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.WrappedHologram;
import me.keehl.elevators.services.ElevatorService;
import me.keehl.elevators.util.folialib.wrapper.task.WrappedTask;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ElevatorHologramService
extends ElevatorService
implements IElevatorHologramService {
    private boolean initialized = false;
    private final Map<String, IWrappedHologram> holograms = new HashMap<String, IWrappedHologram>();
    private WrappedTask task;
    private int currentIndex = 0;

    public ElevatorHologramService(IElevators elevators) {
        super(elevators);
    }

    @Override
    public void onInitialize() {
        if (this.initialized) {
            return;
        }
        ElevatorsAPI.pushAndHoldLog();
        this.task = Elevators.getFoliaLib().getScheduler().runTimer(() -> {
            if (!this.canUseHolograms()) {
                return;
            }
            IWrappedHologram[] holograms = this.getHolograms().toArray(new IWrappedHologram[0]);
            if (holograms.length == 0) {
                return;
            }
            int attempts = 0;
            int startIndex = this.currentIndex;
            while (attempts++ < 10) {
                this.currentIndex %= holograms.length;
                IWrappedHologram hologram = holograms[this.currentIndex];
                if (!hologram.getElevatorLocation().getChunk().isLoaded()) continue;
                hologram.update();
                ++this.currentIndex;
                if (startIndex != this.currentIndex) continue;
                return;
            }
        }, 5L, 5L);
        this.initialized = true;
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Hologram service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void onUninitialize() {
        this.clearAll();
        this.task.cancel();
    }

    @Override
    public IWrappedHologram getElevatorHologramIfExists(IElevator elevator) {
        ShulkerBox shulkerBox = elevator.getShulkerBox();
        if (shulkerBox.hasMetadata("elevator-holo-uuid")) {
            String hologramUUID = ((MetadataValue)J_U_List.getFirst(shulkerBox.getMetadata("elevator-holo-uuid"))).asString();
            IWrappedHologram hologram = this.getHologram(hologramUUID);
            if (hologram != null) {
                return hologram;
            }
            shulkerBox.removeMetadata("elevator-holo-uuid", (Plugin)Elevators.getInstance());
        }
        return null;
    }

    @Override
    public IWrappedHologram getElevatorHologram(IElevator elevator) {
        if (!this.canUseHolograms()) {
            return null;
        }
        IWrappedHologram hologram = this.getElevatorHologramIfExists(elevator);
        if (hologram != null) {
            return hologram;
        }
        UUID nextUUID = this.getNextAvailableUUID();
        IElevatorHologram newHologram = Elevators.getHooksService().getHologramHook().createHologram(this.getNextAvailableUUID(), elevator, new String[0]);
        hologram = new WrappedHologram(nextUUID, newHologram, elevator);
        this.updateElevatorHologram(elevator);
        return hologram;
    }

    @Override
    public void deleteHologram(IElevator elevator) {
        IWrappedHologram hologram = this.getElevatorHologramIfExists(elevator);
        if (hologram == null) {
            return;
        }
        hologram.delete();
    }

    @Override
    public void deleteHologramsInChunk(Chunk ignoredChunk) {
    }

    @Override
    public void updateHologramsInChunk(Chunk chunk) {
        if (!this.canUseHolograms()) {
            return;
        }
        Collection<BlockState> tileEntities = VersionHelper.getShulkerBoxesInChunk(chunk);
        for (BlockState state : tileEntities) {
            ShulkerBox box;
            IElevatorType elevatorType;
            if (!(state instanceof ShulkerBox) || (elevatorType = ElevatorHelper.getElevatorType(box = (ShulkerBox)state)) == null) continue;
            this.updateElevatorHologram(new Elevator(box, elevatorType));
        }
    }

    @Override
    public void updateElevatorHologram(IElevator elevator) {
        IWrappedHologram hologram;
        if (!this.canUseHolograms()) {
            return;
        }
        if (elevator == null) {
            return;
        }
        List<String> hologramLines = elevator.getElevatorType().getHolographicLines().stream().map(ILocaleComponent::toLegacyText).collect(Collectors.toList());
        IWrappedHologram iWrappedHologram = hologram = hologramLines.isEmpty() ? this.getElevatorHologramIfExists(elevator) : this.getElevatorHologram(elevator);
        if (hologram == null) {
            return;
        }
        if (hologramLines.isEmpty()) {
            hologram.delete();
            return;
        }
        hologram.setLines(hologramLines);
        hologram.teleportTo(elevator.getLocation().clone().add(0.5, 1.5 + hologram.getHeight() / 2.0, 0.5));
    }

    @Override
    public void updateHologramsOfElevatorType(IElevatorType elevatorType) {
        List<IWrappedHologram> holograms = J_U_S_Stream.toList(this.getHolograms().stream().filter(i -> i.getElevatorType().equals(elevatorType)));
        for (IWrappedHologram hologram : holograms) {
            hologram.update();
        }
    }

    public UUID getNextAvailableUUID() {
        UUID uuid;
        while (this.holograms.containsKey((uuid = UUID.randomUUID()).toString())) {
        }
        return uuid;
    }

    public void clearAll() {
        if (!this.canUseHolograms()) {
            return;
        }
        new ArrayList<IWrappedHologram>(this.holograms.values()).forEach(IWrappedHologram::delete);
    }

    public void registerHologram(WrappedHologram holo) {
        if (!this.canUseHolograms()) {
            return;
        }
        this.holograms.put(holo.getUUID(), holo);
        holo.getElevatorRecord().getShulkerBox().setMetadata("elevator-holo-uuid", (MetadataValue)new FixedMetadataValue((Plugin)Elevators.getInstance(), (Object)holo.getUUID()));
    }

    public void unregisterHologram(WrappedHologram hologram) {
        if (!this.canUseHolograms()) {
            return;
        }
        this.holograms.remove(hologram.getUUID());
        IElevator elevator = hologram.getElevatorRecord();
        if (elevator != null && elevator.getShulkerBox() != null) {
            elevator.getShulkerBox().removeMetadata("elevator-holo-uuid", (Plugin)Elevators.getInstance());
        }
    }

    @Override
    public Collection<IWrappedHologram> getHolograms() {
        if (!this.canUseHolograms()) {
            return new ArrayList<IWrappedHologram>();
        }
        return this.holograms.values();
    }

    @Override
    public IWrappedHologram getHologram(String uuid) {
        if (!this.canUseHolograms()) {
            return null;
        }
        return this.holograms.get(uuid);
    }

    @Override
    public boolean canUseHolograms() {
        return Elevators.getHooksService().getHologramHook() != null && Elevators.getConfigService().isConfigLoaded() && Elevators.getConfigService().getRootConfig().isHologramServiceEnabled();
    }
}

