/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.hooks.ElevatorHook;
import me.keehl.elevators.api.models.hooks.HologramHook;
import me.keehl.elevators.api.models.hooks.IProtectionHook;
import me.keehl.elevators.api.models.hooks.ItemsHook;
import me.keehl.elevators.api.models.hooks.PlaceholderHook;
import me.keehl.elevators.api.models.hooks.ProtectionHook;
import me.keehl.elevators.api.services.IElevatorHookService;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.ResourceHelper;
import me.keehl.elevators.services.ElevatorService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ElevatorHookService
extends ElevatorService
implements IElevatorHookService {
    private boolean initialized = false;
    private final Map<String, ElevatorHook> hookMap = new HashMap<String, ElevatorHook>();
    private PlaceholderHook placeholderHook = null;
    private HologramHook hologramHook = null;

    public ElevatorHookService(IElevators elevators) {
        super(elevators);
    }

    @Override
    public void onInitialize() {
        if (this.initialized) {
            return;
        }
        ElevatorsAPI.pushAndHoldLog();
        this.initialized = true;
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Hook service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void onUninitialize() {
        this.hookMap.clear();
        this.initialized = false;
    }

    @Override
    public void registerHook(String pluginName, Class<? extends ElevatorHook> elevatorHookClass, boolean requireActive) {
        if (this.hookMap.containsKey(pluginName.toUpperCase())) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin(pluginName) == null) {
            return;
        }
        if (requireActive && !Bukkit.getPluginManager().isPluginEnabled(pluginName)) {
            return;
        }
        try {
            ElevatorsAPI.pushAndHoldLog();
            Constructor<? extends ElevatorHook> hookConstructor = elevatorHookClass.getConstructor(new Class[0]);
            ElevatorHook hook = hookConstructor.newInstance(new Object[0]);
            this.hookMap.put(pluginName.toUpperCase(), hook);
            this.placeholderHook = this.hookMap.values().stream().filter(i -> i instanceof PlaceholderHook).map(i -> (PlaceholderHook)i).findFirst().orElse(null);
            this.hologramHook = this.hookMap.values().stream().filter(i -> i instanceof HologramHook).map(i -> (HologramHook)i).findFirst().orElse(null);
            hook.onInit();
            if (hook instanceof IProtectionHook) {
                IProtectionHook protectionHook = (IProtectionHook)hook;
                Elevators.getConfigService().addConfigCallback(root -> protectionHook.getConfig());
            }
            ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Hooked into " + pluginName + ". " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ElevatorsAPI.log(Level.WARNING, "Failed to register hook for \"" + pluginName + "\" due to an inaccessible constructor. The plugin will still function; however, this hook will not work. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues", e);
        }
    }

    @Override
    public void registerHook(String pluginName, Class<? extends ElevatorHook> elevatorHookClass) {
        this.registerHook(pluginName, elevatorHookClass, true);
    }

    @Override
    public boolean canUseElevator(Player player, IElevator elevator, boolean sendMessage) {
        try {
            return this.getProtectionHooks().stream().allMatch(hook -> !hook.isCheckEnabled(elevator) || hook.canPlayerUseElevator(player, elevator, sendMessage));
        }
        catch (Exception e) {
            ElevatorsAPI.log(Level.SEVERE, "Failed to check hooks for use permission. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(e));
            return false;
        }
    }

    @Override
    public boolean canEditElevator(Player player, IElevator elevator, boolean sendMessage) {
        try {
            return this.getProtectionHooks().stream().allMatch(hook -> hook.canEditSettings(player, elevator, sendMessage));
        }
        catch (Exception e) {
            ElevatorsAPI.log(Level.SEVERE, "Failed to check hooks for edit permission. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(e));
            return false;
        }
    }

    @Override
    public boolean canRenameElevator(Player player, IElevator elevator, boolean sendMessage) {
        try {
            return this.getProtectionHooks().stream().allMatch(hook -> hook.canEditName(player, elevator, sendMessage));
        }
        catch (Exception e) {
            ElevatorsAPI.log(Level.SEVERE, "Failed to check hooks for rename permission. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(e));
            return false;
        }
    }

    @Override
    public ItemStack createItemStackFromKey(NamespacedKey key) {
        if (key.getNamespace().equalsIgnoreCase("minecraft")) {
            Material type = Material.matchMaterial((String)key.getKey());
            if (type == null) {
                return null;
            }
            return new ItemStack(type, 1);
        }
        if (key.getNamespace().equalsIgnoreCase(Elevators.getInstance().getName().toLowerCase(Locale.ROOT))) {
            IElevatorType type = Elevators.getElevatorTypeService().getElevatorType(key.getKey());
            if (type != null) {
                return ItemStackHelper.createItemStackFromElevatorType(type, DyeColor.RED);
            }
            return null;
        }
        try {
            for (ItemsHook hook : this.getItemsHooks()) {
                ItemStack item = hook.createItemStackFromKey(key);
                if (item == null) continue;
                return item;
            }
        }
        catch (Exception e) {
            ElevatorsAPI.log(Level.SEVERE, "Failed to get item from namespaced key. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(e));
        }
        return null;
    }

    @Override
    public NamespacedKey getKeyFromItemStack(ItemStack item) {
        try {
            IElevatorType elevatorType = ElevatorHelper.getElevatorType(item);
            if (elevatorType != null) {
                return new NamespacedKey((Plugin)Elevators.getInstance(), elevatorType.getTypeKey().toLowerCase());
            }
            for (ItemsHook hook : this.getItemsHooks()) {
                NamespacedKey key = hook.getKeyFromItemStack(item);
                if (key == null) continue;
                return key;
            }
        }
        catch (Exception e) {
            ElevatorsAPI.log(Level.SEVERE, "Failed to get namespaced key from itemstack. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(e));
        }
        return item.getType().getKey();
    }

    @Override
    public PlaceholderHook getPlaceholderHook() {
        return this.placeholderHook;
    }

    protected HologramHook getHologramHook() {
        return this.hologramHook;
    }

    @Override
    public List<IProtectionHook> getProtectionHooks() {
        return this.hookMap.values().stream().filter(i -> i instanceof ProtectionHook).map(i -> (ProtectionHook)i).collect(Collectors.toList());
    }

    @Override
    public List<ItemsHook> getItemsHooks() {
        return this.hookMap.values().stream().filter(i -> i instanceof ItemsHook).map(i -> (ItemsHook)i).collect(Collectors.toList());
    }
}

