/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.models.ElevatorEventExecutor;
import me.keehl.elevators.api.services.IElevatorListenerService;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.listeners.EntityEventExecutor;
import me.keehl.elevators.listeners.InventoryEventExecutor;
import me.keehl.elevators.listeners.PaperEventExecutor;
import me.keehl.elevators.listeners.WorldEventExecutor;
import me.keehl.elevators.services.ElevatorService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ElevatorListenerService
extends ElevatorService
implements IElevatorListenerService {
    private boolean initialized = false;
    private final Listener listener = new Listener(this){};

    public ElevatorListenerService(IElevators elevators) {
        super(elevators);
    }

    @Override
    public void onInitialize() {
        if (this.initialized) {
            return;
        }
        ElevatorsAPI.pushAndHoldLog();
        this.registerEventExecutor(InventoryOpenEvent.class, EventPriority.LOWEST, InventoryEventExecutor::onInventoryOpen);
        this.registerEventExecutor(InventoryClickEvent.class, EventPriority.HIGHEST, InventoryEventExecutor::onClickStackHandler, true);
        this.registerEventExecutor(InventoryClickEvent.class, EventPriority.LOWEST, InventoryEventExecutor::updateStackOnClick, true);
        this.registerEventExecutor(PrepareAnvilEvent.class, EventPriority.LOWEST, InventoryEventExecutor::onAnvilPrepare);
        this.registerEventExecutor(CraftItemEvent.class, EventPriority.NORMAL, InventoryEventExecutor::onCraft);
        this.registerEventExecutor(BlockPistonExtendEvent.class, EventPriority.NORMAL, WorldEventExecutor::onPistonExtend);
        this.registerEventExecutor(EntityExplodeEvent.class, EventPriority.NORMAL, WorldEventExecutor::onExplode);
        this.registerEventExecutor(BlockDispenseEvent.class, EventPriority.NORMAL, WorldEventExecutor::onDispenserPlace);
        this.registerEventExecutor(BlockDropItemEvent.class, EventPriority.LOWEST, WorldEventExecutor::onBlockBreak);
        this.registerEventExecutor(BlockPlaceEvent.class, EventPriority.HIGHEST, WorldEventExecutor::onBlockPlace);
        this.registerEventExecutor(ChunkLoadEvent.class, EventPriority.MONITOR, WorldEventExecutor::onChunkLoad);
        this.registerEventExecutor(ChunkUnloadEvent.class, EventPriority.HIGHEST, WorldEventExecutor::onChunkUnload);
        this.registerEventExecutor(PlayerJoinEvent.class, EventPriority.NORMAL, EntityEventExecutor::onJoin);
        this.registerEventExecutor(PlayerToggleSneakEvent.class, EventPriority.NORMAL, EntityEventExecutor::onSneak);
        this.registerEventExecutor(EntityPickupItemEvent.class, EventPriority.NORMAL, EntityEventExecutor::onPickup);
        this.registerEventExecutor(PlayerInteractEvent.class, EventPriority.HIGHEST, EntityEventExecutor::onRightClick);
        if (Elevators.getFoliaLib().isPaper()) {
            this.registerEventExecutor(PlayerJumpEvent.class, EventPriority.NORMAL, PaperEventExecutor::onJump, false);
            this.registerEventExecutor(InventoryMoveItemEvent.class, EventPriority.LOWEST, PaperEventExecutor::onHopperTake);
        } else {
            this.registerEventExecutor(PlayerMoveEvent.class, EventPriority.NORMAL, EntityEventExecutor::onJumpDefault, false);
            this.registerEventExecutor(InventoryMoveItemEvent.class, EventPriority.LOWEST, InventoryEventExecutor::onHopperTake);
        }
        this.TryRegisterCMIBackpackOpenEvent(this.listener);
        this.initialized = true;
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Listener service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void onUninitialize() {
        HandlerList.unregisterAll((Listener)this.listener);
        this.initialized = false;
    }

    private void TryRegisterCMIBackpackOpenEvent(Listener listener) {
        try {
            Class<?> backpackOpenEventClass = Class.forName("com.Zrips.CMI.events.CMIBackpackOpenEvent");
            Method getShulkerBoxMethod = backpackOpenEventClass.getMethod("getShulkerBox", new Class[0]);
            getShulkerBoxMethod.setAccessible(true);
            Bukkit.getPluginManager().registerEvent(backpackOpenEventClass, listener, EventPriority.NORMAL, (passedlistener, event) -> {
                if (event.getClass() != backpackOpenEventClass) {
                    return;
                }
                try {
                    ItemStack item = (ItemStack)getShulkerBoxMethod.invoke((Object)event, new Object[0]);
                    if (ElevatorHelper.isElevator(item)) {
                        ((Cancellable)event).setCancelled(true);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }, (Plugin)Elevators.getInstance(), false);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    public <T extends Event> void registerEventExecutor(Class<T> clazz, EventPriority priority, ElevatorEventExecutor<T> executor, boolean ignoreCancelled) {
        Bukkit.getPluginManager().registerEvent(clazz, this.listener, priority, (listener, event) -> {
            if (clazz.isAssignableFrom(event.getClass())) {
                executor.execute(event);
            }
        }, (Plugin)Elevators.getInstance(), ignoreCancelled);
    }

    @Override
    public <T extends Event> void registerEventExecutor(Class<T> clazz, EventPriority priority, ElevatorEventExecutor<T> executor) {
        this.registerEventExecutor(clazz, priority, executor, false);
    }
}

