/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import elevators.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.models.ElevatorRecipe;
import me.keehl.elevators.api.models.IElevatorRecipeGroup;
import me.keehl.elevators.api.services.IElevatorRecipeService;
import me.keehl.elevators.api.services.configs.versions.IConfigRoot;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.services.ElevatorService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.permissions.Permissible;

public class ElevatorRecipeService
extends ElevatorService
implements IElevatorRecipeService {
    private boolean initialized = false;
    private Map<NamespacedKey, ElevatorRecipe> loadedRecipes = new HashMap<NamespacedKey, ElevatorRecipe>();

    public ElevatorRecipeService(IElevators elevators) {
        super(elevators);
    }

    @Override
    public void onInitialize() {
        if (this.initialized) {
            return;
        }
        ElevatorsAPI.pushAndHoldLog();
        Elevators.getConfigService().addConfigCallback(root -> this.refreshRecipes());
        this.initialized = true;
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Recipe service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void onUninitialize() {
    }

    @Override
    public void refreshRecipes() {
        ElevatorsAPI.pushAndHoldLog();
        IConfigRoot root = Elevators.getConfigService().getRootConfig();
        List<IElevatorRecipeGroup> recipeGroups = J_U_S_Stream.toList(root.getElevators().values().stream().flatMap(x -> x.getRecipeGroups().stream()));
        HashMap<NamespacedKey, ElevatorRecipe> newRecipes = new HashMap<NamespacedKey, ElevatorRecipe>();
        for (IElevatorRecipeGroup recipeGroup : recipeGroups) {
            recipeGroup.createElevatorRecipes(newRecipes);
        }
        ArrayList<NamespacedKey> toRemove = new ArrayList<NamespacedKey>(J_U_S_Stream.toList(this.loadedRecipes.keySet().stream().filter(x -> !newRecipes.containsKey(x))));
        ArrayList<ElevatorRecipe> toAdd = new ArrayList<ElevatorRecipe>(J_U_S_Stream.toList(newRecipes.values().stream().filter(x -> !this.loadedRecipes.containsKey(x.getNamespacedKey()))));
        for (ElevatorRecipe oldRecipe : this.loadedRecipes.values()) {
            if (toRemove.contains(oldRecipe.getNamespacedKey())) continue;
            ElevatorRecipe newRecipe = (ElevatorRecipe)newRecipes.get(oldRecipe.getNamespacedKey());
            Map oldChoices = oldRecipe.getRecipe().getChoiceMap();
            Map newChoices = newRecipe.getRecipe().getChoiceMap();
            for (Character character : oldChoices.keySet()) {
                RecipeChoice newChoice;
                RecipeChoice oldChoice = (RecipeChoice)oldChoices.get(character);
                if (oldChoice.equals((Object)(newChoice = (RecipeChoice)newChoices.get(character)))) continue;
                toRemove.add(oldRecipe.getNamespacedKey());
                toAdd.add(newRecipe);
                break;
            }
            if (toRemove.contains(oldRecipe.getNamespacedKey()) || newRecipe.getRecipe().getResult().equals((Object)oldRecipe.getRecipe().getResult())) continue;
            toRemove.add(oldRecipe.getNamespacedKey());
            toAdd.add(newRecipe);
        }
        this.loadedRecipes = newRecipes;
        toRemove.forEach(VersionHelper::removeRecipe);
        toAdd.forEach(x -> Bukkit.addRecipe((Recipe)x.getRecipe()));
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Registered " + recipeGroups.size() + " recipe groups. (" + newRecipes.size() + " recipes) " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void discoverRecipesForPlayer(Player player) {
        player.discoverRecipes(this.loadedRecipes.keySet());
    }

    @Override
    public <T extends Recipe & Keyed> boolean doesPermissibleHavePermissionForRecipe(Permissible permissible, T recipe) {
        ElevatorRecipe elevatorRecipe = this.loadedRecipes.getOrDefault(((Keyed)recipe).getKey(), null);
        if (elevatorRecipe == null) {
            return false;
        }
        IElevatorRecipeGroup recipeGroup = elevatorRecipe.getRecipeGroup();
        if (!recipeGroup.supportsMultiColorMaterials()) {
            return permissible.hasPermission(recipeGroup.getCraftPermission());
        }
        if (permissible.hasPermission(recipeGroup.getCraftPermission() + ".*")) {
            return true;
        }
        return permissible.hasPermission(elevatorRecipe.getPermission());
    }
}

