/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorSetting;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.IElevatorSettingService;
import me.keehl.elevators.api.util.InternalElevatorSettingType;
import me.keehl.elevators.events.ElevatorRegisterSettingsEvent;
import me.keehl.elevators.services.ElevatorService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public class ElevatorSettingService
extends ElevatorService
implements IElevatorSettingService {
    protected Runnable registerDefaultSettingsRunnable;
    private boolean initialized = false;
    private boolean allowSelfRegister = false;
    private final List<IElevatorSetting<?>> elevatorSettings = new ArrayList();

    public ElevatorSettingService(IElevators elevators) {
        super(elevators);
    }

    @Override
    public void onInitialize() {
        if (this.initialized) {
            return;
        }
        ElevatorsAPI.pushAndHoldLog();
        this.registerDefaultSettings();
        this.initialized = true;
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Setting service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void onUninitialize() {
    }

    private void registerDefaultSettings() {
        ElevatorsAPI.pushAndHoldLog();
        this.allowSelfRegister = true;
        if (this.registerDefaultSettingsRunnable != null) {
            this.registerDefaultSettingsRunnable.run();
        }
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Registered " + this.elevatorSettings.size() + " settings. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
        this.allowSelfRegister = false;
        Bukkit.getPluginManager().callEvent((Event)new ElevatorRegisterSettingsEvent());
    }

    @Override
    public void addSetting(IElevatorSetting<?> setting) {
        if (setting.getPlugin().getName().equalsIgnoreCase(Elevators.getInstance().getName()) && !this.allowSelfRegister) {
            throw new RuntimeException("An invalid Plugin was provided when trying to register an Elevator Setting.");
        }
        for (IElevatorSetting<?> otherSetting : this.elevatorSettings) {
            if (!otherSetting.getSettingName().equalsIgnoreCase(setting.getSettingName())) continue;
            Object message = otherSetting.getPlugin().getName().equalsIgnoreCase(Elevators.getInstance().getName()) ? "External elevator settings are not able to override default settings" : "An elevator setting with the key \"" + setting.getSettingName() + "\" was already registered by plugin: " + otherSetting.getPlugin().getName();
            throw new RuntimeException((String)message);
        }
        this.elevatorSettings.add(setting);
    }

    @Override
    public List<IElevatorSetting<?>> getElevatorSettings() {
        return new ArrayList(this.elevatorSettings);
    }

    @Override
    public Optional<IElevatorSetting<?>> getElevatorSetting(String settingsKey) {
        return this.elevatorSettings.stream().filter(s -> s.getSettingName().equalsIgnoreCase(settingsKey)).findFirst();
    }

    @Override
    public <T> T getElevatorSettingValue(IElevator elevator, String settingsKey) {
        Optional<IElevatorSetting<?>> setting = this.getElevatorSetting(settingsKey);
        if (setting.isEmpty()) {
            return null;
        }
        try {
            return (T)setting.get().getIndividualValue(elevator);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> T getElevatorSettingValue(IElevatorType elevatorType, String settingsKey) {
        Optional<IElevatorSetting<?>> setting = this.getElevatorSetting(settingsKey);
        if (setting.isEmpty()) {
            return null;
        }
        try {
            return (T)setting.get().getGlobalValue(elevatorType);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> T getElevatorSettingValue(IElevator elevator, InternalElevatorSettingType settingsKey) {
        return this.getElevatorSettingValue(elevator, settingsKey.getSettingName());
    }

    @Override
    public <T> T getElevatorSettingValue(IElevatorType elevatorType, InternalElevatorSettingType settingsKey) {
        return this.getElevatorSettingValue(elevatorType, settingsKey.getSettingName());
    }
}

