/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.IElevatorTypeService;
import me.keehl.elevators.api.services.configs.versions.IConfigRoot;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorService;
import org.bukkit.ChatColor;

public class ElevatorTypeService
extends ElevatorService
implements IElevatorTypeService {
    private IElevatorType defaultElevatorType;
    private boolean initialized = false;

    public ElevatorTypeService(IElevators elevators) {
        super(elevators);
    }

    @Override
    public void onInitialize() {
        if (this.initialized) {
            return;
        }
        ElevatorsAPI.pushAndHoldLog();
        Elevators.getConfigService().addConfigCallback(this::reloadElevatorsFromConfig);
        this.initialized = true;
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Type service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void onUninitialize() {
    }

    private void reloadElevatorsFromConfig(IConfigRoot config) {
        ElevatorsAPI.pushAndHoldLog();
        Map<String, IElevatorType> elevatorTypes = Elevators.getConfigService().getElevatorTypeConfigs();
        try {
            IElevatorType elevatorType;
            ArrayList<String> elevatorsToFix = new ArrayList<String>();
            for (String elevatorKey : elevatorTypes.keySet()) {
                if (elevatorKey.equals(elevatorKey.toUpperCase())) continue;
                elevatorsToFix.add(elevatorKey);
            }
            for (String elevatorKey : elevatorsToFix) {
                elevatorType = elevatorTypes.get(elevatorKey);
                elevatorTypes.remove(elevatorKey);
                elevatorTypes.put(elevatorKey.toUpperCase(), elevatorType);
            }
            if (!elevatorTypes.containsKey("DEFAULT")) {
                ElevatorType type = new ElevatorType();
                type.setKey("DEFAULT");
                elevatorTypes.put(type.getTypeKey(), type);
                ElevatorsAPI.log("No DEFAULT Elevator Type found. Registering new.");
            }
            this.defaultElevatorType = elevatorTypes.get("DEFAULT");
            for (String elevatorKey : elevatorTypes.keySet()) {
                elevatorType = elevatorTypes.get(elevatorKey);
                elevatorType.setKey(elevatorKey);
                elevatorType.onLoad();
            }
        }
        catch (Exception e) {
            ElevatorsAPI.log(Level.SEVERE, "Error occurred loading elevator types", e);
        }
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Registered and loaded " + elevatorTypes.size() + " elevator types. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public IElevatorType getElevatorType(String name) {
        return Elevators.getConfigService().getElevatorTypeConfigs().getOrDefault(name.toUpperCase(), null);
    }

    @Override
    public IElevatorType getDefaultElevatorType() {
        return this.defaultElevatorType;
    }

    @Override
    public boolean doesElevatorTypeExist(String name) {
        return Elevators.getConfigService().getElevatorTypeConfigs().containsKey(name.toUpperCase());
    }

    @Override
    public Collection<IElevatorType> getExistingElevatorTypes() {
        return Elevators.getConfigService().getElevatorTypeConfigs().values();
    }

    @Override
    public Set<String> getExistingElevatorKeys() {
        return Elevators.getConfigService().getElevatorTypeConfigs().keySet();
    }

    public void registerElevatorType(IElevatorType elevatorType) {
        Elevators.getConfigService().getElevatorTypeConfigs().put(elevatorType.getTypeKey().toUpperCase(), elevatorType);
        this.reloadElevatorsFromConfig(Elevators.getConfigService().getRootConfig());
    }

    @Override
    public IElevatorType createElevatorType(String typeKey) {
        typeKey = typeKey.toUpperCase();
        ElevatorType type = new ElevatorType();
        Elevators.getConfigService().getElevatorTypeConfigs().put(typeKey, type);
        this.reloadElevatorsFromConfig(Elevators.getConfigService().getRootConfig());
        return this.getElevatorType(typeKey);
    }

    public void unregisterElevatorType(IElevatorType elevatorType) {
        Elevators.getConfigService().getElevatorTypeConfigs().remove(elevatorType.getTypeKey());
        this.reloadElevatorsFromConfig(Elevators.getConfigService().getRootConfig());
    }
}

