/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.services.IElevatorUpdateService;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.services.ElevatorService;
import me.keehl.elevators.util.folialib.wrapper.task.WrappedTask;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ElevatorUpdateService
extends ElevatorService
implements IElevatorUpdateService {
    private static final String apiEndpoint = "https://hangar.papermc.io/api/v1/projects/Keehl/Elevators/latest?channel=";
    private static final String resourceURL = "https://hangar.papermc.io/Keehl/Elevators";
    private WrappedTask task;
    private int currentVersion;
    private boolean updateAvailable = false;
    private boolean checkBetaChannels = false;

    public ElevatorUpdateService(IElevators elevators) {
        super(elevators);
    }

    @Override
    public void onInitialize() {
        ElevatorsAPI.pushAndHoldLog();
        String version = Elevators.getInstance().getDescription().getVersion();
        this.checkBetaChannels = version.contains("beta");
        this.currentVersion = VersionHelper.getVersionID(version);
        Elevators.getConfigService().addConfigCallback(root -> {
            this.onUninitialize();
            if (root.isUpdateCheckerEnabled()) {
                this.task = Elevators.getFoliaLib().getScheduler().runTimerAsync(this::checkUpdate, 60L, 72000L);
            }
        });
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Update service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void onUninitialize() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
    }

    private void sendUpdateMessage(Player player) {
        if (player.hasPermission("elevators.updatenotify")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "ELEVATORS " + String.valueOf(ChatColor.WHITE) + "An update is available for Elevators at " + String.valueOf(ChatColor.GOLD) + resourceURL);
        }
    }

    @Override
    public void checkUpdate() {
        if (!this.updateAvailable) {
            int maxChannelID = -1;
            if (this.checkBetaChannels) {
                maxChannelID = Math.max(maxChannelID, this.checkResource("PreRelease"));
            }
            if ((maxChannelID = Math.max(maxChannelID, this.checkResource("Release"))) <= this.currentVersion) {
                return;
            }
            this.updateAvailable = true;
        }
        Bukkit.getOnlinePlayers().forEach(this::sendUpdateMessage);
        ElevatorsAPI.log("An update for Elevators is available at:");
        ElevatorsAPI.log(resourceURL);
    }

    @Override
    public int checkResource(String channel) {
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(apiEndpoint + channel).openConnection();
            connection.setRequestMethod("GET");
            String raw = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            return VersionHelper.getVersionID(raw);
        }
        catch (IOException e) {
            return -1;
        }
    }
}

