/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.IElevatorVersionService;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.services.ElevatorService;
import me.keehl.elevators.services.versions.ElevatorsV1;
import me.keehl.elevators.services.versions.ElevatorsV2;
import me.keehl.elevators.services.versions.ElevatorsV3;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.ItemStack;

public class ElevatorVersionService
extends ElevatorService
implements IElevatorVersionService {
    private final List<ElevatorVersion> versions = new ArrayList<ElevatorVersion>();
    private boolean initialized = false;

    public ElevatorVersionService(IElevators elevators) {
        super(elevators);
    }

    @Override
    public void onInitialize() {
        if (this.initialized) {
            return;
        }
        ElevatorsAPI.pushAndHoldLog();
        this.versions.add(new ElevatorsV3());
        this.versions.add(new ElevatorsV2());
        this.versions.add(new ElevatorsV1());
        this.initialized = true;
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Version service enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public void onUninitialize() {
    }

    @Override
    public IElevatorType getElevatorType(ItemStack item) {
        for (ElevatorVersion version : this.versions) {
            IElevatorType elevatorType = version.getElevatorType(item);
            if (elevatorType == null) continue;
            return elevatorType;
        }
        return null;
    }

    @Override
    public IElevatorType getElevatorType(ShulkerBox box, boolean updateBlock) {
        AbstractMap.SimpleEntry<Object, Object> result = new AbstractMap.SimpleEntry<Object, Object>(null, null);
        for (ElevatorVersion version : this.versions) {
            IElevatorType elevatorType = version.getElevatorType(box);
            if (elevatorType == null) continue;
            result = new AbstractMap.SimpleEntry<IElevatorType, Function<ShulkerBox, ShulkerBox>>(elevatorType, version::convertToLaterVersion);
        }
        if (result.getKey() == null) {
            return null;
        }
        if (updateBlock) {
            ShulkerBox newBox = (ShulkerBox)((Function)result.getValue()).apply(box);
            newBox = ShulkerBoxHelper.clearContents(newBox);
            if (Elevators.getConfigService().getRootConfig().shouldForceFacingUpwards()) {
                ShulkerBoxHelper.setFacingUp(newBox);
            }
        }
        return (IElevatorType)result.getKey();
    }

    @Override
    public IElevatorType getElevatorType(Block block) {
        if (ItemStackHelper.isNotShulkerBox(block.getType())) {
            return null;
        }
        return this.getElevatorType(ShulkerBoxHelper.getShulkerBox(block), true);
    }

    public static abstract class ElevatorVersion {
        public abstract IElevatorType getElevatorType(ItemStack var1);

        public abstract IElevatorType getElevatorType(ShulkerBox var1);

        public abstract IElevatorType getElevatorType(Block var1);

        public abstract ShulkerBox convertToLaterVersion(ShulkerBox var1);

        protected IElevatorType getClassFromBoxName(String name) {
            if (name == null) {
                return null;
            }
            if (Elevators.getElevatorTypeService().doesElevatorTypeExist(name)) {
                return Elevators.getElevatorTypeService().getElevatorType(name);
            }
            return Elevators.getElevatorTypeService().getDefaultElevatorType();
        }
    }
}

