/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.configs.versions.configv4_0_2;

import java.util.logging.Level;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.services.configs.ConfigVersion;
import me.keehl.elevators.services.configs.versions.configv4.V4ConfigRecipe;
import me.keehl.elevators.services.configs.versions.configv4.V4ConfigRoot;
import me.keehl.elevators.services.configs.versions.configv4_0_2.V4_0_2ConfigActions;
import me.keehl.elevators.services.configs.versions.configv4_0_2.V4_0_2ConfigRecipe;
import me.keehl.elevators.services.configs.versions.configv4_0_2.V4_0_2ConfigRoot;

public class V4_0_2ConfigVersion
extends ConfigVersion<V4ConfigRoot, V4_0_2ConfigRoot> {
    @Override
    public V4_0_2ConfigRoot upgradeVersion(V4ConfigRoot currentConfig) {
        String data;
        String action;
        boolean playerCommand;
        ElevatorsAPI.log(Level.INFO, "Converting config from V4.0.0 - V4.0.2");
        V4_0_2ConfigRoot newConfig = new V4_0_2ConfigRoot();
        newConfig.updateCheckerEnabled = currentConfig.updateCheckerEnabled;
        newConfig.cantCreateMessage = currentConfig.cantCreateMessage;
        newConfig.cantUseMessage = currentConfig.cantUseMessage;
        newConfig.cantGiveMessage = currentConfig.cantGiveMessage;
        newConfig.cantReloadMessage = currentConfig.cantReloadMessage;
        newConfig.notEnoughRoomGiveMessage = currentConfig.notEnoughRoomGiveMessage;
        newConfig.givenElevatorMessage = currentConfig.givenElevatorMessage;
        newConfig.worldDisabledMessage = currentConfig.worldDisabledMessage;
        newConfig.elevatorNowProtected = currentConfig.elevatorNowProtected;
        newConfig.elevatorNowUnprotected = currentConfig.elevatorNowUnprotected;
        newConfig.supportClaims = currentConfig.supportClaims;
        newConfig.claimProtectionDefault = currentConfig.claimProtectionDefault;
        newConfig.disabledWorlds = currentConfig.disabledWorlds;
        newConfig.worldSounds = currentConfig.worldSounds;
        newConfig.forceFacingUpwards = currentConfig.forceFacingUpwards;
        newConfig.displayName = currentConfig.displayName;
        newConfig.maxDistance = currentConfig.maxDistance;
        newConfig.maxSolidBlocks = currentConfig.maxSolidBlocks;
        newConfig.maxStackSize = currentConfig.maxStackSize;
        newConfig.coloredOutput = currentConfig.coloredOutput;
        newConfig.checkColor = currentConfig.checkColor;
        newConfig.stopObstruction = currentConfig.stopObstruction;
        newConfig.checkPerms = currentConfig.checkPerms;
        newConfig.canExplode = currentConfig.canExplode;
        newConfig.playSound = currentConfig.playSound;
        newConfig.volume = currentConfig.volume;
        newConfig.pitch = currentConfig.pitch;
        newConfig.sound = currentConfig.sound;
        newConfig.defaultColor = currentConfig.defaultColor;
        newConfig.lore = currentConfig.lore;
        V4_0_2ConfigActions actions = new V4_0_2ConfigActions();
        if (currentConfig.playSound) {
            actions.up.add(String.format("sound: %s volume=%f pitch=%f global=%b", currentConfig.sound, Float.valueOf(currentConfig.volume), Float.valueOf(currentConfig.pitch), currentConfig.worldSounds));
            actions.down.add(String.format("sound: %s volume=%f pitch=%f global=%b", currentConfig.sound, Float.valueOf(currentConfig.volume), Float.valueOf(currentConfig.pitch), currentConfig.worldSounds));
        }
        for (String command : currentConfig.commands.up) {
            playerCommand = command.toLowerCase().startsWith("player-");
            action = playerCommand ? "command-player" : "command-server";
            data = command.replace(playerCommand ? "player-" : "console-", "").trim();
            actions.up.add(String.format("%s: %s", action, data));
        }
        for (String command : currentConfig.commands.down) {
            playerCommand = command.toLowerCase().startsWith("player-");
            action = playerCommand ? "command-player" : "command-server";
            data = command.replace(playerCommand ? "player-" : "console-", "").trim();
            actions.down.add(String.format("%s: %s", action, data));
        }
        newConfig.actions = actions;
        for (String key : currentConfig.recipes.keySet()) {
            V4ConfigRecipe oldRecipe = currentConfig.recipes.get(key);
            V4_0_2ConfigRecipe newRecipe = new V4_0_2ConfigRecipe();
            newRecipe.amount = oldRecipe.amount;
            newRecipe.permission = oldRecipe.permission;
            newRecipe.coloredCrafting = oldRecipe.coloredCrafting;
            newRecipe.recipe = oldRecipe.recipe;
            newRecipe.materials = oldRecipe.materials;
            newConfig.recipes.put(key, newRecipe);
        }
        return newConfig;
    }
}

