/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.configs.versions.configv5_1_0;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.util.config.RecipeRow;
import me.keehl.elevators.services.configs.ConfigVersion;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigEffect;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigElevatorType;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigHookData;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigRecipe;
import me.keehl.elevators.services.configs.versions.configv5.V5ConfigRoot;
import me.keehl.elevators.services.configs.versions.configv5_1_0.V5_1_0ConfigEffect;
import me.keehl.elevators.services.configs.versions.configv5_1_0.V5_1_0ConfigElevatorType;
import me.keehl.elevators.services.configs.versions.configv5_1_0.V5_1_0ConfigHookData;
import me.keehl.elevators.services.configs.versions.configv5_1_0.V5_1_0ConfigLocale;
import me.keehl.elevators.services.configs.versions.configv5_1_0.V5_1_0ConfigRecipe;
import me.keehl.elevators.services.configs.versions.configv5_1_0.V5_1_0ConfigRoot;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;

public class V5_1_0ConfigVersion
extends ConfigVersion<V5ConfigRoot, V5_1_0ConfigRoot> {
    @Override
    public V5_1_0ConfigRoot upgradeVersion(V5ConfigRoot currentConfig) {
        ElevatorsAPI.log(Level.INFO, "Converting config from V5.0.0 - V5.1.0");
        V5_1_0ConfigRoot newConfig = new V5_1_0ConfigRoot();
        newConfig.updateCheckerEnabled = currentConfig.updateCheckerEnabled;
        newConfig.effectDestination = currentConfig.effectDestination;
        newConfig.permissionMode = currentConfig.permissionMode;
        newConfig.forceFacingUpwards = currentConfig.forceFacingUpwards;
        if (currentConfig.protectionHooks != null) {
            newConfig.protectionHooks = new HashMap<String, V5_1_0ConfigHookData>();
            for (String pluginKey : currentConfig.protectionHooks.keySet()) {
                V5ConfigHookData currentHookData = currentConfig.protectionHooks.get(pluginKey);
                V5_1_0ConfigHookData newHookData = new V5_1_0ConfigHookData();
                newHookData.allowCustomization = currentHookData.allowCustomization;
                newHookData.blockNonMemberUseDefault = currentHookData.blockNonMemberUseDefault;
                newConfig.protectionHooks.put(pluginKey, newHookData);
            }
        }
        V5_1_0ConfigLocale newLocale = new V5_1_0ConfigLocale();
        newLocale.cantCreateMessage = currentConfig.locale.cantCreateMessage;
        newLocale.cantDyeMessage = currentConfig.locale.cantDyeMessage;
        newLocale.cantUseMessage = currentConfig.locale.cantUseMessage;
        newLocale.cantGiveMessage = currentConfig.locale.cantGiveMessage;
        newLocale.cantAdministrateMessage = currentConfig.locale.cantAdministrateMessage;
        newLocale.cantReloadMessage = currentConfig.locale.cantReloadMessage;
        newLocale.notEnoughRoomGiveMessage = currentConfig.locale.notEnoughRoomGiveMessage;
        newLocale.givenElevatorMessage = currentConfig.locale.givenElevatorMessage;
        newLocale.worldDisabledMessage = currentConfig.locale.worldDisabledMessage;
        newLocale.elevatorChangedKickedOut = currentConfig.locale.elevatorChangedKickedOut;
        newLocale.chatInputBackOut = currentConfig.locale.chatInputBackOut;
        newLocale.chatInputBackOutAllowReset = currentConfig.locale.chatInputBackOutAllowReset;
        newLocale.enterDisplayName = currentConfig.locale.enterDisplayName;
        newLocale.enterRecipeName = currentConfig.locale.enterRecipeName;
        newLocale.enterRecipePermission = currentConfig.locale.enterRecipePermission;
        newLocale.enterFloorName = currentConfig.locale.enterFloorName;
        newLocale.enterTitle = currentConfig.locale.enterTitle;
        newLocale.enterSubtitle = currentConfig.locale.enterSubtitle;
        newLocale.enterMessage = currentConfig.locale.enterMessage;
        newLocale.enterElevatorKey = currentConfig.locale.enterElevatorKey;
        newLocale.nonUniqueElevatorKey = currentConfig.locale.nonUniqueElevatorKey;
        newLocale.nonUniqueRecipeName = currentConfig.locale.nonUniqueRecipeName;
        newLocale.enterCommand = currentConfig.locale.enterCommand;
        newConfig.locale = newLocale;
        newConfig.allowElevatorDispense = currentConfig.allowElevatorDispense;
        newConfig.disabledWorlds = currentConfig.disabledWorlds;
        newConfig.effects = new HashMap<String, V5_1_0ConfigEffect>();
        for (String effectKey : currentConfig.effects.keySet()) {
            V5_1_0ConfigEffect newEffect = new V5_1_0ConfigEffect();
            V5ConfigEffect currentEffect = currentConfig.effects.get(effectKey);
            newEffect.file = currentEffect.file;
            newEffect.scale = currentEffect.scale;
            newEffect.duration = currentEffect.duration;
            newEffect.useHolo = currentEffect.useHolo;
            newEffect.background = currentEffect.background;
            newConfig.effects.put(effectKey, newEffect);
        }
        newConfig.elevators = new HashMap<String, V5_1_0ConfigElevatorType>();
        for (String key : currentConfig.elevators.keySet()) {
            V5ConfigElevatorType oldElevatorType = currentConfig.elevators.get(key);
            V5_1_0ConfigElevatorType newElevatorType = new V5_1_0ConfigElevatorType();
            newElevatorType.displayName = oldElevatorType.getDisplayName();
            newElevatorType.usePermission = oldElevatorType.getUsePermission();
            newElevatorType.dyePermission = oldElevatorType.getDyePermission();
            newElevatorType.maxDistance = oldElevatorType.getMaxDistanceAllowedBetweenElevators();
            newElevatorType.maxSolidBlocks = oldElevatorType.getMaxSolidBlocksAllowedBetweenElevators();
            newElevatorType.maxStackSize = oldElevatorType.getMaxStackSize();
            newElevatorType.classCheck = oldElevatorType.checkDestinationElevatorType();
            newElevatorType.stopObstruction = oldElevatorType.shouldStopObstructedTeleport();
            newElevatorType.supportDying = oldElevatorType.canElevatorBeDyed();
            newElevatorType.checkColor = oldElevatorType.shouldValidateSameColor();
            newElevatorType.checkPerms = oldElevatorType.doesElevatorRequirePermissions();
            newElevatorType.canExplode = oldElevatorType.canElevatorExplode();
            newElevatorType.hologramLines = oldElevatorType.getHolographicLines();
            newElevatorType.loreLines = oldElevatorType.getLore();
            newElevatorType.actions = new V5_1_0ConfigElevatorType.ConfigActions();
            newElevatorType.actions.up = oldElevatorType.getActionsConfig().up;
            newElevatorType.actions.down = oldElevatorType.getActionsConfig().down;
            newElevatorType.disabledSettings = oldElevatorType.getDisabledSettings();
            newElevatorType.recipes = new HashMap<String, V5_1_0ConfigRecipe>();
            for (String recipeKey : oldElevatorType.getRecipeMap().keySet()) {
                V5ConfigRecipe oldRecipe = oldElevatorType.getRecipeMap().get(recipeKey);
                V5_1_0ConfigRecipe newRecipe = new V5_1_0ConfigRecipe();
                newRecipe.defaultOutputColor = oldRecipe.getDefaultOutputColor();
                newRecipe.supportMultiColorOutput = oldRecipe.supportsMultiColorOutput();
                newRecipe.supportMultiColorMaterials = oldRecipe.supportsMultiColorMaterials();
                newRecipe.craftPermission = oldRecipe.getCraftPermission();
                newRecipe.amount = oldRecipe.getAmount();
                ArrayList<RecipeRow<NamespacedKey>> keyList = new ArrayList<RecipeRow<NamespacedKey>>();
                for (int i = 0; i < 3; ++i) {
                    RecipeRow keyRow = new RecipeRow();
                    if (oldRecipe.getRecipe().size() <= i) {
                        keyList.add(keyRow);
                        continue;
                    }
                    String line = oldRecipe.getRecipe().get(i);
                    keyRow.add(oldRecipe.getMaterials().getOrDefault(Character.valueOf(!line.isEmpty() ? line.charAt(0) : (char)' '), Material.AIR).getKey());
                    keyRow.add(oldRecipe.getMaterials().getOrDefault(Character.valueOf(line.length() > 1 ? line.charAt(1) : (char)' '), Material.AIR).getKey());
                    keyRow.add(oldRecipe.getMaterials().getOrDefault(Character.valueOf(line.length() > 2 ? line.charAt(2) : (char)' '), Material.AIR).getKey());
                    keyList.add(keyRow);
                }
                newRecipe.recipe = keyList;
                newElevatorType.recipes.put(recipeKey, newRecipe);
            }
            newConfig.elevators.put(key, newElevatorType);
            newElevatorType.onLoad();
        }
        return newConfig;
    }
}

