/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.configs.versions.configv5_2_0;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.keehl.elevators.api.models.IElevatorRecipeGroup;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.api.services.configs.versions.IConfigElevatorType;
import me.keehl.elevators.models.ElevatorRecipeGroup;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigSettings;
import me.keehl.elevators.util.config.Comments;

public class ConfigElevatorType
implements IConfigElevatorType {
    @Comments(value={"Control default setting values of the elevator type."})
    protected ConfigSettings settings = new ConfigSettings();
    @Comments(value={"Define actions that can be run on elevator usage.", "Default actions are:", "action-bar, boss-bar, command-console", "command-player, message-all, message-player", "sound, title, effect, cost, trigger-observer, charge-exp", "", "If you do not wish to use actions on use, you can either delete the actions section", "or set the \"up\" and \"down\" values to an empty array with \"[]\". PlaceholderAPI is supported.", "Some default effects are: \"arrow\",\"helix\", \"sparkles\"", "", "IF AN IDENTIFIER KEY HAS BEEN GENERATED, DO NOT MESS WITH IT OR INDIVIDUAL ELEVATOR DATA MAY BE LOST."})
    protected ConfigActions actions = new ConfigActions();
    @Comments(value={"Define elevator settings that should not be customizable by users.", "Available settings are:", "can-explode, check-color, check-perms, check-type, change-holo, stop-obstruction", "", "Custom actions may have their own settings that can be disabled through use of the action key, a forward-slash, and the setting name.", "Available action settings are:", "message-player/message, sound/sound, sound/volume, sound/pitch, title/title, title/subtitle, action-bar/message, boss-bar/message, effect/effect"})
    protected List<String> disabledSettings = Arrays.asList("change-holo", "sound/sound", "action-bar/message", "boss-bar/message", "message-player/message", "title/title", "title/subtitle", "effect/effect");
    @Comments(value={"Define recipes to craft an elevator type. If you do not wish to have any recipes, replace the section", "with an empty map by settings recipes to \"{}\". Example:", "recipes: {}"})
    protected Map<String, IElevatorRecipeGroup> recipes = new HashMap<String, IElevatorRecipeGroup>(){
        {
            this.put("classic", new ElevatorRecipeGroup());
        }
    };

    @Override
    public ILocaleComponent getDisplayName() {
        return this.settings.displayName;
    }

    @Override
    public String getUsePermission() {
        return this.settings.usePermission;
    }

    @Override
    public String getDyePermission() {
        return this.settings.dyePermission;
    }

    @Override
    public int getMaxStackSize() {
        return this.settings.maxStackSize;
    }

    @Override
    public List<ILocaleComponent> getLore() {
        return this.settings.loreLines;
    }

    @Override
    public int getMaxDistanceAllowedBetweenElevators() {
        return this.settings.maxDistance;
    }

    @Override
    public int getMaxSolidBlocksAllowedBetweenElevators() {
        return this.settings.maxSolidBlocks;
    }

    @Override
    public boolean checkDestinationElevatorType() {
        return this.settings.classCheck;
    }

    @Override
    public boolean doesElevatorRequirePermissions() {
        return this.settings.checkPerms;
    }

    @Override
    public boolean canElevatorExplode() {
        return this.settings.canExplode;
    }

    @Override
    public boolean canElevatorBeDyed() {
        return this.settings.supportDying;
    }

    @Override
    public boolean shouldStopObstructedTeleport() {
        return this.settings.stopObstruction;
    }

    @Override
    public boolean shouldValidateSameColor() {
        return this.settings.checkColor;
    }

    @Override
    public boolean shouldAllowIndividualEdit() {
        return this.settings.canEditIndividually;
    }

    @Override
    public List<String> getDisabledSettings() {
        return this.disabledSettings;
    }

    @Override
    public IConfigElevatorType.IConfigActions getActionsConfig() {
        return this.actions;
    }

    @Override
    public Map<String, IElevatorRecipeGroup> getRecipeMap() {
        return this.recipes;
    }

    @Override
    public List<ILocaleComponent> getHolographicLines() {
        return this.settings.hologramLines;
    }

    public static class ConfigActions
    implements IConfigElevatorType.IConfigActions {
        public List<String> up = Collections.singletonList("sound: ENTITY_BLAZE_SHOOT pitch=2.0 volume=1.0");
        public List<String> down = Collections.singletonList("sound: ENTITY_BLAZE_SHOOT pitch=2.0 volume=1.0");

        @Override
        public List<String> getUpActions() {
            return this.up;
        }

        @Override
        public List<String> getDownActions() {
            return this.down;
        }
    }
}

