/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.interaction;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.logging.Level;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.api.services.interaction.DisplayClickResult;
import me.keehl.elevators.api.services.interaction.DisplaySlotData;
import me.keehl.elevators.api.services.interaction.ISimpleDisplay;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleDisplay
implements Listener,
ISimpleDisplay {
    private final JavaPlugin plugin;
    private final Player player;
    private final Inventory inventory;
    private final DisplayClickResult defaultClickResult;
    private final DisplayClickResult outOfMenuDefaultClickResult;
    private Runnable returnRunnable;
    private boolean blockReturn = false;
    private final Map<Integer, DisplaySlotData> slotDataMap = new HashMap<Integer, DisplaySlotData>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private DisplayClickFlag[] initialFlags;
    private BiFunction<InventoryClickEvent, ISimpleDisplay, DisplayClickResult> initialOnClick;

    public SimpleDisplay(JavaPlugin plugin, Player player, Inventory inventory) {
        this(plugin, player, inventory, null);
    }

    public SimpleDisplay(JavaPlugin plugin, Player player, Inventory inventory, Runnable returnRunnable) {
        this(plugin, player, inventory, returnRunnable, DisplayClickResult.CANCEL);
    }

    public SimpleDisplay(JavaPlugin plugin, Player player, Inventory inventory, Runnable returnRunnable, DisplayClickResult defaultClickResult) {
        this(plugin, player, inventory, returnRunnable, defaultClickResult, DisplayClickResult.CANCEL);
    }

    public SimpleDisplay(JavaPlugin plugin, Player player, Inventory inventory, Runnable returnRunnable, DisplayClickResult defaultClickResult, DisplayClickResult outOfMenuDefaultClickResult) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = inventory;
        this.defaultClickResult = defaultClickResult;
        this.outOfMenuDefaultClickResult = outOfMenuDefaultClickResult;
        this.returnRunnable = returnRunnable;
    }

    @Override
    public ISimpleDisplay setItem(int index, ItemStack itemstack, BiFunction<InventoryClickEvent, ISimpleDisplay, DisplayClickResult> onClick, DisplayClickFlag ... flags) {
        this.slotDataMap.remove(index);
        this.slotDataMap.put(index, new DisplaySlotData(index, itemstack, flags, onClick));
        this.inventory.setItem(index, itemstack);
        return this;
    }

    @Override
    public ISimpleDisplay setItemSimple(int index, ItemStack itemstack, BiConsumer<InventoryClickEvent, ISimpleDisplay> onClick, DisplayClickFlag ... flags) {
        return this.setItem(index, itemstack, (event, myDisplay) -> {
            onClick.accept((InventoryClickEvent)event, (ISimpleDisplay)myDisplay);
            return DisplayClickResult.DEFAULT;
        }, flags);
    }

    @Override
    public ISimpleDisplay setReturnButton(int index, ItemStack itemstack, DisplayClickFlag ... flags) {
        return this.setItem(index, itemstack, (event, myDisplay) -> {
            myDisplay.returnOrClose();
            return DisplayClickResult.DEFAULT;
        }, flags);
    }

    @Override
    public ISimpleDisplay clearActions() {
        this.slotDataMap.clear();
        return this;
    }

    @Override
    public void close(boolean executeReturn) {
        if (!executeReturn) {
            HandlerList.unregisterAll((Listener)this);
        }
        this.player.closeInventory();
    }

    @Override
    public void open() {
        this.player.openInventory(this.inventory);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void returnOrClose() {
        HandlerList.unregisterAll((Listener)this);
        if (this.returnRunnable != null && !this.blockReturn) {
            this.returnRunnable.run();
        } else {
            this.player.closeInventory();
        }
    }

    @Override
    public void stopReturn() {
        this.blockReturn = true;
    }

    @Override
    public ISimpleDisplay onClick(BiFunction<InventoryClickEvent, ISimpleDisplay, DisplayClickResult> onClick, DisplayClickFlag ... initialFlags) {
        this.initialFlags = initialFlags;
        this.initialOnClick = onClick;
        return this;
    }

    @Override
    public ISimpleDisplay onReturn(Runnable onReturn) {
        this.returnRunnable = onReturn;
        return this;
    }

    private DisplayClickResult validateSlotClicks(InventoryClickEvent event) {
        if (event.getClickedInventory() != this.inventory) {
            return DisplayClickResult.DEFAULT;
        }
        int clickedSlot = event.getSlot();
        if (!this.slotDataMap.containsKey(clickedSlot)) {
            return DisplayClickResult.DEFAULT;
        }
        DisplaySlotData slotData = this.slotDataMap.get(clickedSlot);
        if (!DisplayClickFlag.isValid(event, slotData.getFlags())) {
            return DisplayClickResult.DEFAULT;
        }
        try {
            return slotData.click(event, this);
        }
        catch (Exception ignore) {
            return this.defaultClickResult;
        }
    }

    private DisplayClickResult validateInitialClick(InventoryClickEvent event) {
        if (this.initialOnClick == null) {
            return DisplayClickResult.DEFAULT;
        }
        if (this.initialFlags != null && !DisplayClickFlag.isValid(event, this.initialFlags)) {
            return DisplayClickResult.DEFAULT;
        }
        try {
            return this.initialOnClick.apply(event, this);
        }
        catch (Exception ignore) {
            return this.defaultClickResult;
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.inventory) {
            return;
        }
        DisplayClickResult defaultResult = event.getClickedInventory() == event.getWhoClicked().getInventory() ? this.outOfMenuDefaultClickResult : this.defaultClickResult;
        DisplayClickResult clickResult = DisplayClickResult.combineResults(defaultResult, this.validateSlotClicks(event), this.validateInitialClick(event));
        event.setCancelled(clickResult == DisplayClickResult.CANCEL);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        if (this.returnRunnable == null) {
            return;
        }
        if (this.blockReturn) {
            return;
        }
        try {
            Elevators.getFoliaLib().getScheduler().runAtEntityLater((Entity)event.getPlayer(), this.returnRunnable, 1L);
        }
        catch (Exception e) {
            ElevatorsAPI.log(Level.WARNING, "An error occurred on closing a SimpleDisplay.", e);
        }
    }

    @Override
    public <T> T getOrDefaultCache(String key, T defaultT) {
        if (!this.cache.containsKey(key)) {
            return defaultT;
        }
        return (T)this.cache.get(key);
    }

    @Override
    public void setCache(String key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasReturn() {
        return this.returnRunnable != null;
    }
}

