/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.api.services.IElevatorDataContainerService;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.api.util.InternalElevatorSettingType;
import me.keehl.elevators.helpers.ElevatorMenuHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.helpers.TagHelper;
import me.keehl.elevators.services.interaction.PagedDisplay;
import me.keehl.elevators.services.interaction.SimpleInput;
import me.keehl.elevators.settings.InternalElevatorSetting;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class HologramLinesSetting
extends InternalElevatorSetting<ILocaleComponent[]> {
    public HologramLinesSetting(JavaPlugin plugin) {
        super(plugin, InternalElevatorSettingType.HOLO_LINES.getSettingName(), "Hologram Lines", "Click to alter the hologram lines that appear above the elevator.", Material.PAPER, ChatColor.YELLOW);
        this.setupDataStore("hologram-lines", IElevatorDataContainerService.localeComponentArrayPersistentDataType);
        this.addAction("Left Click", "Edit Text");
    }

    private void addLine(Player player, ILocaleComponent[] currentValue, Consumer<ILocaleComponent[]> completeConsumer) {
        player.closeInventory();
        SimpleInput input = new SimpleInput(Elevators.getInstance(), player);
        input.onComplete(result -> {
            if (result == null) {
                completeConsumer.accept(currentValue);
                return SimpleInput.SimpleInputResult.STOP;
            }
            ILocaleComponent[] lines = Arrays.copyOf(currentValue, currentValue.length + 1);
            lines[lines.length - 1] = MessageHelper.getLocaleComponent(result);
            completeConsumer.accept(lines);
            return SimpleInput.SimpleInputResult.STOP;
        });
        input.onCancel(() -> completeConsumer.accept(currentValue));
        Elevators.getLocale().getEnterMessageMessage().send((CommandSender)player);
        input.start();
    }

    private void editLines(Player player, Runnable returnMethod, InventoryClickEvent clickEvent, ILocaleComponent[] currentValue, Consumer<ILocaleComponent[]> setValueMethod) {
        ArrayList<ILocaleComponent> messages = new ArrayList<ILocaleComponent>(Arrays.asList(currentValue));
        PagedDisplay<ILocaleComponent> display = new PagedDisplay<ILocaleComponent>(Elevators.getInstance(), player, messages, "Admin > Settings > Hologram", returnMethod);
        ArrayList materials = new ArrayList(TagHelper.ITEMS_BOOKSHELF_BOOKS.getValues());
        display.onCreateItem(message -> {
            int hashCode = Math.abs(message.hashCode());
            Material book = (Material)materials.get(hashCode % materials.size());
            ChatColor color = ChatColor.getByChar((String)Integer.toHexString(hashCode % 16));
            if (color == ChatColor.BLACK) {
                color = ChatColor.GOLD;
            }
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Value: " + String.valueOf(ChatColor.GRAY) + message.toLegacyText());
            lore.add("");
            lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Left Click: " + String.valueOf(ChatColor.GRAY) + "Move up line");
            lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Right Click: " + String.valueOf(ChatColor.GRAY) + "Move back line");
            lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Shift Click: " + String.valueOf(ChatColor.GRAY) + "Delete line");
            return ItemStackHelper.createItem(String.valueOf(color) + String.valueOf(ChatColor.BOLD) + "Line " + (messages.indexOf(message) + 1), book, 1, lore);
        });
        display.onClick((item, event, myDisplay) -> {
            int currentIndex = messages.indexOf(item);
            ILocaleComponent[] value = messages.toArray(new ILocaleComponent[0]);
            if (event.isShiftClick()) {
                display.stopReturn();
                ElevatorMenuHelper.openConfirmMenu(player, confirm -> {
                    ILocaleComponent[] newValue = messages.toArray(new ILocaleComponent[0]);
                    if (confirm.booleanValue()) {
                        messages.remove(item);
                        newValue = messages.toArray(new ILocaleComponent[0]);
                        setValueMethod.accept(newValue);
                    }
                    this.editLines(player, returnMethod, clickEvent, newValue, setValueMethod);
                });
                return;
            }
            if (event.isLeftClick()) {
                if (currentIndex > 0) {
                    ILocaleComponent priorMessage = value[currentIndex - 1];
                    value[currentIndex - 1] = item;
                    value[currentIndex] = priorMessage;
                }
            } else if (event.isRightClick() && currentIndex < messages.size() - 1) {
                ILocaleComponent afterMessage = value[currentIndex + 1];
                value[currentIndex + 1] = item;
                value[currentIndex] = afterMessage;
            }
            setValueMethod.accept(value);
            myDisplay.stopReturn();
            this.editLines(player, returnMethod, clickEvent, value, setValueMethod);
        });
        display.onLoad((tempDisplay, page) -> {
            int addIndex = display.getDisplay().getInventory().getSize() - 1;
            display.getDisplay().setItemSimple(addIndex, ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Add Line", Material.NETHER_STAR, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                this.addLine(player, currentValue, value -> {
                    setValueMethod.accept((ILocaleComponent[])value);
                    this.editLines(player, returnMethod, clickEvent, (ILocaleComponent[])value, setValueMethod);
                });
            }, new DisplayClickFlag[0]);
        });
        display.open();
    }

    @Override
    public void onClickGlobal(Player player, IElevatorType elevatorType, Runnable returnMethod, InventoryClickEvent clickEvent, ILocaleComponent[] currentValue) {
        this.editLines(player, returnMethod, clickEvent, currentValue, value -> elevatorType.setHologramLines(Arrays.asList(value)));
    }

    @Override
    public void onClickIndividual(Player player, IElevator elevator, Runnable returnMethod, InventoryClickEvent clickEvent, ILocaleComponent[] currentValue) {
        this.editLines(player, returnMethod, clickEvent, currentValue, value -> this.setIndividualValue(elevator, value));
    }

    @Override
    public ILocaleComponent[] getGlobalValue(IElevatorType elevatorType) {
        return elevatorType.getHolographicLines().toArray(new ILocaleComponent[0]);
    }

    @Override
    public boolean canBeEditedIndividually(IElevator elevator) {
        return true;
    }

    @Override
    public ItemStack createIcon(Object value, boolean global) {
        ArrayList<Object> lore = new ArrayList<Object>();
        ILocaleComponent[] loreLines = (ILocaleComponent[])value;
        ItemMeta templateMeta = this.iconTemplate.getItemMeta();
        if (templateMeta.hasLore()) {
            lore.addAll(Objects.requireNonNull(templateMeta.getLore()));
        }
        lore.add("");
        if (loreLines.length == 0) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Current Value: " + String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "None");
        } else {
            lore.add(String.valueOf(ChatColor.GRAY) + "Current Value: ");
            for (ILocaleComponent line : loreLines) {
                lore.add(String.valueOf(ChatColor.WHITE) + line.toLegacyText());
            }
        }
        ItemStack icon = this.iconTemplate.clone();
        ItemMeta iconMeta = icon.getItemMeta();
        iconMeta.setLore(lore);
        icon.setItemMeta(iconMeta);
        return icon;
    }
}

