/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.util.config.Config;
import me.keehl.elevators.api.util.config.converter.IFieldData;
import me.keehl.elevators.api.util.config.nodes.ConfigNode;
import me.keehl.elevators.util.config.BlankConfig;
import me.keehl.elevators.util.config.Comments;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.ConfigFieldName;
import me.keehl.elevators.util.config.ExpandableConfig;

public class ConfigConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> deserializeNodeWithFieldAndObject(ConfigNode<?> parentNode, String key, Object object, IFieldData fieldData) throws Exception {
        try {
            ConfigNode<?> myNode;
            Object obj;
            Object rawData = parentNode.getRoot().getObjectAtPath(key, new HashMap());
            if (!(object instanceof Config) || object.getClass().isInterface()) {
                object = fieldData.getFieldClass() == Config.class ? new BlankConfig(rawData) : ConfigConfigConverter.getRemappedClass(fieldData.getFieldClass()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if ((obj = (myNode = ConfigConverter.createNodeWithData(parentNode, key, object, fieldData.getField())).getValue()) instanceof Config) {
                Config config = (Config)obj;
                config.setKey(key);
                config.setNode(myNode);
            }
            this.constructMapToConfig(parentNode, myNode, rawData, fieldData);
            if (myNode.getValue() instanceof Config) {
                ((Config)myNode.getValue()).onLoad();
            }
            return myNode;
        }
        catch (Exception e) {
            ElevatorsAPI.log(Level.SEVERE, "Error failed loading. Key: \"" + key + "\"", e);
            return null;
        }
    }

    public void constructMapToConfig(ConfigNode<?> parentNode, ConfigNode<?> myNode, Object rawData, IFieldData fieldData) throws Exception {
        ConfigNode<?> childNode;
        ConfigConverter converter;
        Config configObj = (Config)myNode.getValue();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = fieldData.getFieldClass(); current != null; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        for (Field childField : fields) {
            if (Modifier.isTransient(childField.getModifiers()) || Modifier.isFinal(childField.getModifiers()) || !childField.trySetAccessible()) continue;
            ConfigConverter.FieldData childFieldData = new ConfigConverter.FieldData(childField);
            ConfigFieldName fieldName = childField.getAnnotation(ConfigFieldName.class);
            String path = fieldName != null ? fieldName.value() : childField.getName();
            Object fieldObject = childField.get(configObj);
            if (fieldObject == null) {
                try {
                    fieldObject = ConfigConfigConverter.getRemappedClass(childField.getType()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if (Map.class.isAssignableFrom(childField.getType())) {
                        fieldObject = new HashMap();
                    }
                    if (Set.class.isAssignableFrom(childField.getType())) {
                        fieldObject = new HashSet();
                    }
                    if (List.class.isAssignableFrom(childField.getType())) {
                        fieldObject = new ArrayList();
                    }
                    if (!childField.isEnumConstant()) continue;
                    fieldObject = childField.getType().getEnumConstants()[0];
                }
            }
            Object yamlObject = parentNode.getRoot().getObjectAtPath(myNode.getChildPath(path), fieldObject);
            converter = ConfigConverter.getConverter(childField.getType());
            childNode = converter != null ? converter.deserializeNodeWithFieldAndObject(myNode, path, yamlObject, childFieldData) : ConfigConverter.createNodeWithData(myNode, path, yamlObject, childField);
            if (childField.isAnnotationPresent(Comments.class)) {
                Comments comments = childField.getAnnotation(Comments.class);
                for (String comment : comments.value()) {
                    childNode.addComment(comment);
                }
            }
            myNode.getChildren().add(childNode);
            if (!(configObj instanceof ExpandableConfig)) continue;
            ((ExpandableConfig)configObj).data.put(path, childNode);
        }
        if (!(configObj instanceof ExpandableConfig)) {
            return;
        }
        ExpandableConfig expandableConfig = (ExpandableConfig)configObj;
        expandableConfig.parentNode = myNode;
        if (!(rawData instanceof Map)) {
            return;
        }
        Map mapData = (Map)rawData;
        for (Object objKey : mapData.keySet()) {
            String key = objKey.toString();
            Object obj = mapData.get(key);
            ConfigConverter.FieldData childFieldData = new ConfigConverter.FieldData(null, obj.getClass(), obj.getClass());
            converter = ConfigConverter.getConverter(obj.getClass());
            childNode = converter != null ? converter.deserializeNodeWithFieldAndObject(myNode, key, obj, childFieldData) : ConfigConverter.createNodeWithData(myNode, key, obj, null);
            myNode.getChildren().add(childNode);
            expandableConfig.setData(key, childNode.getValue());
        }
    }

    @Override
    public Object serializeNodeToObject(ConfigNode<?> node) throws Exception {
        ((Config)node.getValue()).onSave();
        if (node.getValue() instanceof BlankConfig) {
            return ((BlankConfig)node.getValue()).convertToObject();
        }
        LinkedHashMap newMap = new LinkedHashMap();
        for (ConfigNode<?> childNode : node.getChildren()) {
            Object value = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(value.getClass());
            if (converter != null) {
                value = converter.serializeNodeToObject(childNode);
            }
            newMap.put(childNode.getKey(), value);
        }
        return newMap;
    }

    @Override
    public Object serializeValueToYamlObject(Object configObj) throws Exception {
        if (!(configObj instanceof Config)) {
            return new HashMap();
        }
        Config config = (Config)configObj;
        config.onSave();
        if (configObj instanceof BlankConfig) {
            return ((BlankConfig)configObj).convertToObject();
        }
        LinkedHashMap newMap = new LinkedHashMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = configObj.getClass(); current != null; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        for (Field childField : fields) {
            if (Modifier.isTransient(childField.getModifiers()) || Modifier.isFinal(childField.getModifiers()) || !childField.trySetAccessible()) continue;
            String path = childField.getName();
            Object obj = childField.get(configObj);
            if (obj == null) {
                try {
                    obj = ConfigConfigConverter.getRemappedClass(childField.getType()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if (Map.class.isAssignableFrom(childField.getType())) {
                        obj = new HashMap();
                    }
                    if (Set.class.isAssignableFrom(childField.getType())) {
                        obj = new HashSet();
                    }
                    if (!childField.isEnumConstant()) continue;
                    obj = childField.getType().getEnumConstants()[0];
                }
            }
            if (obj == null) continue;
            ConfigConverter converter = ConfigConverter.getConverter(obj.getClass());
            if (converter != null) {
                obj = converter.serializeValueToYamlObject(obj);
            }
            newMap.put(path, obj);
        }
        if (!(configObj instanceof ExpandableConfig)) {
            return newMap;
        }
        ExpandableConfig expandableConfig = (ExpandableConfig)configObj;
        for (String key : expandableConfig.data.keySet()) {
            ConfigNode<?> childNode = expandableConfig.data.get(key);
            Object obj = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(obj.getClass());
            if (converter != null) {
                obj = converter.serializeValueToYamlObject(obj);
            }
            newMap.put(key, obj);
        }
        return newMap;
    }

    @Override
    public boolean supports(Class<?> type) {
        return Config.class.isAssignableFrom(type);
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        return "Config";
    }
}

