/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.util.config.converter.IFieldData;
import me.keehl.elevators.api.util.config.nodes.ConfigNode;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.nodes.ClassicConfigNode;

public class EnumConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> deserializeNodeWithFieldAndObject(ConfigNode<?> parentNode, String key, Object object, IFieldData fieldData) {
        Class<?> fieldType = fieldData.getFieldClass();
        if (object instanceof String) {
            String strValue = object.toString();
            Optional<Object> objectOpt = Arrays.stream(fieldType.getEnumConstants()).filter(i -> i.toString().equalsIgnoreCase(strValue)).findFirst();
            if (objectOpt.isPresent()) {
                object = objectOpt.get();
            } else {
                ElevatorsAPI.log(Level.WARNING, "Value at path \"" + parentNode.getPath() + "\" must be a \"" + fieldType.getSimpleName() + "\" enum value! Using default: \"" + String.valueOf(object) + "\".");
                object = fieldType.getEnumConstants()[0];
            }
        } else if (!object.getClass().isEnum()) {
            object = fieldType.getEnumConstants()[0];
            ElevatorsAPI.log(Level.WARNING, "Value at path \"" + parentNode.getPath() + "\" must be a \"" + fieldType.getSimpleName() + "\" enum value! Using default: \"" + object.toString() + "\".");
        }
        return ConfigConverter.createNodeWithData(parentNode, key, object, fieldData.getField());
    }

    @Override
    public Object serializeNodeToObject(ConfigNode<?> node) throws Exception {
        return this.serializeValueToYamlObject(node.getValue());
    }

    @Override
    public Object serializeValueToYamlObject(Object value) throws Exception {
        return value.toString();
    }

    @Override
    public boolean supports(Class<?> type) {
        return type.isEnum();
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        if (node instanceof ClassicConfigNode) {
            return ((ClassicConfigNode)node).getField().getClass().getSimpleName();
        }
        return "Enum";
    }
}

