/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import me.keehl.elevators.api.util.config.converter.IFieldData;
import me.keehl.elevators.api.util.config.nodes.ConfigNode;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.nodes.ClassicConfigNode;

public class PrimitiveConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> deserializeNodeWithFieldAndObject(ConfigNode<?> parentNode, String key, Object object, IFieldData fieldData) {
        switch (fieldData.getFieldClass().getSimpleName().toLowerCase()) {
            case "short": {
                return ConfigConverter.createNodeWithData(parentNode, key, object instanceof Short ? object : Short.valueOf(Integer.valueOf((Integer)object).shortValue()), fieldData.getField());
            }
            case "byte": {
                return ConfigConverter.createNodeWithData(parentNode, key, object instanceof Byte ? object : Byte.valueOf(Integer.valueOf((Integer)object).byteValue()), fieldData.getField());
            }
            case "float": {
                if (object instanceof Integer) {
                    return ConfigConverter.createNodeWithData(parentNode, key, Float.valueOf(Double.valueOf(((Integer)object).intValue()).floatValue()), fieldData.getField());
                }
                return ConfigConverter.createNodeWithData(parentNode, key, object instanceof Float ? object : Float.valueOf(Double.valueOf((Double)object).floatValue()), fieldData.getField());
            }
            case "char": {
                return ConfigConverter.createNodeWithData(parentNode, key, object instanceof Character ? object : Character.valueOf(((String)object).charAt(0)), fieldData.getField());
            }
            case "boolean": {
                return ConfigConverter.createNodeWithData(parentNode, key, object instanceof Boolean ? object : Boolean.valueOf(Boolean.getBoolean((String)object)), fieldData.getField());
            }
            case "integer": {
                return ConfigConverter.createNodeWithData(parentNode, key, object instanceof Integer ? object : Integer.valueOf(object.toString()), fieldData.getField());
            }
            case "long": {
                return ConfigConverter.createNodeWithData(parentNode, key, object instanceof Long ? object : Long.valueOf(object.toString()), fieldData.getField());
            }
            case "string": {
                return ConfigConverter.createNodeWithData(parentNode, key, object.toString(), fieldData.getField());
            }
        }
        return ConfigConverter.createNodeWithData(parentNode, key, object, fieldData.getField());
    }

    @Override
    public Object serializeNodeToObject(ConfigNode<?> node) throws Exception {
        return this.serializeValueToYamlObject(node.getValue());
    }

    @Override
    public Object serializeValueToYamlObject(Object value) throws Exception {
        return value;
    }

    public static Object createPrimitiveFromObj(Class<?> fieldType, Object object) {
        switch (fieldType.getSimpleName().toLowerCase()) {
            case "short": {
                return object instanceof Short ? object : Short.valueOf(Integer.valueOf((Integer)object).shortValue());
            }
            case "byte": {
                return object instanceof Byte ? object : Byte.valueOf(Integer.valueOf((Integer)object).byteValue());
            }
            case "float": {
                if (object instanceof Integer) {
                    return Float.valueOf(Double.valueOf(((Integer)object).intValue()).floatValue());
                }
                return object instanceof Float ? object : Float.valueOf(Double.valueOf((Double)object).floatValue());
            }
            case "boolean": {
                return object instanceof Boolean ? object : Boolean.valueOf(Boolean.getBoolean((String)object));
            }
            case "integer": {
                return object instanceof Integer ? object : Integer.valueOf(object.toString());
            }
            case "long": {
                return object instanceof Long ? object : Long.valueOf(object.toString());
            }
            case "character": {
                return object instanceof Character ? object : Character.valueOf(((String)object).charAt(0));
            }
            case "string": {
                return object.toString();
            }
        }
        return object.toString();
    }

    @Override
    public boolean supports(Class<?> type) {
        boolean bl;
        switch (type.getSimpleName().toLowerCase()) {
            case "boolean": 
            case "character": 
            case "byte": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "string": 
            case "integer": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        if (node instanceof ClassicConfigNode) {
            return ((ClassicConfigNode)node).getField().getClass().getSimpleName();
        }
        return "Primitive";
    }
}

