/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.faststats.core;

import java.net.URI;
import java.util.UUID;
import me.keehl.elevators.util.faststats.core.Token;
import me.keehl.elevators.util.faststats.core.chart.Chart;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Contract;

public interface Metrics {
    @Token
    @Contract(pure=true)
    public String getToken();

    @Contract(pure=true)
    public Config getConfig();

    @Contract(mutates="this")
    public void shutdown();

    public static interface Config {
        @Contract(pure=true)
        public UUID serverId();

        @Contract(pure=true)
        public boolean enabled();

        @Contract(pure=true)
        public boolean debug();
    }

    public static interface Factory<T> {
        @Contract(mutates="this")
        public Factory<T> addChart(Chart<?> var1) throws IllegalArgumentException;

        @Contract(mutates="this")
        public Factory<T> debug(boolean var1);

        @Contract(mutates="this")
        public Factory<T> token(@Token String var1) throws IllegalArgumentException;

        @Contract(mutates="this")
        public Factory<T> url(URI var1);

        @Async.Schedule
        @Contract(value="_ -> new", mutates="io")
        public Metrics create(T var1) throws IllegalStateException, IllegalArgumentException;
    }
}

