/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.faststats.core.chart;

import com.google.gson.JsonElement;
import java.util.Optional;
import java.util.concurrent.Callable;
import me.keehl.elevators.util.faststats.core.chart.ArrayChart;
import me.keehl.elevators.util.faststats.core.chart.ChartId;
import me.keehl.elevators.util.faststats.core.chart.SingleValueChart;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public interface Chart<T> {
    @ChartId
    @Contract(pure=true)
    public String getId();

    @Contract(pure=true)
    public Optional<T> compute() throws Exception;

    @Contract(pure=true)
    public Optional<JsonElement> getData() throws Exception;

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<String[]> stringArray(@ChartId String id, Callable<String @Nullable []> callable) throws IllegalArgumentException {
        return new ArrayChart(id, (Callable<T[]>)callable);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<Boolean[]> booleanArray(@ChartId String id, Callable<Boolean @Nullable []> callable) throws IllegalArgumentException {
        return new ArrayChart(id, (Callable<T[]>)callable);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<Number[]> numberArray(@ChartId String id, Callable<Number @Nullable []> callable) throws IllegalArgumentException {
        return new ArrayChart(id, (Callable<T[]>)callable);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<Boolean> bool(@ChartId String id, Callable<@Nullable Boolean> callable) throws IllegalArgumentException {
        return new SingleValueChart<Boolean>(id, callable);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<String> string(@ChartId String id, Callable<@Nullable String> callable) throws IllegalArgumentException {
        return new SingleValueChart<String>(id, callable);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static Chart<Number> number(@ChartId String id, Callable<@Nullable Number> callable) throws IllegalArgumentException {
        return new SingleValueChart<Number>(id, callable);
    }
}

