/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.faststats.core.chart;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import me.keehl.elevators.util.faststats.core.chart.Chart;
import me.keehl.elevators.util.faststats.core.chart.ChartId;
import org.jspecify.annotations.Nullable;

abstract class SimpleChart<T>
implements Chart<T> {
    @ChartId
    private final String id;
    private final Callable<@Nullable T> callable;

    public SimpleChart(@ChartId String id, Callable<@Nullable T> callable) throws IllegalArgumentException {
        if (!id.matches("[a-z_]+")) {
            throw new IllegalArgumentException("Invalid chart id '" + id + "', must match '[a-z_]+'");
        }
        this.id = id;
        this.callable = callable;
    }

    @Override
    @ChartId
    public final String getId() {
        return this.id;
    }

    @Override
    public final Optional<T> compute() throws Exception {
        return Optional.ofNullable(this.callable.call());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleChart that = (SimpleChart)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "SimpleChart{id='" + this.id + "'}";
    }
}

