/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.dialogbuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import me.keehl.dialogbuilder.api.AdapterType;
import me.keehl.dialogbuilder.api.IDialogOpener;
import me.keehl.dialogbuilder.api.IDialogPayload;
import me.keehl.dialogbuilder.api.body.IDialogBody;
import me.keehl.dialogbuilder.api.dialog.DialogActionResult;
import me.keehl.dialogbuilder.api.dialog.IDialog;
import me.keehl.dialogbuilder.api.dialog.WrappedDialog;
import me.keehl.dialogbuilder.api.dialog.action.IDialogAction;
import me.keehl.dialogbuilder.api.dialog.action.IDialogActionHolder;
import me.keehl.dialogbuilder.api.input.IDialogInput;
import me.keehl.dialogbuilder.api.input.IDialogSingleOptionInputEntry;
import me.keehl.dialogbuilder.body.DialogItemBody;
import me.keehl.dialogbuilder.body.DialogTextBody;
import me.keehl.dialogbuilder.dialog.ConfirmationDialog;
import me.keehl.dialogbuilder.dialog.Dialog;
import me.keehl.dialogbuilder.dialog.DialogAdapter;
import me.keehl.dialogbuilder.dialog.DialogListDialog;
import me.keehl.dialogbuilder.dialog.MultiActionDialog;
import me.keehl.dialogbuilder.dialog.NoticeDialog;
import me.keehl.dialogbuilder.dialog.ServerLinksDialog;
import me.keehl.dialogbuilder.dialog.action.DialogActionHolder;
import me.keehl.dialogbuilder.dialog.action.actions.CopyToClipboardAction;
import me.keehl.dialogbuilder.dialog.action.actions.DialogBuilderAction;
import me.keehl.dialogbuilder.dialog.action.actions.DynamicCustomAction;
import me.keehl.dialogbuilder.dialog.action.actions.OpenURLAction;
import me.keehl.dialogbuilder.dialog.action.actions.RunCommandAction;
import me.keehl.dialogbuilder.dialog.action.actions.ShowDialogAction;
import me.keehl.dialogbuilder.dialog.action.actions.SuggestCommandAction;
import me.keehl.dialogbuilder.input.DialogBooleanInput;
import me.keehl.dialogbuilder.input.DialogNumberRangeInput;
import me.keehl.dialogbuilder.input.DialogSingleOptionInput;
import me.keehl.dialogbuilder.input.DialogSingleOptionInputEntry;
import me.keehl.dialogbuilder.input.DialogTextInput;
import me.keehl.dialogbuilder.spigot.SpigotDialogOpener;
import me.keehl.dialogbuilder.spigot.SpigotDialogPayload;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.dialog.DialogBase;
import net.md_5.bungee.api.dialog.action.Action;
import net.md_5.bungee.api.dialog.action.ActionButton;
import net.md_5.bungee.api.dialog.action.CustomClickAction;
import net.md_5.bungee.api.dialog.action.StaticAction;
import net.md_5.bungee.api.dialog.body.DialogBody;
import net.md_5.bungee.api.dialog.body.PlainMessageBody;
import net.md_5.bungee.api.dialog.chat.ShowDialogClickEvent;
import net.md_5.bungee.api.dialog.input.BooleanInput;
import net.md_5.bungee.api.dialog.input.DialogInput;
import net.md_5.bungee.api.dialog.input.InputOption;
import net.md_5.bungee.api.dialog.input.NumberRangeInput;
import net.md_5.bungee.api.dialog.input.SingleOptionInput;
import net.md_5.bungee.api.dialog.input.TextInput;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerCustomClickEvent;

public class SpigotDialogAdapter
extends DialogAdapter<net.md_5.bungee.api.dialog.Dialog, DialogBase, DialogInput, DialogBody> {
    public SpigotDialogAdapter(String defaultNamespace) {
        super(defaultNamespace);
    }

    @Override
    public AdapterType getAdapterType() {
        return AdapterType.SPIGOT;
    }

    public BaseComponent convertStringToComponent(String message) {
        if (message == null) {
            return new TextComponent();
        }
        return TextComponent.fromLegacy((String)message);
    }

    @EventHandler
    public void onCustomClick(PlayerCustomClickEvent event) {
        NamespacedKey key = event.getId();
        Consumer action = (Consumer)this.customActions.get(key);
        if (action == null) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        action.accept(new SpigotDialogPayload(uuid, false, event.getData()));
    }

    @Override
    public DialogBody convertDialogTextBody(DialogTextBody body) {
        return new PlainMessageBody(this.convertStringToComponent(body.getText()), Integer.valueOf(body.getWidth()));
    }

    @Override
    public DialogBody convertDialogItemBody(DialogItemBody body) {
        return new PlainMessageBody(this.convertStringToComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cThis item body is not supported in Spigot!")));
    }

    @Override
    public DialogBody convertDialogBody(IDialogBody body) {
        if (body instanceof DialogTextBody) {
            DialogTextBody textBody = (DialogTextBody)body;
            return this.convertDialogTextBody(textBody);
        }
        if (body instanceof DialogItemBody) {
            DialogItemBody itemBody = (DialogItemBody)body;
            return this.convertDialogItemBody(itemBody);
        }
        return null;
    }

    @Override
    public DialogInput convertDialogTextInput(DialogTextInput input) {
        return new TextInput(input.getKey(), Integer.valueOf(input.getWidth()), this.convertStringToComponent(input.getLabel()), Boolean.valueOf(input.getLabel() != null), input.getInitial() != null ? input.getInitial() : "", Integer.valueOf(input.getMaxLength()), (TextInput.Multiline)(input.getMaxLines() == null && input.getHeight() == null ? null : new TextInput.Multiline(input.getMaxLines(), input.getHeight())));
    }

    @Override
    public DialogInput convertDialogBooleanInput(DialogBooleanInput input) {
        return new BooleanInput(input.getKey(), this.convertStringToComponent(input.getLabel()), Boolean.valueOf(input.getInitial()), input.getOnTrue() != null ? input.getOnTrue() : "true", input.getOnFalse() != null ? input.getOnFalse() : "false");
    }

    @Override
    public DialogInput convertDialogNumberRangeInput(DialogNumberRangeInput input) {
        return new NumberRangeInput(input.getKey(), Integer.valueOf(input.getWidth()), this.convertStringToComponent(input.getLabel()), input.getLabelFormat(), input.getStart(), input.getEnd(), input.getInitial(), input.getStep());
    }

    @Override
    public DialogInput convertDialogSingleOptionInput(DialogSingleOptionInput input) {
        ArrayList<InputOption> options = new ArrayList<InputOption>();
        if (input.getOptions() != null) {
            for (IDialogSingleOptionInputEntry apiOption : input.getOptions()) {
                DialogSingleOptionInputEntry option = (DialogSingleOptionInputEntry)apiOption;
                options.add(new InputOption(option.getID(), this.convertStringToComponent(option.getDisplay()), Boolean.valueOf(option.getIsDefault())));
            }
        }
        return new SingleOptionInput(input.getKey(), Integer.valueOf(input.getWidth()), this.convertStringToComponent(input.getLabel()), Boolean.valueOf(input.getLabel() != null), options);
    }

    @Override
    public DialogInput convertDialogInput(IDialogInput input) {
        if (input instanceof DialogTextInput) {
            DialogTextInput textInput = (DialogTextInput)input;
            return this.convertDialogTextInput(textInput);
        }
        if (input instanceof DialogBooleanInput) {
            DialogBooleanInput booleanInput = (DialogBooleanInput)input;
            return this.convertDialogBooleanInput(booleanInput);
        }
        if (input instanceof DialogNumberRangeInput) {
            DialogNumberRangeInput numberRangeInput = (DialogNumberRangeInput)input;
            return this.convertDialogNumberRangeInput(numberRangeInput);
        }
        if (input instanceof DialogSingleOptionInput) {
            DialogSingleOptionInput singleOptionInput = (DialogSingleOptionInput)input;
            return this.convertDialogSingleOptionInput(singleOptionInput);
        }
        return null;
    }

    public DialogBase getDialogBase(IDialog<?> apiDialog) {
        Dialog dialog = (Dialog)apiDialog;
        Optional<DialogBase.AfterAction> afterActionOpt = Arrays.stream(DialogBase.AfterAction.values()).filter(x -> x.name().equalsIgnoreCase(dialog.getAfterAction().getKey())).findFirst();
        List<DialogBody> body = dialog.getBody().stream().map(this::convertDialogBody).toList();
        List<DialogInput> input = dialog.getInput().stream().map(this::convertDialogInput).toList();
        return new DialogBase(this.convertStringToComponent(dialog.getTitle()), dialog.getExternalTitle() == null ? null : this.convertStringToComponent(dialog.getExternalTitle()), input, body, Boolean.valueOf(dialog.getCanCloseWithEscape()), Boolean.valueOf(dialog.canPause()), afterActionOpt.orElse(DialogBase.AfterAction.CLOSE));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Action createActionFromDialogAction(IDialogAction<?> apiDialogAction) {
        net.md_5.bungee.api.dialog.Dialog dialog;
        Object dialogObject;
        Object object;
        Record record;
        if (apiDialogAction instanceof CopyToClipboardAction) {
            String string;
            record = (CopyToClipboardAction)apiDialogAction;
            String value = string = ((CopyToClipboardAction)record).value();
            return new StaticAction(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, value));
        }
        if (apiDialogAction instanceof OpenURLAction) {
            String string;
            record = (OpenURLAction)apiDialogAction;
            String url = string = ((OpenURLAction)record).url();
            return new StaticAction(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        }
        if (apiDialogAction instanceof RunCommandAction) {
            String string;
            record = (RunCommandAction)apiDialogAction;
            String command = string = ((RunCommandAction)record).command();
            return new StaticAction(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        }
        if (apiDialogAction instanceof SuggestCommandAction) {
            String string;
            record = (SuggestCommandAction)apiDialogAction;
            String command = string = ((SuggestCommandAction)record).command();
            return new StaticAction(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command));
        }
        if (apiDialogAction instanceof DynamicCustomAction) {
            String string;
            record = (DynamicCustomAction)apiDialogAction;
            String namespace = string = ((DynamicCustomAction)record).namespace();
            String ID = string = ((DynamicCustomAction)record).ID();
            return new CustomClickAction(namespace + ":" + ID);
        }
        if (apiDialogAction instanceof DialogBuilderAction) {
            Function<IDialogPayload, DialogActionResult> ID;
            record = (DialogBuilderAction)apiDialogAction;
            Function<IDialogPayload, DialogActionResult> action = ID = ((DialogBuilderAction)record).action();
            String key = UUID.randomUUID().toString();
            Consumer<IDialogPayload> payloadConsumer = payload -> {
                if (action.apply((IDialogPayload)payload) == DialogActionResult.UNREGISTER) {
                    this.unregisterCustomAction("dialog-builder", key);
                }
            };
            this.registerCustomAction("dialog-builder", key, payloadConsumer);
            return new CustomClickAction("dialog-builder:" + key);
        }
        if (!(apiDialogAction instanceof ShowDialogAction)) return null;
        record = (ShowDialogAction)apiDialogAction;
        try {
            dialogObject = object = ((ShowDialogAction)record).dialog();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (dialogObject instanceof WrappedDialog) {
            String string;
            object = (WrappedDialog)dialogObject;
            String namespace = string = ((WrappedDialog)object).namespace();
            String dialogID = string = ((WrappedDialog)object).dialogID();
            return new StaticAction((ClickEvent)new ShowDialogClickEvent(namespace + ":" + dialogID));
        }
        if (dialogObject instanceof net.md_5.bungee.api.dialog.Dialog) {
            net.md_5.bungee.api.dialog.Dialog dialog2 = (net.md_5.bungee.api.dialog.Dialog)dialogObject;
            return new StaticAction((ClickEvent)new ShowDialogClickEvent(dialog2));
        }
        if (!(dialogObject instanceof SpigotDialogOpener)) return null;
        SpigotDialogOpener spigotDialogOpener = (SpigotDialogOpener)dialogObject;
        net.md_5.bungee.api.dialog.Dialog dialog2 = dialog = spigotDialogOpener.dialog();
        return new StaticAction((ClickEvent)new ShowDialogClickEvent(dialog2));
    }

    private ActionButton createActionButtonFromDialogActionHolder(IDialogActionHolder apiActionHolder) {
        DialogActionHolder actionHolder = (DialogActionHolder)apiActionHolder;
        BaseComponent toolTip = actionHolder.getTooltip() == null || actionHolder.getTooltip().isBlank() ? null : this.convertStringToComponent(actionHolder.getTooltip());
        return new ActionButton(this.convertStringToComponent(actionHolder.getLabel()), toolTip, Integer.valueOf(actionHolder.getWidth()), this.createActionFromDialogAction(actionHolder.getAction()));
    }

    private net.md_5.bungee.api.dialog.Dialog getConfirmationDialogType(ConfirmationDialog confirmationDialog, DialogBase dialogBase) {
        return new net.md_5.bungee.api.dialog.ConfirmationDialog(dialogBase, this.createActionButtonFromDialogActionHolder(confirmationDialog.getYesAction()), this.createActionButtonFromDialogActionHolder(confirmationDialog.getNoAction()));
    }

    private net.md_5.bungee.api.dialog.Dialog getMultiActionDialogType(MultiActionDialog dialog, DialogBase dialogBase) {
        List<ActionButton> buttons = dialog.getActions().stream().map(this::createActionButtonFromDialogActionHolder).toList();
        return new net.md_5.bungee.api.dialog.MultiActionDialog(dialogBase, buttons, Integer.valueOf(dialog.getColumns()), this.createActionButtonFromDialogActionHolder(dialog.getExitAction()));
    }

    private net.md_5.bungee.api.dialog.Dialog getServerLinksDialogType(ServerLinksDialog dialog, DialogBase dialogBase) {
        return new net.md_5.bungee.api.dialog.ServerLinksDialog(dialogBase, this.createActionButtonFromDialogActionHolder(dialog.getExitAction()), Integer.valueOf(dialog.getColumns()), Integer.valueOf(dialog.getButtonWidth()));
    }

    private net.md_5.bungee.api.dialog.Dialog getNoticeDialogType(NoticeDialog dialog, DialogBase dialogBase) {
        return new net.md_5.bungee.api.dialog.NoticeDialog(dialogBase, this.createActionButtonFromDialogActionHolder(dialog.getAction()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private net.md_5.bungee.api.dialog.Dialog getDialogListDialog(DialogListDialog dialogListDialog, DialogBase dialogBase) {
        ArrayList<net.md_5.bungee.api.dialog.Dialog> dialogList = new ArrayList<net.md_5.bungee.api.dialog.Dialog>();
        Iterator<Object> iterator = dialogListDialog.getDialogs().iterator();
        while (iterator.hasNext()) {
            Object dialogObject = iterator.next();
            if (dialogObject instanceof net.md_5.bungee.api.dialog.Dialog) {
                net.md_5.bungee.api.dialog.Dialog dialogLike = (net.md_5.bungee.api.dialog.Dialog)dialogObject;
                dialogList.add(dialogLike);
                continue;
            }
            if (!(dialogObject instanceof SpigotDialogOpener)) continue;
            SpigotDialogOpener spigotDialogOpener = (SpigotDialogOpener)dialogObject;
            try {
                net.md_5.bungee.api.dialog.Dialog dialog;
                net.md_5.bungee.api.dialog.Dialog dialog2 = dialog = spigotDialogOpener.dialog();
                dialogList.add(dialog2);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        return new net.md_5.bungee.api.dialog.DialogListDialog(dialogBase, dialogList, this.createActionButtonFromDialogActionHolder(dialogListDialog.getExitAction()), Integer.valueOf(dialogListDialog.getColumns()), Integer.valueOf(dialogListDialog.getButtonWidth()));
    }

    public net.md_5.bungee.api.dialog.Dialog createDialog(IDialog<?> dialog, DialogBase dialogBase) {
        if (dialog instanceof ConfirmationDialog) {
            ConfirmationDialog confirmationDialog = (ConfirmationDialog)dialog;
            return this.getConfirmationDialogType(confirmationDialog, dialogBase);
        }
        if (dialog instanceof MultiActionDialog) {
            MultiActionDialog multiActionDialog = (MultiActionDialog)dialog;
            return this.getMultiActionDialogType(multiActionDialog, dialogBase);
        }
        if (dialog instanceof ServerLinksDialog) {
            ServerLinksDialog serverLinksDialog = (ServerLinksDialog)dialog;
            return this.getServerLinksDialogType(serverLinksDialog, dialogBase);
        }
        if (dialog instanceof NoticeDialog) {
            NoticeDialog noticeDialog = (NoticeDialog)dialog;
            return this.getNoticeDialogType(noticeDialog, dialogBase);
        }
        if (dialog instanceof DialogListDialog) {
            DialogListDialog dialogListDialog = (DialogListDialog)dialog;
            return this.getDialogListDialog(dialogListDialog, dialogBase);
        }
        return null;
    }

    @Override
    public Optional<net.md_5.bungee.api.dialog.Dialog> convertDialog(IDialog<?> apiDialog) {
        DialogBase dialogBase = this.getDialogBase(apiDialog);
        if (dialogBase == null) {
            return Optional.empty();
        }
        return Optional.of(this.createDialog(apiDialog, dialogBase));
    }

    @Override
    public boolean clearDialog(UUID uuid) {
        Player player = Bukkit.getServer().getPlayer(uuid);
        if (player == null) {
            return false;
        }
        player.clearDialog();
        return true;
    }

    @Override
    public IDialogOpener opener(IDialog<?> apiDialog) {
        Optional<net.md_5.bungee.api.dialog.Dialog> dialog = this.convertDialog(apiDialog);
        return dialog.map(SpigotDialogOpener::new).orElse(null);
    }
}

