/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.dialogbuilder.body;

import java.util.function.Consumer;
import me.keehl.dialogbuilder.api.body.IDialogItemBody;
import me.keehl.dialogbuilder.api.body.IDialogTextBody;
import me.keehl.dialogbuilder.body.DialogBody;
import me.keehl.dialogbuilder.body.DialogTextBody;
import org.jetbrains.annotations.Nullable;

public class DialogItemBody
extends DialogBody
implements IDialogItemBody {
    private Object item;
    @Nullable
    private IDialogTextBody description;
    private boolean showDecorations = true;
    private boolean showTooltip = true;
    private int width = 16;
    private int height = 16;

    @Override
    public <T> IDialogItemBody item(T item) {
        this.item = item;
        return this;
    }

    @Override
    public IDialogItemBody description(@Nullable Consumer<IDialogTextBody> descriptionBuilder) {
        if (descriptionBuilder == null) {
            this.description = null;
        } else {
            DialogTextBody textBody = new DialogTextBody();
            descriptionBuilder.accept(textBody);
            this.description = textBody;
        }
        return this;
    }

    @Override
    public IDialogItemBody showDecorations(boolean showDecorations) {
        this.showDecorations = showDecorations;
        return this;
    }

    @Override
    public IDialogItemBody showTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
        return this;
    }

    @Override
    public IDialogItemBody width(@Nullable Integer width) {
        this.width = width == null ? 16 : width;
        return this;
    }

    @Override
    public IDialogItemBody height(@Nullable Integer height) {
        this.height = height == null ? 16 : height;
        return this;
    }

    public Object getItem() {
        return this.item;
    }

    @Nullable
    public IDialogTextBody getDescription() {
        return this.description;
    }

    public boolean getShowDecorations() {
        return this.showDecorations;
    }

    public boolean getShowTooltip() {
        return this.showTooltip;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

