/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.dialogbuilder.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.keehl.dialogbuilder.api.AdapterType;
import me.keehl.dialogbuilder.api.IDialogAdapter;
import me.keehl.dialogbuilder.api.IDialogOpener;
import me.keehl.dialogbuilder.api.dialog.IDialogListDialog;
import me.keehl.dialogbuilder.api.dialog.WrappedDialog;
import me.keehl.dialogbuilder.api.dialog.action.IDialogActionHolder;
import me.keehl.dialogbuilder.dialog.Dialog;
import me.keehl.dialogbuilder.dialog.action.DialogActionHolder;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class DialogListDialog
extends Dialog<IDialogListDialog>
implements IDialogListDialog {
    private final List<Object> dialogs = new ArrayList<Object>();
    @Nullable
    private DialogActionHolder exitAction;
    private int buttonWidth = 150;
    private int columns = 2;

    public DialogListDialog(IDialogAdapter<?, ?, ?, ?> adapter, String namespace) {
        super(adapter, namespace);
    }

    @Override
    protected IDialogListDialog self() {
        return this;
    }

    @Override
    public IDialogListDialog dialog(String namespace, String dialogID) {
        if (this.adapter.getAdapterType() == AdapterType.SPIGOT) {
            throw new UnsupportedOperationException("DialogListDialog does not support dialog by namespace and ID in Bungee/Spigot.");
        }
        this.dialogs.add(new WrappedDialog(namespace, dialogID));
        return this;
    }

    @Override
    public IDialogListDialog dialog(Object dialog) {
        this.dialogs.add(dialog);
        return this;
    }

    @Override
    public IDialogListDialog dialog(IDialogOpener dialogOpener) {
        this.dialogs.add(dialogOpener);
        return this;
    }

    @Override
    public IDialogListDialog columns(@Nullable Integer columns) {
        this.columns = columns == null ? 2 : columns;
        return this;
    }

    @Override
    public IDialogListDialog buttonWidth(@Nullable @Range(from=1L, to=1024L) Integer buttonWidth) {
        this.buttonWidth = buttonWidth == null ? 150 : buttonWidth;
        return this;
    }

    @Override
    public IDialogListDialog exitAction(@Nullable Consumer<IDialogActionHolder> action) {
        if (action == null) {
            this.exitAction = null;
            return this;
        }
        DialogActionHolder holder = new DialogActionHolder(this.adapter);
        action.accept(holder);
        this.exitAction = holder;
        return this;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    public List<Object> getDialogs() {
        return this.dialogs;
    }

    @Nullable
    public DialogActionHolder getExitAction() {
        return this.exitAction;
    }
}

