/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.dialogbuilder.paper;

import io.papermc.paper.dialog.DialogResponseView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class PaperDialogPayloadMap {
    private static final Field compoundField;
    private static final Method keySetMethod;

    PaperDialogPayloadMap() {
    }

    static Map<String, String> convertDialogResponseToMap(DialogResponseView response) {
        try {
            Object compound = compoundField.get(response);
            Set keys = (Set)keySetMethod.invoke(compound, new Object[0]);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : keys) {
                String text = response.getText(key);
                if (text != null) {
                    map.put(key, text);
                    continue;
                }
                Float number = response.getFloat(key);
                if (number != null) {
                    map.put(key, number.toString());
                    continue;
                }
                Boolean bool = response.getBoolean(key);
                if (bool == null) continue;
                map.put(key, bool.toString());
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> responseViewClass = Class.forName("io.papermc.paper.dialog.PaperDialogResponseView");
            compoundField = responseViewClass.getDeclaredField("payload");
            compoundField.setAccessible(true);
            keySetMethod = compoundField.getType().getDeclaredMethod("keySet", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize PaperUtil", e);
        }
    }
}

