/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.dialogbuilder;

import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.connection.PlayerGameConnection;
import io.papermc.paper.event.player.PlayerCustomClickEvent;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.body.PlainMessageDialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import io.papermc.paper.registry.set.RegistrySet;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import me.keehl.dialogbuilder.api.AdapterType;
import me.keehl.dialogbuilder.api.IDialogOpener;
import me.keehl.dialogbuilder.api.IDialogPayload;
import me.keehl.dialogbuilder.api.body.IDialogBody;
import me.keehl.dialogbuilder.api.body.IDialogTextBody;
import me.keehl.dialogbuilder.api.dialog.DialogActionResult;
import me.keehl.dialogbuilder.api.dialog.IDialog;
import me.keehl.dialogbuilder.api.dialog.WrappedDialog;
import me.keehl.dialogbuilder.api.dialog.action.IDialogAction;
import me.keehl.dialogbuilder.api.dialog.action.IDialogActionHolder;
import me.keehl.dialogbuilder.api.input.IDialogInput;
import me.keehl.dialogbuilder.api.input.IDialogSingleOptionInputEntry;
import me.keehl.dialogbuilder.body.DialogItemBody;
import me.keehl.dialogbuilder.body.DialogTextBody;
import me.keehl.dialogbuilder.dialog.ConfirmationDialog;
import me.keehl.dialogbuilder.dialog.Dialog;
import me.keehl.dialogbuilder.dialog.DialogAdapter;
import me.keehl.dialogbuilder.dialog.DialogListDialog;
import me.keehl.dialogbuilder.dialog.MultiActionDialog;
import me.keehl.dialogbuilder.dialog.NoticeDialog;
import me.keehl.dialogbuilder.dialog.ServerLinksDialog;
import me.keehl.dialogbuilder.dialog.action.DialogActionHolder;
import me.keehl.dialogbuilder.dialog.action.actions.CopyToClipboardAction;
import me.keehl.dialogbuilder.dialog.action.actions.DialogBuilderAction;
import me.keehl.dialogbuilder.dialog.action.actions.DynamicCustomAction;
import me.keehl.dialogbuilder.dialog.action.actions.OpenURLAction;
import me.keehl.dialogbuilder.dialog.action.actions.RunCommandAction;
import me.keehl.dialogbuilder.dialog.action.actions.ShowDialogAction;
import me.keehl.dialogbuilder.dialog.action.actions.SuggestCommandAction;
import me.keehl.dialogbuilder.input.DialogBooleanInput;
import me.keehl.dialogbuilder.input.DialogNumberRangeInput;
import me.keehl.dialogbuilder.input.DialogSingleOptionInput;
import me.keehl.dialogbuilder.input.DialogSingleOptionInputEntry;
import me.keehl.dialogbuilder.input.DialogTextInput;
import me.keehl.dialogbuilder.paper.PaperDialogOpener;
import me.keehl.dialogbuilder.paper.PaperDialogPayload;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;

public class PaperDialogAdapter
extends DialogAdapter<io.papermc.paper.dialog.Dialog, DialogBase, DialogInput, DialogBody> {
    public PaperDialogAdapter(String defaultNamespace) {
        super(defaultNamespace);
    }

    @Override
    public AdapterType getAdapterType() {
        return AdapterType.PAPER;
    }

    public Component convertStringToComponent(String message) {
        if (message == null) {
            return Component.empty();
        }
        if (message.contains("\u00a7")) {
            message = (String)MiniMessage.miniMessage().serialize((Component)LegacyComponentSerializer.legacySection().deserialize(message));
        }
        return MiniMessage.miniMessage().deserialize((Object)message);
    }

    @EventHandler
    public void onCustomClick(PlayerCustomClickEvent event) {
        UUID uuid;
        Consumer action = (Consumer)this.customActions.get(new NamespacedKey(event.getIdentifier().namespace(), event.getIdentifier().value()));
        if (action == null) {
            return;
        }
        PlayerCommonConnection playerCommonConnection = event.getCommonConnection();
        Objects.requireNonNull(playerCommonConnection);
        PlayerCommonConnection playerCommonConnection2 = playerCommonConnection;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlayerGameConnection.class, PlayerConfigurationConnection.class}, (Object)playerCommonConnection2, n)) {
            case 0: {
                PlayerGameConnection pgc = (PlayerGameConnection)playerCommonConnection2;
                UUID uUID = pgc.getPlayer().getUniqueId();
                break;
            }
            case 1: {
                PlayerConfigurationConnection pcc = (PlayerConfigurationConnection)playerCommonConnection2;
                UUID uUID = pcc.getProfile().getId();
                break;
            }
            default: {
                UUID uUID = uuid = null;
            }
        }
        if (uuid == null) {
            return;
        }
        action.accept(new PaperDialogPayload(uuid, false, event.getDialogResponseView()));
    }

    @Override
    public DialogBody convertDialogTextBody(DialogTextBody body) {
        return DialogBody.plainMessage((Component)this.convertStringToComponent(body.getText()), (int)body.getWidth());
    }

    @Override
    public DialogBody convertDialogItemBody(DialogItemBody body) {
        Object object = body.getItem();
        if (!(object instanceof ItemStack)) {
            return null;
        }
        ItemStack itemStack = (ItemStack)object;
        PlainMessageDialogBody description = null;
        IDialogTextBody iDialogTextBody = body.getDescription();
        if (iDialogTextBody instanceof DialogTextBody) {
            DialogTextBody textBody = (DialogTextBody)iDialogTextBody;
            description = (PlainMessageDialogBody)this.convertDialogTextBody(textBody);
        }
        return DialogBody.item((ItemStack)itemStack, (PlainMessageDialogBody)description, (boolean)body.getShowDecorations(), (boolean)body.getShowTooltip(), (int)body.getWidth(), (int)body.getHeight());
    }

    @Override
    public DialogBody convertDialogBody(IDialogBody body) {
        if (body instanceof DialogTextBody) {
            DialogTextBody textBody = (DialogTextBody)body;
            return this.convertDialogTextBody(textBody);
        }
        if (body instanceof DialogItemBody) {
            DialogItemBody itemBody = (DialogItemBody)body;
            return this.convertDialogItemBody(itemBody);
        }
        return null;
    }

    @Override
    public DialogInput convertDialogTextInput(DialogTextInput input) {
        return DialogInput.text((String)input.getKey(), (int)input.getWidth(), (Component)this.convertStringToComponent(input.getLabel()), (input.getLabel() != null ? 1 : 0) != 0, (String)(input.getInitial() != null ? input.getInitial() : ""), (int)input.getMaxLength(), (TextDialogInput.MultilineOptions)(input.getMaxLines() == null && input.getHeight() == null ? null : TextDialogInput.MultilineOptions.create((Integer)input.getMaxLines(), (Integer)input.getHeight())));
    }

    @Override
    public DialogInput convertDialogBooleanInput(DialogBooleanInput input) {
        return DialogInput.bool((String)input.getKey(), (Component)this.convertStringToComponent(input.getLabel()), (boolean)input.getInitial(), (String)(input.getOnTrue() != null ? input.getOnTrue() : "true"), (String)(input.getOnFalse() != null ? input.getOnFalse() : "false"));
    }

    @Override
    public DialogInput convertDialogNumberRangeInput(DialogNumberRangeInput input) {
        return DialogInput.numberRange((String)input.getKey(), (int)input.getWidth(), (Component)this.convertStringToComponent(input.getLabel()), (String)input.getLabelFormat(), (float)input.getStart(), (float)input.getEnd(), (Float)input.getInitial(), (Float)input.getStep());
    }

    @Override
    public DialogInput convertDialogSingleOptionInput(DialogSingleOptionInput input) {
        ArrayList<SingleOptionDialogInput.OptionEntry> options = new ArrayList<SingleOptionDialogInput.OptionEntry>();
        if (input.getOptions() != null) {
            for (IDialogSingleOptionInputEntry apiOption : input.getOptions()) {
                DialogSingleOptionInputEntry option = (DialogSingleOptionInputEntry)apiOption;
                options.add(SingleOptionDialogInput.OptionEntry.create((String)option.getID(), (Component)this.convertStringToComponent(option.getDisplay()), (boolean)option.getIsDefault()));
            }
        }
        return DialogInput.singleOption((String)input.getKey(), (int)input.getWidth(), options, (Component)this.convertStringToComponent(input.getLabel()), (input.getLabel() != null ? 1 : 0) != 0);
    }

    @Override
    public DialogInput convertDialogInput(IDialogInput input) {
        if (input instanceof DialogTextInput) {
            DialogTextInput textInput = (DialogTextInput)input;
            return this.convertDialogTextInput(textInput);
        }
        if (input instanceof DialogBooleanInput) {
            DialogBooleanInput booleanInput = (DialogBooleanInput)input;
            return this.convertDialogBooleanInput(booleanInput);
        }
        if (input instanceof DialogNumberRangeInput) {
            DialogNumberRangeInput numberRangeInput = (DialogNumberRangeInput)input;
            return this.convertDialogNumberRangeInput(numberRangeInput);
        }
        if (input instanceof DialogSingleOptionInput) {
            DialogSingleOptionInput singleOptionInput = (DialogSingleOptionInput)input;
            return this.convertDialogSingleOptionInput(singleOptionInput);
        }
        return null;
    }

    public DialogBase getDialogBase(IDialog<?> apiDialog) {
        Dialog dialog = (Dialog)apiDialog;
        Optional<DialogBase.DialogAfterAction> afterActionOpt = Arrays.stream(DialogBase.DialogAfterAction.values()).filter(x -> x.name().equalsIgnoreCase(dialog.getAfterAction().getKey())).findFirst();
        List<DialogBody> body = dialog.getBody().stream().map(this::convertDialogBody).toList();
        List<DialogInput> input = dialog.getInput().stream().map(this::convertDialogInput).toList();
        return DialogBase.create((Component)this.convertStringToComponent(dialog.getTitle()), (Component)(dialog.getExternalTitle() == null ? null : this.convertStringToComponent(dialog.getExternalTitle())), (boolean)dialog.getCanCloseWithEscape(), (boolean)dialog.canPause(), (DialogBase.DialogAfterAction)afterActionOpt.orElse(DialogBase.DialogAfterAction.CLOSE), body, input);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private io.papermc.paper.dialog.Dialog convertDialogObjectToDialog(Object dialogObject) {
        if (dialogObject instanceof WrappedDialog) {
            WrappedDialog wrappedDialog = (WrappedDialog)dialogObject;
            try {
                String string;
                String namespace = string = wrappedDialog.namespace();
                String dialogID = string = wrappedDialog.dialogID();
                return (io.papermc.paper.dialog.Dialog)RegistryAccess.registryAccess().getRegistry(RegistryKey.DIALOG).getOrThrow(Key.key((String)namespace, (String)dialogID));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (dialogObject instanceof PaperDialogOpener) {
            PaperDialogOpener paperDialogOpener = (PaperDialogOpener)dialogObject;
            {
                io.papermc.paper.dialog.Dialog dialog = paperDialogOpener.dialog();
                return dialog;
            }
        }
        if (!(dialogObject instanceof io.papermc.paper.dialog.Dialog)) return null;
        return (io.papermc.paper.dialog.Dialog)dialogObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DialogAction createActionFromDialogAction(IDialogAction<?> apiDialogAction) {
        io.papermc.paper.dialog.Dialog dialog;
        Record record;
        if (apiDialogAction instanceof CopyToClipboardAction) {
            String string;
            record = (CopyToClipboardAction)apiDialogAction;
            String value = string = ((CopyToClipboardAction)record).value();
            return DialogAction.staticAction((ClickEvent)ClickEvent.copyToClipboard((String)value));
        }
        if (apiDialogAction instanceof OpenURLAction) {
            String string;
            record = (OpenURLAction)apiDialogAction;
            String url = string = ((OpenURLAction)record).url();
            return DialogAction.staticAction((ClickEvent)ClickEvent.openUrl((String)url));
        }
        if (apiDialogAction instanceof RunCommandAction) {
            String string;
            record = (RunCommandAction)apiDialogAction;
            String command = string = ((RunCommandAction)record).command();
            return DialogAction.staticAction((ClickEvent)ClickEvent.runCommand((String)command));
        }
        if (apiDialogAction instanceof SuggestCommandAction) {
            String string;
            record = (SuggestCommandAction)apiDialogAction;
            String command = string = ((SuggestCommandAction)record).command();
            return DialogAction.staticAction((ClickEvent)ClickEvent.suggestCommand((String)command));
        }
        if (apiDialogAction instanceof DynamicCustomAction) {
            String string;
            record = (DynamicCustomAction)apiDialogAction;
            String namespace = string = ((DynamicCustomAction)record).namespace();
            String ID = string = ((DynamicCustomAction)record).ID();
            return DialogAction.customClick((Key)Key.key((String)namespace, (String)ID), null);
        }
        if (apiDialogAction instanceof DialogBuilderAction) {
            Function<IDialogPayload, DialogActionResult> ID;
            record = (DialogBuilderAction)apiDialogAction;
            Function<IDialogPayload, DialogActionResult> action = ID = ((DialogBuilderAction)record).action();
            String key = UUID.randomUUID().toString();
            Consumer<IDialogPayload> payloadConsumer = payload -> {
                if (action.apply((IDialogPayload)payload) == DialogActionResult.UNREGISTER) {
                    this.unregisterCustomAction("dialog-builder", key);
                }
            };
            this.registerCustomAction("dialog-builder", key, payloadConsumer);
            return DialogAction.customClick((Key)Key.key((String)"dialog-builder", (String)key), null);
        }
        if (!(apiDialogAction instanceof ShowDialogAction)) return null;
        record = (ShowDialogAction)apiDialogAction;
        try {
            Object key;
            Object dialogObject = key = ((ShowDialogAction)record).dialog();
            dialog = this.convertDialogObjectToDialog(dialogObject);
            if (dialog == null) return null;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DialogAction.staticAction((ClickEvent)ClickEvent.showDialog((DialogLike)dialog));
    }

    private ActionButton createActionButtonFromDialogActionHolder(IDialogActionHolder apiActionHolder) {
        DialogActionHolder actionHolder = (DialogActionHolder)apiActionHolder;
        Component toolTip = actionHolder.getTooltip() == null || actionHolder.getTooltip().isBlank() ? null : this.convertStringToComponent(actionHolder.getTooltip());
        return ActionButton.builder((Component)this.convertStringToComponent(actionHolder.getLabel())).tooltip(toolTip).width(actionHolder.getWidth()).action(this.createActionFromDialogAction(actionHolder.getAction())).build();
    }

    private DialogType getConfirmationDialogType(ConfirmationDialog confirmationDialog) {
        return DialogType.confirmation((ActionButton)this.createActionButtonFromDialogActionHolder(confirmationDialog.getYesAction()), (ActionButton)this.createActionButtonFromDialogActionHolder(confirmationDialog.getNoAction()));
    }

    private DialogType getMultiActionDialogType(MultiActionDialog dialog) {
        List<ActionButton> buttons = dialog.getActions().stream().map(this::createActionButtonFromDialogActionHolder).toList();
        return DialogType.multiAction(buttons, (ActionButton)this.createActionButtonFromDialogActionHolder(dialog.getExitAction()), (int)dialog.getColumns());
    }

    private DialogType getServerLinksDialogType(ServerLinksDialog dialog) {
        return DialogType.serverLinks((ActionButton)this.createActionButtonFromDialogActionHolder(dialog.getExitAction()), (int)dialog.getColumns(), (int)dialog.getButtonWidth());
    }

    private DialogType getNoticeDialogType(NoticeDialog dialog) {
        return DialogType.notice((ActionButton)this.createActionButtonFromDialogActionHolder(dialog.getAction()));
    }

    private DialogType getDialogListDialog(DialogListDialog dialog) {
        ArrayList<io.papermc.paper.dialog.Dialog> dialogList = new ArrayList<io.papermc.paper.dialog.Dialog>();
        for (Object dialogObject : dialog.getDialogs()) {
            io.papermc.paper.dialog.Dialog dialogLike = this.convertDialogObjectToDialog(dialogObject);
            if (dialogLike == null) continue;
            dialogList.add(dialogLike);
        }
        return DialogType.dialogList((RegistrySet)RegistrySet.valueSet((RegistryKey)RegistryKey.DIALOG, dialogList), (ActionButton)this.createActionButtonFromDialogActionHolder(dialog.getExitAction()), (int)dialog.getColumns(), (int)dialog.getButtonWidth());
    }

    public DialogType getDialogType(IDialog<?> dialog) {
        if (dialog instanceof ConfirmationDialog) {
            ConfirmationDialog confirmationDialog = (ConfirmationDialog)dialog;
            return this.getConfirmationDialogType(confirmationDialog);
        }
        if (dialog instanceof MultiActionDialog) {
            MultiActionDialog multiActionDialog = (MultiActionDialog)dialog;
            return this.getMultiActionDialogType(multiActionDialog);
        }
        if (dialog instanceof ServerLinksDialog) {
            ServerLinksDialog serverLinksDialog = (ServerLinksDialog)dialog;
            return this.getServerLinksDialogType(serverLinksDialog);
        }
        if (dialog instanceof NoticeDialog) {
            NoticeDialog noticeDialog = (NoticeDialog)dialog;
            return this.getNoticeDialogType(noticeDialog);
        }
        if (dialog instanceof DialogListDialog) {
            DialogListDialog dialogListDialog = (DialogListDialog)dialog;
            return this.getDialogListDialog(dialogListDialog);
        }
        return null;
    }

    public final Consumer<DialogRegistryEntry.Builder> getDialogBuilder(IDialog<?> dialog) {
        DialogBase dialogBase = this.getDialogBase(dialog);
        if (dialogBase == null) {
            return null;
        }
        DialogType dialogType = this.getDialogType(dialog);
        if (dialogType == null) {
            return null;
        }
        return builder -> builder.base(dialogBase).type(dialogType);
    }

    @Override
    public Optional<io.papermc.paper.dialog.Dialog> convertDialog(IDialog<?> apiDialog) {
        Consumer<DialogRegistryEntry.Builder> builderConsumer = this.getDialogBuilder(apiDialog);
        if (builderConsumer == null) {
            return Optional.empty();
        }
        io.papermc.paper.dialog.Dialog dialog = io.papermc.paper.dialog.Dialog.create(factory -> builderConsumer.accept((DialogRegistryEntry.Builder)factory.empty()));
        return Optional.of(dialog);
    }

    @Override
    public boolean clearDialog(UUID uuid) {
        Player player = Bukkit.getServer().getPlayer(uuid);
        if (player == null) {
            return false;
        }
        try {
            player.closeDialog();
        }
        catch (Throwable e) {
            player.closeInventory();
        }
        return true;
    }

    @Override
    public IDialogOpener opener(IDialog<?> apiDialog) {
        Optional<io.papermc.paper.dialog.Dialog> dialog = this.convertDialog(apiDialog);
        return dialog.map(PaperDialogOpener::new).orElse(null);
    }
}

