/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.effects.ArrowEffect;
import me.keehl.elevators.effects.HelixEffect;
import me.keehl.elevators.effects.ImageEffect;
import me.keehl.elevators.helpers.ResourceHelper;
import me.keehl.elevators.models.ElevatorEffect;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.configs.versions.configv5.ConfigEffect;
import me.keehl.elevators.services.configs.versions.configv5.ConfigRoot;

public class ElevatorEffectService {
    private static boolean initialized = false;
    private static final Map<String, ElevatorEffect> elevatorEffects = new HashMap<String, ElevatorEffect>();

    public static void init() {
        if (initialized) {
            return;
        }
        ElevatorConfigService.addConfigCallback(ElevatorEffectService::loadEffects);
        initialized = true;
    }

    private static void loadEffects(ConfigRoot rootNode) {
        elevatorEffects.clear();
        File effectDirectory = new File(Elevators.getConfigDirectory(), "effects");
        ResourceHelper.exportResource(Elevators.getInstance(), "Creeper.png", new File(effectDirectory, "Creeper.png"), false);
        elevatorEffects.put("ARROW", new ArrowEffect());
        elevatorEffects.put("HELIX", new HelixEffect());
        Map<String, ConfigEffect> effectConfigs = ElevatorConfigService.getEffectConfigs();
        for (String elevatorEffectKey : effectConfigs.keySet()) {
            ConfigEffect effectConfig = effectConfigs.get(elevatorEffectKey);
            elevatorEffectKey = elevatorEffectKey.toUpperCase();
            File effectFile = new File(effectDirectory, effectConfig.file);
            if (!effectFile.exists()) {
                Elevators.getElevatorsLogger().warning("Elevators: Could not find file for effect \"" + elevatorEffectKey + "\"");
                continue;
            }
            elevatorEffects.put(elevatorEffectKey, new ImageEffect(elevatorEffectKey, effectFile, effectConfig.scale, effectConfig.duration, effectConfig.useHolo, effectConfig.background));
        }
    }

    public static ElevatorEffect getEffectFromKey(String effectKey) {
        if (!elevatorEffects.containsKey(effectKey = effectKey.toUpperCase())) {
            return elevatorEffects.get("NONE");
        }
        return elevatorEffects.get(effectKey);
    }

    public static List<ElevatorEffect> getEffects() {
        return new ArrayList<ElevatorEffect>(elevatorEffects.values());
    }
}

