/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.configs.versions.configv5.ConfigRoot;

public class ElevatorTypeService {
    private static ElevatorType defaultElevatorType;
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            return;
        }
        ElevatorConfigService.addConfigCallback(ElevatorTypeService::reloadElevatorsFromConfig);
        initialized = true;
    }

    private static void reloadElevatorsFromConfig(ConfigRoot config) {
        ElevatorType elevatorType;
        Map<String, ElevatorType> elevatorTypes = ElevatorConfigService.getElevatorTypeConfigs();
        ArrayList<String> elevatorsToFix = new ArrayList<String>();
        for (String elevatorKey : elevatorTypes.keySet()) {
            if (elevatorKey.equals(elevatorKey.toUpperCase())) continue;
            elevatorsToFix.add(elevatorKey);
        }
        for (String elevatorKey : elevatorsToFix) {
            elevatorType = elevatorTypes.get(elevatorKey);
            elevatorTypes.remove(elevatorKey);
            elevatorTypes.put(elevatorKey.toUpperCase(), elevatorType);
        }
        if (!elevatorTypes.containsKey("DEFAULT")) {
            ElevatorType type = new ElevatorType();
            type.setKey("DEFAULT");
            elevatorTypes.put(type.getTypeKey(), type);
        }
        defaultElevatorType = elevatorTypes.get("DEFAULT");
        for (String elevatorKey : elevatorTypes.keySet()) {
            elevatorType = elevatorTypes.get(elevatorKey);
            elevatorType.setKey(elevatorKey);
            elevatorType.onLoad();
        }
    }

    public static ElevatorType getElevatorType(String name) {
        return ElevatorConfigService.getElevatorTypeConfigs().getOrDefault(name.toUpperCase(), null);
    }

    public static ElevatorType getDefaultElevatorType() {
        return defaultElevatorType;
    }

    public static boolean doesElevatorTypeExist(String name) {
        return ElevatorConfigService.getElevatorTypeConfigs().containsKey(name.toUpperCase());
    }

    public static Collection<ElevatorType> getExistingElevatorTypes() {
        return ElevatorConfigService.getElevatorTypeConfigs().values();
    }

    public static Set<String> getExistingElevatorKeys() {
        return ElevatorConfigService.getElevatorTypeConfigs().keySet();
    }

    public static void registerElevatorType(ElevatorType elevatorType) {
        ElevatorConfigService.getElevatorTypeConfigs().put(elevatorType.getTypeKey().toUpperCase(), elevatorType);
        ElevatorTypeService.reloadElevatorsFromConfig(ElevatorConfigService.getRootConfig());
    }

    public static ElevatorType createElevatorType(String typeKey) {
        typeKey = typeKey.toUpperCase();
        ElevatorType type = new ElevatorType();
        ElevatorConfigService.getElevatorTypeConfigs().put(typeKey, type);
        ElevatorTypeService.reloadElevatorsFromConfig(ElevatorConfigService.getRootConfig());
        return ElevatorTypeService.getElevatorType(typeKey);
    }

    public static void unregisterElevatorType(ElevatorType elevatorType) {
        ElevatorConfigService.getElevatorTypeConfigs().remove(elevatorType.getTypeKey());
        ElevatorTypeService.reloadElevatorsFromConfig(ElevatorConfigService.getRootConfig());
    }

    static {
        initialized = false;
    }
}

