/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.configs.versions.configv5;

import java.util.HashMap;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.models.ElevatorRecipeGroup;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.models.hooks.ProtectionHook;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.configs.ConfigVersion;
import me.keehl.elevators.services.configs.versions.configv4_0_2.V4_0_2ConfigRecipe;
import me.keehl.elevators.services.configs.versions.configv4_0_2.V4_0_2ConfigRoot;
import me.keehl.elevators.services.configs.versions.configv5.ConfigEffect;
import me.keehl.elevators.services.configs.versions.configv5.ConfigHookData;
import me.keehl.elevators.services.configs.versions.configv5.ConfigLocale;
import me.keehl.elevators.services.configs.versions.configv5.ConfigRoot;
import org.bukkit.DyeColor;

public class V5ConfigVersion
extends ConfigVersion<V4_0_2ConfigRoot, ConfigRoot> {
    @Override
    public ConfigRoot upgradeVersion(V4_0_2ConfigRoot currentConfig) {
        Elevators.getElevatorsLogger().info("Converting config from V4.0.2 - V5.0.0");
        ConfigRoot newConfig = new ConfigRoot();
        newConfig.updateCheckerEnabled = currentConfig.updateCheckerEnabled;
        newConfig.forceFacingUpwards = currentConfig.forceFacingUpwards;
        ConfigLocale locale = new ConfigLocale();
        locale.cantCreateMessage = currentConfig.cantCreateMessage;
        locale.cantUseMessage = currentConfig.cantUseMessage;
        locale.cantGiveMessage = currentConfig.cantGiveMessage;
        locale.cantReloadMessage = currentConfig.cantReloadMessage;
        locale.notEnoughRoomGiveMessage = currentConfig.notEnoughRoomGiveMessage;
        locale.givenElevatorMessage = currentConfig.givenElevatorMessage;
        locale.worldDisabledMessage = currentConfig.worldDisabledMessage;
        newConfig.locale = locale;
        for (ProtectionHook hook : ElevatorHookService.getProtectionHooks()) {
            ConfigHookData hookData = new ConfigHookData();
            hookData.blockNonMemberUseDefault = currentConfig.claimProtectionDefault;
            if (newConfig.protectionHooks == null) {
                newConfig.protectionHooks = new HashMap<String, ConfigHookData>();
            }
            newConfig.protectionHooks.put(hook.getConfigKey(), hookData);
        }
        newConfig.disabledWorlds = currentConfig.disabledWorlds;
        ConfigEffect creeperEffect = new ConfigEffect();
        creeperEffect.file = "Creeper.png";
        creeperEffect.scale = 1;
        creeperEffect.duration = 1.0f;
        creeperEffect.useHolo = false;
        creeperEffect.background = "#FFFFFF";
        newConfig.effects = new HashMap<String, ConfigEffect>();
        newConfig.effects.put("creeper", creeperEffect);
        ElevatorType defaultElevator = new ElevatorType();
        defaultElevator.usePermission = "elevators.use";
        defaultElevator.dyePermission = "elevators.dye";
        defaultElevator.displayName = currentConfig.displayName;
        defaultElevator.maxDistance = currentConfig.maxDistance;
        defaultElevator.maxSolidBlocks = currentConfig.maxSolidBlocks;
        defaultElevator.maxStackSize = currentConfig.maxStackSize;
        defaultElevator.stopObstruction = currentConfig.stopObstruction;
        defaultElevator.checkColor = currentConfig.checkColor;
        defaultElevator.checkPerms = currentConfig.checkPerms;
        defaultElevator.canExplode = currentConfig.canExplode;
        defaultElevator.loreLines = currentConfig.lore;
        defaultElevator.actions.up = currentConfig.actions.up;
        defaultElevator.actions.down = currentConfig.actions.down;
        defaultElevator.recipes = new HashMap();
        for (String recipeKey : currentConfig.recipes.keySet()) {
            V4_0_2ConfigRecipe currentRecipe = currentConfig.recipes.get(recipeKey);
            ElevatorRecipeGroup newRecipe = new ElevatorRecipeGroup();
            newRecipe.defaultOutputColor = DyeColor.valueOf((String)currentConfig.defaultColor);
            newRecipe.supportMultiColorOutput = currentRecipe.coloredCrafting;
            newRecipe.supportMultiColorMaterials = currentRecipe.coloredCrafting;
            newRecipe.recipe = currentRecipe.recipe;
            newRecipe.craftPermission = currentRecipe.permission;
            newRecipe.materials = currentRecipe.materials;
            defaultElevator.recipes.put(recipeKey, newRecipe);
        }
        newConfig.elevators = new HashMap<String, ElevatorType>();
        newConfig.elevators.put("DEFAULT", defaultElevator);
        defaultElevator.onLoad();
        return newConfig;
    }
}

