/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import me.keehl.elevators.util.config.BlankConfig;
import me.keehl.elevators.util.config.Comments;
import me.keehl.elevators.util.config.Config;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.ConfigFieldName;
import me.keehl.elevators.util.config.nodes.ConfigNode;

public class ConfigConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> createNodeFromFieldAndObject(ConfigNode<?> parentNode, Class<?> fieldType, String key, Object object, @Nullable Field field) throws Exception {
        ConfigNode<?> myNode;
        if (!(object instanceof Config) || object.getClass().isInterface()) {
            if (fieldType == Config.class) {
                Object rawData = parentNode.getRoot().getObjectAtPath(key, new HashMap());
                object = new BlankConfig(rawData);
            } else {
                object = fieldType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        if ((myNode = this.createNodeWithData(parentNode, key, object, field)).getValue() instanceof Config) {
            ((Config)myNode.getValue()).setKey(key);
        }
        this.constructMapToConfig(parentNode, myNode, object, fieldType);
        if (myNode.getValue() instanceof Config) {
            ((Config)myNode.getValue()).onLoad();
        }
        return myNode;
    }

    public void constructMapToConfig(ConfigNode<?> parentNode, ConfigNode<?> myNode, Object object, Class<?> fieldType) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = fieldType; current != null; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        for (Field childField : fields) {
            if (Modifier.isTransient(childField.getModifiers()) || Modifier.isFinal(childField.getModifiers())) continue;
            childField.setAccessible(true);
            ConfigFieldName fieldName = childField.getAnnotation(ConfigFieldName.class);
            String path = fieldName != null ? fieldName.value() : childField.getName();
            Cloneable obj = childField.get(myNode.getValue());
            if (obj == null) {
                try {
                    obj = childField.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if (Map.class.isAssignableFrom(childField.getType())) {
                        obj = new HashMap();
                    }
                    if (Set.class.isAssignableFrom(childField.getType())) {
                        obj = new HashSet();
                    }
                    if (List.class.isAssignableFrom(childField.getType())) {
                        obj = new ArrayList();
                    }
                    if (!childField.isEnumConstant()) continue;
                    obj = childField.getType().getEnumConstants()[0];
                }
            }
            obj = parentNode.getRoot().getObjectAtPath(myNode.getChildPath(path), obj);
            ConfigConverter converter = ConfigConverter.getConverter(childField.getType());
            ConfigNode<?> childNode = converter == null ? this.createNodeWithData(myNode, path, obj, childField) : converter.createNodeFromFieldAndObject(myNode, childField.getType(), path, obj, childField);
            if (childField.isAnnotationPresent(Comments.class)) {
                Comments comments = childField.getAnnotation(Comments.class);
                for (String comment : comments.value()) {
                    childNode.addComment(comment);
                }
            }
            myNode.getChildren().add(childNode);
        }
    }

    @Override
    public Object createObjectFromNode(ConfigNode<?> node) throws Exception {
        ((Config)node.getValue()).onSave();
        if (node.getValue() instanceof BlankConfig) {
            return ((BlankConfig)node.getValue()).convertToObject();
        }
        LinkedHashMap newMap = new LinkedHashMap();
        for (ConfigNode<?> childNode : node.getChildren()) {
            Object value = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(value.getClass());
            if (converter != null) {
                value = converter.createObjectFromNode(childNode);
            }
            newMap.put(childNode.getKey(), value);
        }
        return newMap;
    }

    @Override
    public Object createObjectFromValue(Object configObj) throws Exception {
        if (!(configObj instanceof Config)) {
            return new HashMap();
        }
        Config config = (Config)configObj;
        config.onSave();
        if (configObj instanceof BlankConfig) {
            return ((BlankConfig)configObj).convertToObject();
        }
        LinkedHashMap newMap = new LinkedHashMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = configObj.getClass(); current != null; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        for (Field childField : fields) {
            if (Modifier.isTransient(childField.getModifiers()) || Modifier.isFinal(childField.getModifiers())) continue;
            childField.setAccessible(true);
            String path = childField.getName();
            HashSet<Object> obj = childField.get(configObj);
            if (obj == null) {
                try {
                    obj = childField.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if (Map.class.isAssignableFrom(childField.getType())) {
                        obj = new HashMap();
                    }
                    if (Set.class.isAssignableFrom(childField.getType())) {
                        obj = new HashSet();
                    }
                    if (!childField.isEnumConstant()) continue;
                    obj = childField.getType().getEnumConstants()[0];
                }
            }
            if (obj == null) continue;
            ConfigConverter converter = ConfigConverter.getConverter(obj.getClass());
            if (converter != null) {
                obj = converter.createObjectFromValue(obj);
            }
            newMap.put(path, obj);
        }
        return newMap;
    }

    @Override
    public boolean supports(Class<?> type) {
        return Config.class.isAssignableFrom(type);
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        return "Config";
    }
}

