/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.nodes.ClassicConfigNode;
import me.keehl.elevators.util.config.nodes.ConfigNode;

public class EnumConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> createNodeFromFieldAndObject(ConfigNode<?> parentNode, Class<?> fieldType, String key, Object object, @Nullable Field field) {
        if (object instanceof String) {
            String strValue = object.toString();
            Optional<Object> objectOpt = Arrays.stream(fieldType.getEnumConstants()).filter(i -> i.toString().equalsIgnoreCase(strValue)).findFirst();
            if (objectOpt.isPresent()) {
                object = objectOpt.get();
            } else {
                Elevators.getElevatorsLogger().warning("Value at path \"" + parentNode.getPath() + "\" must be a \"" + fieldType.getSimpleName() + "\" enum value! Using default: \"" + object + "\".");
                object = fieldType.getEnumConstants()[0];
            }
        } else if (!object.getClass().isEnum()) {
            object = fieldType.getEnumConstants()[0];
            Elevators.getElevatorsLogger().warning("Value at path \"" + parentNode.getPath() + "\" must be a \"" + fieldType.getSimpleName() + "\" enum value! Using default: \"" + object.toString() + "\".");
        }
        return this.createNodeWithData(parentNode, key, object, field);
    }

    @Override
    public Object createObjectFromNode(ConfigNode<?> node) throws Exception {
        return this.createObjectFromValue(node.getValue());
    }

    @Override
    public Object createObjectFromValue(Object value) throws Exception {
        return value.toString();
    }

    @Override
    public boolean supports(Class<?> type) {
        return type.isEnum();
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        if (node instanceof ClassicConfigNode) {
            return ((ClassicConfigNode)node).getField().getClass().getSimpleName();
        }
        return "Enum";
    }
}

