/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators;

import com.tcoded.folialib.FoliaLib;
import java.io.File;
import java.util.logging.Logger;
import me.keehl.elevators.services.ElevatorActionService;
import me.keehl.elevators.services.ElevatorCommandService;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.ElevatorDataContainerService;
import me.keehl.elevators.services.ElevatorEffectService;
import me.keehl.elevators.services.ElevatorHologramService;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.ElevatorListenerService;
import me.keehl.elevators.services.ElevatorObstructionService;
import me.keehl.elevators.services.ElevatorRecipeService;
import me.keehl.elevators.services.ElevatorSettingService;
import me.keehl.elevators.services.ElevatorTypeService;
import me.keehl.elevators.services.ElevatorUpdateService;
import me.keehl.elevators.services.ElevatorVersionService;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Elevators {
    protected static JavaPlugin instance;
    protected static FoliaLib foliaLib;
    protected static Metrics metrics;
    protected static boolean initialized;

    protected static void enable(JavaPlugin plugin) {
        instance = plugin;
        foliaLib = new FoliaLib((Plugin)plugin);
        metrics = new Metrics((Plugin)plugin, 8026);
        ElevatorDataContainerService.init();
        ElevatorSettingService.init();
        ElevatorVersionService.init();
        ElevatorEffectService.init();
        ElevatorActionService.init();
        ElevatorTypeService.init();
        ElevatorRecipeService.init();
        ElevatorObstructionService.init();
        ElevatorListenerService.init();
        ElevatorHookService.init();
        ElevatorHologramService.init();
        ElevatorCommandService.init();
        ElevatorUpdateService.init(plugin.getDescription().getVersion());
        Elevators.reloadElevators();
        initialized = true;
    }

    public static void disable() {
        ElevatorHookService.unInitialize();
        ElevatorListenerService.unInitialize();
        ElevatorHologramService.onDisable();
        ElevatorUpdateService.unInitialize();
        Elevators.saveConfig();
        initialized = false;
    }

    public static void saveConfig() {
        File configFile = new File(instance.getDataFolder(), "config.yml");
        ElevatorConfigService.saveConfig(configFile);
    }

    public static void reloadElevators() {
        File configFile = new File(instance.getDataFolder(), "config.yml");
        instance.saveDefaultConfig();
        ElevatorConfigService.loadConfig(configFile);
        Elevators.saveConfig();
    }

    public static JavaPlugin getInstance() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin != null) {
            return (JavaPlugin)plugin;
        }
        return instance;
    }

    public static FoliaLib getFoliaLib() {
        return foliaLib;
    }

    public static File getConfigDirectory() {
        File configDirectory;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin == null) {
            plugin = Bukkit.getPluginManager().getPlugins()[0];
            configDirectory = new File(plugin.getDataFolder().getParent(), "Elevators");
        } else {
            configDirectory = plugin.getDataFolder();
        }
        try {
            configDirectory.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configDirectory;
    }

    public static Logger getElevatorsLogger() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin != null) {
            return plugin.getLogger();
        }
        return Bukkit.getLogger();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
    }
}

