/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.models.ElevatorAction;
import me.keehl.elevators.models.ElevatorRecipeGroup;
import me.keehl.elevators.services.ElevatorActionService;
import me.keehl.elevators.services.ElevatorHologramService;
import me.keehl.elevators.services.configs.versions.configv5.ConfigElevatorType;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;

public class ElevatorType
extends ConfigElevatorType {
    private transient String elevatorTypeKey;
    private final transient List<ElevatorAction> actionsUp = new ArrayList<ElevatorAction>();
    private final transient List<ElevatorAction> actionsDown = new ArrayList<ElevatorAction>();

    public String getTypeKey() {
        return this.elevatorTypeKey.toUpperCase();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUsePermission() {
        return this.usePermission;
    }

    public String getDyePermission() {
        return this.dyePermission;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public List<String> getLore() {
        return this.loreLines;
    }

    public int getMaxDistanceAllowedBetweenElevators() {
        return this.maxDistance;
    }

    public int getMaxSolidBlocksAllowedBetweenElevators() {
        return this.maxSolidBlocks;
    }

    public boolean checkDestinationElevatorType() {
        return this.classCheck;
    }

    public boolean doesElevatorRequirePermissions() {
        return this.checkPerms;
    }

    public boolean canElevatorExplode() {
        return this.canExplode;
    }

    public boolean canElevatorBeDyed() {
        return this.supportDying;
    }

    public boolean shouldStopObstructedTeleport() {
        return this.stopObstruction;
    }

    public boolean shouldValidateSameColor() {
        return this.checkColor;
    }

    public List<String> getDisabledSettings() {
        return this.disabledSettings;
    }

    public List<ElevatorAction> getActionsUp() {
        return this.actionsUp;
    }

    public List<ElevatorAction> getActionsDown() {
        return this.actionsDown;
    }

    public List<ElevatorRecipeGroup> getRecipeGroups() {
        return new ArrayList<ElevatorRecipeGroup>(this.recipes.values());
    }

    public Map<String, ElevatorRecipeGroup> getRecipeMap() {
        return this.recipes;
    }

    public List<String> getHolographicLines() {
        return this.hologramLines;
    }

    public ConfigElevatorType getConfig() {
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        Elevators.getInstance().saveConfig();
    }

    public void setMaxDistanceAllowedBetweenElevators(int maxDistance) {
        this.maxDistance = maxDistance;
        Elevators.getInstance().saveConfig();
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        Elevators.getInstance().saveConfig();
    }

    public void setMaxSolidBlocksAllowedBetweenElevators(int maxSolidBlocks) {
        this.maxSolidBlocks = maxSolidBlocks;
        Elevators.getInstance().saveConfig();
    }

    public void setCheckDestinationElevatorType(boolean checkType) {
        this.classCheck = checkType;
        Elevators.getInstance().saveConfig();
    }

    public void setElevatorRequiresPermissions(boolean checkPerms) {
        this.checkPerms = checkPerms;
        Elevators.getInstance().saveConfig();
    }

    public void setCanElevatorExplode(boolean canExplode) {
        this.canExplode = canExplode;
        Elevators.getInstance().saveConfig();
    }

    public void setCanDye(boolean supportDying) {
        this.supportDying = supportDying;
        Elevators.getInstance().saveConfig();
    }

    public void setStopsObstructedTeleportation(boolean stopsObstruction) {
        this.stopObstruction = stopsObstruction;
        Elevators.getInstance().saveConfig();
    }

    public void setShouldValidateColor(boolean checkColor) {
        this.checkColor = checkColor;
        Elevators.getInstance().saveConfig();
    }

    public void setHologramLines(List<String> holoLines) {
        boolean checkCreate = this.hologramLines.isEmpty();
        this.hologramLines = holoLines;
        Elevators.getInstance().saveConfig();
        if (!ElevatorHologramService.canUseHolograms()) {
            return;
        }
        this.updateAllHolograms(checkCreate);
    }

    public void updateAllHolograms(boolean chunkCheck) {
        Elevators.getFoliaLib().getScheduler().runNextTick(task -> ElevatorHologramService.updateHologramsOfElevatorType(this));
        if (!chunkCheck) {
            return;
        }
        Elevators.getFoliaLib().getScheduler().runNextTick(task -> {
            for (World world : Bukkit.getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    ElevatorHologramService.updateHologramsInChunk(chunk);
                }
            }
        });
    }

    public void setLore(List<String> loreLines) {
        this.loreLines = loreLines;
        Elevators.getInstance().saveConfig();
    }

    @Override
    public void onSave() {
        this.actions.up = this.getActionsUp().stream().map(ElevatorAction::serialize).collect(Collectors.toList());
        this.actions.down = this.getActionsDown().stream().map(ElevatorAction::serialize).collect(Collectors.toList());
    }

    @Override
    public void onLoad() {
        this.getActionsUp().clear();
        this.getActionsDown().clear();
        this.getActionsUp().addAll(this.actions.up.stream().map(i -> ElevatorActionService.createActionFromString(this, i)).filter(Objects::nonNull).collect(Collectors.toList()));
        this.getActionsDown().addAll(this.actions.down.stream().map(i -> ElevatorActionService.createActionFromString(this, i)).filter(Objects::nonNull).collect(Collectors.toList()));
        HashMap<String, ElevatorRecipeGroup> newRecipes = new HashMap<String, ElevatorRecipeGroup>();
        for (String key : this.recipes.keySet()) {
            ElevatorRecipeGroup recipeGroup = (ElevatorRecipeGroup)this.recipes.get(key);
            newRecipes.put(key.toUpperCase(), recipeGroup);
            recipeGroup.setKey(key.toUpperCase());
        }
        this.recipes = newRecipes;
    }

    @Override
    public void setKey(String key) {
        this.elevatorTypeKey = key.toUpperCase();
    }
}

