/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.actions.ActionBarAction;
import me.keehl.elevators.actions.BossBarAction;
import me.keehl.elevators.actions.ChargeExpAction;
import me.keehl.elevators.actions.CommandConsoleAction;
import me.keehl.elevators.actions.CommandPlayerAction;
import me.keehl.elevators.actions.EffectAction;
import me.keehl.elevators.actions.MessageAllAction;
import me.keehl.elevators.actions.MessagePlayerAction;
import me.keehl.elevators.actions.SoundAction;
import me.keehl.elevators.actions.TitleAction;
import me.keehl.elevators.actions.TriggerObserverAction;
import me.keehl.elevators.events.ElevatorRegisterActionsEvent;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.ElevatorAction;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorTypeService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ElevatorActionService {
    private static final Map<String, BiFunction<ElevatorType, String, ElevatorAction>> actionConstructors = new HashMap<String, BiFunction<ElevatorType, String, ElevatorAction>>();
    private static final Map<String, ItemStack> actionIcons = new HashMap<String, ItemStack>();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        ElevatorActionService.registerDefaultActions();
        initialized = true;
    }

    private static void registerDefaultActions() {
        ElevatorActionService.registerElevatorAction("sound", SoundAction::new, ChatColor.GREEN.toString(), "Sound", Material.MUSIC_DISC_MALL);
        ElevatorActionService.registerElevatorAction("command-console", CommandConsoleAction::new, ChatColor.DARK_RED.toString(), "Console Command", Material.COMMAND_BLOCK);
        ElevatorActionService.registerElevatorAction("command-player", CommandPlayerAction::new, ChatColor.LIGHT_PURPLE.toString(), "Player Command", Material.REPEATING_COMMAND_BLOCK);
        ElevatorActionService.registerElevatorAction("message-player", MessagePlayerAction::new, ChatColor.YELLOW.toString(), "Message User", Material.WRITTEN_BOOK);
        ElevatorActionService.registerElevatorAction("message-all", MessageAllAction::new, ChatColor.RED.toString(), "Broadcast Message", Material.ENCHANTED_BOOK);
        ElevatorActionService.registerElevatorAction("effect", EffectAction::new, ChatColor.BLUE.toString(), "Effect", Material.FIREWORK_ROCKET);
        ElevatorActionService.registerElevatorAction("title", TitleAction::new, ChatColor.LIGHT_PURPLE.toString(), "Title", Material.NAME_TAG);
        ElevatorActionService.registerElevatorAction("action-bar", ActionBarAction::new, ChatColor.YELLOW.toString(), "Action Bar", Material.BELL);
        ElevatorActionService.registerElevatorAction("boss-bar", BossBarAction::new, ChatColor.RED.toString(), "Boss Bar", Material.DRAGON_HEAD);
        ElevatorActionService.registerElevatorAction("charge-exp", ChargeExpAction::new, ChatColor.GOLD.toString(), "Charge EXP", Material.EXPERIENCE_BOTTLE);
        ElevatorActionService.registerElevatorAction("trigger-observer", TriggerObserverAction::new, ChatColor.RED.toString(), "Trigger Observer", Material.OBSERVER);
        Bukkit.getPluginManager().callEvent((Event)new ElevatorRegisterActionsEvent());
    }

    public static void registerElevatorAction(String key, BiFunction<ElevatorType, String, ElevatorAction> actionConstructor, ItemStack icon) {
        key = key.toLowerCase().trim();
        actionIcons.put(key, icon);
        actionConstructors.put(key, actionConstructor);
        if (!Elevators.isInitialized()) {
            return;
        }
        for (ElevatorType type : ElevatorTypeService.getExistingElevatorTypes()) {
            type.onLoad();
        }
    }

    public static void registerElevatorAction(String key, BiFunction<ElevatorType, String, ElevatorAction> actionConstructor, String chatColor, String displayName, Material itemType) {
        ElevatorActionService.registerElevatorAction(key, actionConstructor, ItemStackHelper.createItem(chatColor + ChatColor.BOLD + displayName, itemType, 1));
    }

    public static ElevatorAction createActionFromString(ElevatorType elevatorType, String actionString) {
        if (!actionString.contains(":")) {
            return null;
        }
        String key = actionString.substring(0, actionString.indexOf(58)).toLowerCase();
        actionString = actionString.substring(actionString.indexOf(58) + 1);
        if (!actionConstructors.containsKey(key)) {
            return null;
        }
        ElevatorAction action = actionConstructors.get(key).apply(elevatorType, key);
        action.initialize(actionString);
        action.setIcon(actionIcons.get(key));
        return action;
    }

    public static List<String> getRegisteredActions() {
        return new ArrayList<String>(actionIcons.keySet());
    }

    public static ItemStack getActionIcon(String actionKey) {
        return actionIcons.getOrDefault(actionKey, null);
    }

    public static ElevatorAction createBlankAction(ElevatorType elevatorType, String actionKey) {
        if (!actionConstructors.containsKey(actionKey = actionKey.toLowerCase().trim())) {
            return null;
        }
        ElevatorAction action = actionConstructors.get(actionKey).apply(elevatorType, actionKey);
        action.initialize("");
        action.setIcon(actionIcons.get(actionKey));
        return action;
    }
}

