/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.models.settings.CanExplodeSetting;
import me.keehl.elevators.models.settings.CheckColorSetting;
import me.keehl.elevators.models.settings.CheckPermsSetting;
import me.keehl.elevators.models.settings.ClassCheckSetting;
import me.keehl.elevators.models.settings.DisplayNameSetting;
import me.keehl.elevators.models.settings.ElevatorSetting;
import me.keehl.elevators.models.settings.HologramLinesSetting;
import me.keehl.elevators.models.settings.LoreLinesSetting;
import me.keehl.elevators.models.settings.MaxDistanceSetting;
import me.keehl.elevators.models.settings.MaxSolidBlocksSetting;
import me.keehl.elevators.models.settings.MaxStackSizeSetting;
import me.keehl.elevators.models.settings.StopObstructionSetting;
import me.keehl.elevators.models.settings.SupportDyingSetting;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.configs.versions.configv5.ConfigRoot;

public class ElevatorSettingService {
    private static boolean initialized = false;
    private static final Map<Class<? extends ElevatorSetting<?>>, ElevatorSetting<?>> settingsMap = new HashMap();

    public static void init() {
        if (initialized) {
            return;
        }
        ElevatorConfigService.addConfigCallback(ElevatorSettingService::registerDefaultSettings);
        initialized = true;
    }

    private static void registerDefaultSettings(ConfigRoot config) {
        settingsMap.clear();
        ElevatorSettingService.addSetting(CanExplodeSetting.class);
        ElevatorSettingService.addSetting(CheckColorSetting.class);
        ElevatorSettingService.addSetting(CheckPermsSetting.class);
        ElevatorSettingService.addSetting(ClassCheckSetting.class);
        ElevatorSettingService.addSetting(DisplayNameSetting.class);
        ElevatorSettingService.addSetting(LoreLinesSetting.class);
        ElevatorSettingService.addSetting(MaxDistanceSetting.class);
        ElevatorSettingService.addSetting(MaxSolidBlocksSetting.class);
        ElevatorSettingService.addSetting(MaxStackSizeSetting.class);
        ElevatorSettingService.addSetting(StopObstructionSetting.class);
        ElevatorSettingService.addSetting(SupportDyingSetting.class);
        ElevatorSettingService.addSetting(HologramLinesSetting.class);
    }

    public static void addSetting(Class<? extends ElevatorSetting<?>> settingsClass) {
        try {
            Constructor<ElevatorSetting<?>> constructor = settingsClass.getConstructor(new Class[0]);
            settingsMap.put(settingsClass, constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getSettingValue(Elevator elevator, Class<? extends ElevatorSetting<T>> settingsClass) {
        if (!settingsMap.containsKey(settingsClass)) {
            throw new RuntimeException("Settings class not found");
        }
        return (T)settingsMap.get(settingsClass).getIndividualElevatorValue(elevator);
    }

    public static <T> T getSettingValue(ElevatorType elevatorType, Class<? extends ElevatorSetting<T>> settingsClass) {
        if (!settingsMap.containsKey(settingsClass)) {
            throw new RuntimeException("Settings class not found");
        }
        return (T)settingsMap.get(settingsClass).getCurrentValueGlobal(elevatorType);
    }

    public static <T extends ElevatorSetting<Z>, Z> T getElevatorSetting(Class<T> settingsClass) {
        if (!settingsMap.containsKey(settingsClass)) {
            throw new RuntimeException("Settings class not found");
        }
        return (T)settingsMap.get(settingsClass);
    }

    public static List<ElevatorSetting<?>> getElevatorSettings() {
        return new ArrayList(settingsMap.values());
    }
}

