/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.config.converter;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.config.nodes.ClassicConfigNode;
import me.keehl.elevators.util.config.nodes.ConfigNode;

public class ArrayConfigConverter
extends ConfigConverter {
    @Override
    public ConfigNode<?> createNodeFromFieldAndObject(ConfigNode<?> parentNode, Class<?> fieldType, String key, Object object, @Nullable Field field) throws Exception {
        Class<?> singleType = fieldType.getComponentType();
        ArrayList values = new ArrayList(object instanceof List ? (List<Object>)object : Arrays.asList((Object[])object));
        ConfigNode<?> myNode = this.createNodeWithData(parentNode, key, values.toArray(), field);
        ConfigConverter converter = ConfigConverter.getConverter(singleType);
        for (Object obj : values) {
            if (converter != null) {
                myNode.getChildren().add(converter.createNodeFromFieldAndObject(parentNode, singleType, obj.toString(), obj, null));
                continue;
            }
            myNode.getChildren().add(this.createNodeWithData(parentNode, obj.toString(), obj, null));
        }
        return myNode;
    }

    @Override
    public Object createObjectFromNode(ConfigNode<?> node) throws Exception {
        ArrayList values = new ArrayList();
        for (ConfigNode<?> childNode : node.getChildren()) {
            Object value = childNode.getValue();
            ConfigConverter converter = ConfigConverter.getConverter(value.getClass());
            if (converter != null) {
                value = converter.createObjectFromNode(childNode);
            }
            values.add(value);
        }
        return values;
    }

    private Object[] convertToObjectArray(Object array) {
        Class<?> ofArray = array.getClass().getComponentType();
        if (ofArray.isPrimitive()) {
            ArrayList<Object> ar = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                ar.add(Array.get(array, i));
            }
            return ar.toArray();
        }
        return (Object[])array;
    }

    @Override
    public Object createObjectFromValue(Object arrayObj) throws Exception {
        Object[] array = this.convertToObjectArray(arrayObj);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object item : array) {
            ConfigConverter converter = ConfigConverter.getConverter(item.getClass());
            if (converter != null) {
                item = converter.createObjectFromValue(item);
            }
            values.add(item);
        }
        return values;
    }

    @Override
    public boolean supports(Class<?> type) {
        return type.isArray();
    }

    @Override
    public String getFieldDisplay(ConfigNode<?> node) {
        if (node instanceof ClassicConfigNode) {
            ClassicConfigNode classicNode = (ClassicConfigNode)node;
            Class<?> singleType = classicNode.getField().getType().getComponentType();
            return singleType.getSimpleName() + " Array";
        }
        return "Array";
    }
}

