/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import com.tcoded.folialib.wrapper.task.WrappedTask;
import de.rapha149.signgui.SignGUI;
import de.rapha149.signgui.SignGUIAction;
import de.rapha149.signgui.SignGUIBuilder;
import de.rapha149.signgui.exception.SignGUIVersionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.actions.settings.ElevatorActionSetting;
import me.keehl.elevators.helpers.ColorHelper;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorAction;
import me.keehl.elevators.models.ElevatorEventData;
import me.keehl.elevators.models.ElevatorRecipeGroup;
import me.keehl.elevators.models.ElevatorSetting;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.models.hooks.ProtectionHook;
import me.keehl.elevators.services.ElevatorActionService;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.ElevatorDataContainerService;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.ElevatorRecipeService;
import me.keehl.elevators.services.ElevatorSettingService;
import me.keehl.elevators.services.ElevatorTypeService;
import me.keehl.elevators.services.configs.versions.configv5_1_0.ConfigRecipe;
import me.keehl.elevators.services.interaction.PagedDisplay;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import me.keehl.elevators.services.interaction.SimpleInput;
import me.keehl.elevators.util.config.RecipeRow;
import net.wesjd.anvilgui.AnvilGUI;
import net.wesjd.anvilgui.version.VersionMatcher;
import net.wesjd.anvilgui.version.VersionWrapper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ElevatorGUIHelper {
    private static boolean anvilEnabled;
    private static boolean signEnabled;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void tryOpenSign(Player player, Function<String, Boolean> validationFunction, Consumer<String> resultConsumer, Runnable onCancel, String inputMessage, boolean allowReset, String ... lines) {
        if (signEnabled) {
            try {
                SignGUIBuilder builder = SignGUI.builder();
                builder.setLines(lines);
                builder.setHandler((p, result) -> {
                    String finalInput;
                    String input = result.getLineWithoutColor(0).trim();
                    if (allowReset && (input.isEmpty() || input.equalsIgnoreCase("reset"))) {
                        input = null;
                    }
                    if (((Boolean)validationFunction.apply(finalInput = input)).booleanValue()) {
                        return Collections.singletonList(SignGUIAction.runSync((JavaPlugin)Elevators.getInstance(), () -> resultConsumer.accept(finalInput)));
                    }
                    return Collections.singletonList(SignGUIAction.displayNewLines((String[])lines));
                });
                player.closeInventory();
                builder.build().open(player);
                return;
            }
            catch (SignGUIVersionException ex) {
                signEnabled = false;
            }
        }
        player.closeInventory();
        SimpleInput input = new SimpleInput(Elevators.getInstance(), player);
        if (allowReset) {
            input.allowReset();
        }
        input.onComplete(result -> {
            if (((Boolean)validationFunction.apply((String)result)).booleanValue()) {
                resultConsumer.accept((String)result);
                return SimpleInput.SimpleInputResult.STOP;
            }
            return SimpleInput.SimpleInputResult.CONTINUE;
        });
        input.onCancel(onCancel);
        MessageHelper.sendFormattedMessage((CommandSender)player, inputMessage, new Object[0]);
        input.start();
    }

    public static void tryOpenAnvil(Player player, Function<String, Boolean> validationFunction, Consumer<String> resultConsumer, Runnable onCancel, String inputMessage, boolean allowReset, String defaultText, String title) {
        if (anvilEnabled) {
            try {
                Function<String, String> cleanText = result -> {
                    if (allowReset && (result.isEmpty() || result.equalsIgnoreCase("reset"))) {
                        result = null;
                    }
                    return result;
                };
                AnvilGUI.Builder anvilBuilder = new AnvilGUI.Builder();
                anvilBuilder.preventClose();
                anvilBuilder.text(defaultText);
                anvilBuilder.title(title);
                anvilBuilder.plugin((Plugin)Elevators.getInstance());
                anvilBuilder.onClose(state -> resultConsumer.accept((String)cleanText.apply(state.getText())));
                anvilBuilder.onClick((slot, state) -> {
                    if (slot != 2) {
                        return Collections.emptyList();
                    }
                    String result = (String)cleanText.apply(state.getText());
                    if (((Boolean)validationFunction.apply(result)).booleanValue()) {
                        return Collections.singletonList(AnvilGUI.ResponseAction.close());
                    }
                    return Collections.singletonList(AnvilGUI.ResponseAction.replaceInputText((String)defaultText));
                });
                player.closeInventory();
                anvilBuilder.open(player);
                return;
            }
            catch (Exception ex) {
                anvilEnabled = false;
            }
        }
        player.closeInventory();
        SimpleInput input = new SimpleInput(Elevators.getInstance(), player);
        if (allowReset) {
            input.allowReset();
        }
        input.onComplete(result -> {
            if (((Boolean)validationFunction.apply((String)result)).booleanValue()) {
                resultConsumer.accept((String)result);
                return SimpleInput.SimpleInputResult.STOP;
            }
            return SimpleInput.SimpleInputResult.CONTINUE;
        });
        input.onCancel(onCancel);
        MessageHelper.sendFormattedMessage((CommandSender)player, inputMessage, new Object[0]);
        input.start();
    }

    public static void openConfirmMenu(Player player, Consumer<Boolean> onConfirm) {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)"Are you sure?");
        BiConsumer<InventoryClickEvent, SimpleDisplay> confirmConsumer = (event, myDisplay) -> {
            if (event.getCurrentItem() == null) {
                return;
            }
            myDisplay.stopReturn();
            onConfirm.accept(event.getCurrentItem().getType() == Material.LIME_WOOL);
        };
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> onConfirm.accept(false));
        for (int i = 0; i < 54; ++i) {
            display.setItemSimple(i, (ItemStack)(i % 9 < 4 ? ItemStackHelper.createItem("Accept", Material.LIME_WOOL, 1) : (i % 9 > 4 ? ItemStackHelper.createItem("Deny", Material.RED_WOOL, 1) : null)), confirmConsumer, new SimpleDisplay.DisplayClickFlag[0]);
        }
        display.open();
    }

    public static void openChooseDyeColorMenu(Player player, String title, Consumer<DyeColor> returnMethod, Runnable onCancel) {
        PagedDisplay<DyeColor> display = new PagedDisplay<DyeColor>(Elevators.getInstance(), player, Arrays.asList(DyeColor.values()), title, onCancel);
        display.onCreateItem(dyeColor -> ItemStackHelper.createItem(ColorHelper.getChatStringFromColor(dyeColor.getColor().asRGB()) + ChatColor.BOLD + dyeColor.name(), ItemStackHelper.getVariant(Material.BLACK_DYE, dyeColor), 1));
        display.onClick((dyeColor, event, myDisplay) -> {
            display.stopReturn();
            returnMethod.accept((DyeColor)dyeColor);
        });
        display.open();
    }

    private static Map<String, String> createActionMap(List<String> keyList, List<String> actionList) {
        HashMap<String, String> actions = new HashMap<String, String>();
        for (int i = 0; i < keyList.size(); ++i) {
            String key = keyList.get(i);
            if (actionList.size() <= i) continue;
            actions.put(key, actionList.get(i));
        }
        return actions;
    }

    private static <T> Map<T, Integer> mapToInventorySlot(List<T> objects) {
        HashMap<T, Integer> objectMap = new HashMap<T, Integer>();
        int inventorySize = objects.size() + (9 - objects.size() % 9);
        int numRows = inventorySize / 9;
        int currentItemIndex = 0;
        for (int row = 0; row < numRows && currentItemIndex < objects.size(); ++row) {
            int startColIndex;
            int itemsToPlace = Math.min(9, objects.size() - currentItemIndex);
            for (int col = startColIndex = Math.max((9 - itemsToPlace) / 2, 0); col < startColIndex + itemsToPlace; ++col) {
                int slot = (row + 1) * 9 + col;
                objectMap.put(objects.get(currentItemIndex), slot);
                ++currentItemIndex;
            }
        }
        return objectMap;
    }

    public static <T> ItemStack createValueButton(ItemStack template, T value, Function<T, String> serializeMethod, Map<String, String> actions) {
        ArrayList<String> lore = new ArrayList<String>();
        ItemMeta templateMeta = template.getItemMeta();
        if (templateMeta.hasLore()) {
            lore.addAll(Objects.requireNonNull(templateMeta.getLore()));
        }
        lore.add("");
        lore.add(ChatColor.GRAY + "Current Value: ");
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            lore.add(boolValue != false ? ChatColor.GREEN + "" + ChatColor.BOLD + "ENABLED" : ChatColor.RED + "" + ChatColor.BOLD + "DISABLED");
        } else {
            lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + serializeMethod.apply(value));
        }
        if (!actions.isEmpty()) {
            lore.add("");
            actions.forEach((action, description) -> lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + action + ": " + ChatColor.GRAY + description));
        }
        ItemStack icon = template.clone();
        ItemMeta iconMeta = icon.getItemMeta();
        iconMeta.setLore(lore);
        icon.setItemMeta(iconMeta);
        return icon;
    }

    public static ItemStack createBooleanButton(ItemStack template, boolean value, Map<String, String> actions) {
        return ElevatorGUIHelper.createValueButton(template, value, boolValue -> boolValue != false ? ChatColor.GREEN + "" + ChatColor.BOLD + "ENABLED" : ChatColor.RED + "" + ChatColor.BOLD + "DISABLED", actions);
    }

    private static Inventory createInventoryWithMinSlots(int minSlots, String title) {
        int inventorySize = minSlots + (9 - minSlots % 9);
        if (minSlots % 9 == 0) {
            inventorySize -= 9;
        }
        return Bukkit.createInventory(null, (int)inventorySize, (String)title);
    }

    private static void fillEmptySlotsWithPanes(Inventory inventory, DyeColor paneColor) {
        ItemStack pane = ItemStackHelper.createItem(" ", ItemStackHelper.getVariant(Material.BLACK_STAINED_GLASS_PANE, paneColor), 1);
        IntStream.range(0, inventory.getSize()).filter(i -> inventory.getItem(i) == null).forEach(i -> inventory.setItem(i, pane.clone()));
    }

    private static void openMenuFromDisplay(SimpleDisplay myDisplay, Player player, Elevator elevator, BiConsumer<Player, Elevator> newMethod) {
        myDisplay.stopReturn();
        newMethod.accept(player, elevator);
    }

    public static void openAdminActionSettingsMenu(Player player, ElevatorType tempElevatorType, ElevatorAction action, Runnable onReturn) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        ArrayList settings = new ArrayList(action.getSettings());
        int inventorySize = Math.floorDiv(settings.size() + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Settings > Actions > Action");
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory);
        action.onStartEditing(player, display, null);
        display.onReturn(() -> {
            action.onStopEditing(player, display, null);
            onReturn.run();
        });
        for (int i = 0; i < settings.size(); ++i) {
            ElevatorActionSetting setting = (ElevatorActionSetting)settings.get(i);
            display.setItemSimple(i + 9, setting.createIcon(setting.getCurrentValueGlobal(elevatorType), true), (event, myDisplay) -> {
                myDisplay.stopReturn();
                setting.clickGlobal(player, elevatorType, () -> ElevatorGUIHelper.openAdminActionSettingsMenu(player, elevatorType, action, onReturn), (InventoryClickEvent)event);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(ChatColor.GRAY + "" + ChatColor.BOLD + "BACK", Material.ARROW, 1), new SimpleDisplay.DisplayClickFlag[0]);
        display.open();
    }

    public static void openAdminCreateActionMenu(Player player, ElevatorType tempElevatorType, List<ElevatorAction> currentActionList) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        List<String> registeredActions = ElevatorActionService.getRegisteredActions();
        PagedDisplay<String> display = new PagedDisplay<String>(Elevators.getInstance(), player, registeredActions, "Settings > Actions > Create", () -> ElevatorGUIHelper.openAdminSettingsMenu(player, elevatorType));
        display.onCreateItem(ElevatorActionService::getActionIcon);
        display.onClick((item, event, myDisplay) -> {
            myDisplay.stopReturn();
            ElevatorAction newAction = ElevatorActionService.createBlankAction(elevatorType, item);
            if (newAction != null) {
                currentActionList.add(newAction);
                if (!newAction.getSettings().isEmpty()) {
                    ElevatorGUIHelper.openAdminActionSettingsMenu(player, elevatorType, newAction, () -> ElevatorGUIHelper.openAdminActionsMenu(player, elevatorType, currentActionList));
                    return;
                }
            }
            ElevatorGUIHelper.openAdminActionsMenu(player, elevatorType, currentActionList);
        });
        display.open();
    }

    public static void openAdminActionsMenu(Player player, ElevatorType tempElevatorType, List<ElevatorAction> actions) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        PagedDisplay<ElevatorAction> display = new PagedDisplay<ElevatorAction>(Elevators.getInstance(), player, actions, "Admin > Settings > Actions", () -> ElevatorGUIHelper.openAdminSettingsMenu(player, elevatorType));
        display.onCreateItem(action -> {
            ItemStack template = action.getIcon().clone();
            ItemMeta meta = template.getItemMeta();
            if (!$assertionsDisabled && meta == null) {
                throw new AssertionError();
            }
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.add("");
            if (!action.getSettings().isEmpty()) {
                lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + "Left Click: " + ChatColor.GRAY + "Edit Action");
            }
            lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + "Shift Click: " + ChatColor.GRAY + "Delete Action");
            meta.setLore(lore);
            template.setItemMeta(meta);
            return template;
        });
        display.onClick((action, event, myDisplay) -> {
            myDisplay.stopReturn();
            if (event.isShiftClick()) {
                ElevatorGUIHelper.openConfirmMenu(player, confirm -> {
                    if (confirm.booleanValue()) {
                        actions.remove(action);
                    }
                    ElevatorGUIHelper.openAdminActionsMenu(player, elevatorType, actions);
                });
                return;
            }
            if (!action.getSettings().isEmpty()) {
                ElevatorGUIHelper.openAdminActionSettingsMenu(player, elevatorType, action, () -> ElevatorGUIHelper.openAdminActionsMenu(player, elevatorType, actions));
            }
        });
        display.onLoad((tempDisplay, page) -> {
            int addRecipeIndex = display.getDisplay().getInventory().getSize() - 1;
            display.getDisplay().setItemSimple(addRecipeIndex, ItemStackHelper.createItem(ChatColor.GOLD + "" + ChatColor.BOLD + "Add Action", Material.NETHER_STAR, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                ElevatorGUIHelper.openAdminCreateActionMenu(player, elevatorType, actions);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        });
        display.open();
    }

    public static void openSaveRecipeMenu(Player player, ElevatorType tempElevatorType, ElevatorRecipeGroup recipeGroup) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        Runnable onReturn = () -> ElevatorGUIHelper.openAdminEditRecipesMenu(player, elevatorType);
        if (recipeGroup.getRecipeKey() != null) {
            elevatorType.getRecipeMap().put(recipeGroup.getRecipeKey(), recipeGroup);
            onReturn.run();
            ElevatorRecipeService.refreshRecipes();
            return;
        }
        ElevatorGUIHelper.tryOpenAnvil(player, value -> {
            if (elevatorType.getRecipeMap().containsKey(value.toUpperCase())) {
                MessageHelper.sendFormattedMessage((CommandSender)player, ElevatorConfigService.getRootConfig().locale.nonUniqueRecipeName, new Object[0]);
                return false;
            }
            return true;
        }, result -> {
            recipeGroup.setKey(result.toUpperCase());
            elevatorType.getRecipeMap().put(result.toUpperCase(), recipeGroup);
            onReturn.run();
            ElevatorRecipeService.refreshRecipes();
        }, onReturn, ElevatorConfigService.getRootConfig().locale.enterRecipeName, false, "", "Enter recipe name.");
    }

    public static void openEditRecipePermissionMenu(Player player, ElevatorType tempElevatorType, ElevatorRecipeGroup recipeGroup) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        player.closeInventory();
        SimpleInput input = new SimpleInput(Elevators.getInstance(), player);
        input.allowReset();
        input.onComplete(result -> {
            if (result == null) {
                result = "elevators.craft." + elevatorType.getTypeKey();
            }
            ConfigRecipe.setCraftPermission(recipeGroup, result);
            ElevatorGUIHelper.openAdminEditElevatorRecipeMenu(player, elevatorType, recipeGroup);
            return SimpleInput.SimpleInputResult.STOP;
        });
        input.onCancel(() -> ElevatorGUIHelper.openAdminEditElevatorRecipeMenu(player, elevatorType, recipeGroup));
        MessageHelper.sendFormattedMessage((CommandSender)player, ElevatorConfigService.getRootConfig().locale.enterRecipePermission, new Object[0]);
        input.start();
    }

    private static void saveInventoryToRecipe(Inventory inventory, ElevatorRecipeGroup tempRecipe) {
        ArrayList<RecipeRow<NamespacedKey>> keyList = new ArrayList<RecipeRow<NamespacedKey>>();
        for (int y = 0; y < 3; ++y) {
            RecipeRow keyRow = new RecipeRow();
            for (int x = 0; x < 3; ++x) {
                int slot = 10 + y * 9 + x;
                ItemStack item = inventory.getItem(slot);
                NamespacedKey key = item == null || item.getType().isAir() ? Material.AIR.getKey() : ElevatorHookService.getKeyFromItemStack(item);
                keyRow.add(key);
            }
            keyList.add(keyRow);
        }
        ConfigRecipe.setRecipe(tempRecipe, keyList);
    }

    private static void runRecipeColorTask(ElevatorType elevatorType, Inventory inventory, ElevatorRecipeGroup tempRecipe, AtomicInteger dyeColorIndex) {
        DyeColor color = null;
        if (!tempRecipe.supportsMultiColorOutput()) {
            color = tempRecipe.getDefaultOutputColor();
        } else if (!tempRecipe.supportsMultiColorMaterials()) {
            block0: for (List list : tempRecipe.getRecipe()) {
                for (NamespacedKey key : list) {
                    DyeColor tempColor;
                    ItemStack item;
                    boolean colorable = key.getNamespace().equalsIgnoreCase("minecraft") || key.getNamespace().equalsIgnoreCase(Elevators.getInstance().getName().toLowerCase(Locale.ROOT));
                    if (!colorable || (item = ElevatorHookService.createItemStackFromKey(key)) == null || (tempColor = ItemStackHelper.getDyeColorFromMaterial(item.getType())) == null) continue;
                    if (color != null && tempColor != color) {
                        color = tempRecipe.getDefaultOutputColor();
                        continue block0;
                    }
                    color = tempColor;
                }
            }
        } else {
            color = DyeColor.values()[dyeColorIndex.get()];
        }
        ItemStack elevatorItemStack = ItemStackHelper.createItemStackFromElevatorType(elevatorType, color);
        elevatorItemStack.setAmount(tempRecipe.getAmount());
        inventory.setItem(25, elevatorItemStack);
        dyeColorIndex.set(dyeColorIndex.incrementAndGet() % DyeColor.values().length);
    }

    public static void openAdminEditElevatorRecipeMenu(Player player, ElevatorType tempElevatorType, ElevatorRecipeGroup currentRecipeGroup) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)"Settings > Recipes > Recipe");
        ElevatorRecipeGroup tempRecipe = new ElevatorRecipeGroup();
        if (currentRecipeGroup != null) {
            ConfigRecipe.setAmount(tempRecipe, currentRecipeGroup.amount);
            ConfigRecipe.setCraftPermission(tempRecipe, currentRecipeGroup.getCraftPermission());
            ConfigRecipe.setDefaultOutputColor(tempRecipe, currentRecipeGroup.getDefaultOutputColor());
            ConfigRecipe.setMultiColorOutput(tempRecipe, currentRecipeGroup.supportMultiColorOutput());
            ConfigRecipe.setMultiColorMaterials(tempRecipe, currentRecipeGroup.supportMultiColorMaterials());
            ConfigRecipe.setRecipe(tempRecipe, currentRecipeGroup.getRecipe());
            tempRecipe.setKey(currentRecipeGroup.getRecipeKey());
        }
        AtomicInteger dyeColorIndex = new AtomicInteger(0);
        WrappedTask colorTask = Elevators.getFoliaLib().getScheduler().runTimer(() -> ElevatorGUIHelper.runRecipeColorTask(elevatorType, inventory, tempRecipe, dyeColorIndex), 20L, 20L);
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> {
            colorTask.cancel();
            ElevatorGUIHelper.openAdminEditRecipesMenu(player, elevatorType);
        }, SimpleDisplay.DisplayClickResult.CANCEL, SimpleDisplay.DisplayClickResult.ALLOW);
        ElevatorGUIHelper.fillEmptySlotsWithPanes(inventory, DyeColor.BLACK);
        int x = 0;
        int y = 0;
        for (List list : tempRecipe.getRecipe()) {
            for (NamespacedKey key : list) {
                ItemStack item = ElevatorHookService.createItemStackFromKey(key);
                if (item == null) {
                    item = new ItemStack(Material.AIR, 1);
                }
                int slot = 10 + y * 9 + x % 3;
                BiFunction<InventoryClickEvent, SimpleDisplay, SimpleDisplay.DisplayClickResult> onClick = (event, myDisplay) -> SimpleDisplay.DisplayClickResult.ALLOW;
                display.setItem(slot, item, onClick, new SimpleDisplay.DisplayClickFlag[0]);
                ++x;
            }
            ++y;
        }
        ItemStack permissionTemplate = ItemStackHelper.createItem(ChatColor.DARK_PURPLE + "" + ChatColor.BOLD + "Craft Permission", Material.CHAIN_COMMAND_BLOCK, 1, Arrays.asList("", ChatColor.GRAY + "Current Value: ", ChatColor.GOLD + tempRecipe.getCraftPermission()));
        ItemStack itemStack = ItemStackHelper.createItem(ColorHelper.getChatStringFromColor(tempRecipe.getDefaultOutputColor().getColor().asRGB()) + ChatColor.BOLD + "Change Default Output Color", ItemStackHelper.getVariant(Material.BLACK_DYE, tempRecipe.getDefaultOutputColor()), 1);
        ItemStack multiColorMaterialTemplate = ItemStackHelper.createItem(ChatColor.GREEN + "" + ChatColor.BOLD + "Multi-Color Materials", Material.FIREWORK_STAR, 1);
        ItemStack multiColorOutputTemplate = ItemStackHelper.createItem(ChatColor.GREEN + "" + ChatColor.BOLD + "Multi-Color Output", Material.FIREWORK_ROCKET, 1);
        ItemStack amountTemplate = ItemStackHelper.createItem(ChatColor.GRAY + "" + ChatColor.BOLD + "Quantity", Material.EXPERIENCE_BOTTLE, 1);
        Function<Integer, ItemStack> createAmountIcon = amount -> ElevatorGUIHelper.createValueButton(amountTemplate, amount, Object::toString, ElevatorGUIHelper.createActionMap(Arrays.asList("Left Click", "Right Click"), Arrays.asList("Increase Quantity", "Decrease Quantity")));
        Supplier<ItemStack> createMultiColorMaterialIcon = () -> ElevatorGUIHelper.createBooleanButton(multiColorMaterialTemplate, tempRecipe.supportsMultiColorMaterials(), ElevatorGUIHelper.createActionMap(Collections.singletonList("Left Click"), Collections.singletonList("Toggle")));
        Supplier<ItemStack> createMultiColorOutputIcon = () -> ElevatorGUIHelper.createBooleanButton(multiColorOutputTemplate, tempRecipe.supportsMultiColorOutput(), ElevatorGUIHelper.createActionMap(Collections.singletonList("Left Click"), Collections.singletonList("Toggle")));
        display.setReturnButton(45, ItemStackHelper.createItem(ChatColor.RED + "" + ChatColor.BOLD + "CANCEL", Material.BARRIER, 1), new SimpleDisplay.DisplayClickFlag[0]);
        display.setItemSimple(47, permissionTemplate, (event, myDisplay) -> {
            ElevatorGUIHelper.saveInventoryToRecipe(inventory, tempRecipe);
            colorTask.cancel();
            display.stopReturn();
            ElevatorGUIHelper.openEditRecipePermissionMenu(player, elevatorType, tempRecipe);
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.setItemSimple(48, createAmountIcon.apply(tempRecipe.getAmount()), (event, myDisplay) -> {
            int newValue = tempRecipe.getAmount() + (event.isLeftClick() ? 1 : -1);
            newValue = Math.min(Math.max(newValue, 1), elevatorType.getMaxStackSize());
            ConfigRecipe.setAmount(tempRecipe, newValue);
            inventory.setItem(48, (ItemStack)createAmountIcon.apply(newValue));
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.setItemSimple(49, ElevatorGUIHelper.createValueButton(itemStack, tempRecipe.getDefaultOutputColor(), Enum::name, ElevatorGUIHelper.createActionMap(Collections.singletonList("Left Click"), Collections.singletonList("Change Color"))), (event, myDisplay) -> {
            ElevatorGUIHelper.saveInventoryToRecipe(inventory, tempRecipe);
            colorTask.cancel();
            display.stopReturn();
            ElevatorGUIHelper.openChooseDyeColorMenu(player, "Recipes > Recipe > Color", color -> {
                ConfigRecipe.setDefaultOutputColor(tempRecipe, color);
                ElevatorGUIHelper.openAdminEditElevatorRecipeMenu(player, elevatorType, tempRecipe);
            }, () -> ElevatorGUIHelper.openAdminEditElevatorRecipeMenu(player, elevatorType, tempRecipe));
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.setItemSimple(50, createMultiColorMaterialIcon.get(), (event, myDisplay) -> {
            ConfigRecipe.setMultiColorMaterials(tempRecipe, !tempRecipe.supportsMultiColorMaterials());
            inventory.setItem(50, (ItemStack)createMultiColorMaterialIcon.get());
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.setItemSimple(51, createMultiColorOutputIcon.get(), (event, myDisplay) -> {
            ConfigRecipe.setMultiColorOutput(tempRecipe, !tempRecipe.supportsMultiColorOutput());
            inventory.setItem(51, (ItemStack)createMultiColorOutputIcon.get());
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.setItemSimple(53, ItemStackHelper.createItem(ChatColor.GREEN + "" + ChatColor.BOLD + "SAVE", Material.ARROW, 1), (event, myDisplay) -> {
            ElevatorGUIHelper.saveInventoryToRecipe(inventory, tempRecipe);
            colorTask.cancel();
            display.stopReturn();
            ElevatorGUIHelper.openSaveRecipeMenu(player, elevatorType, tempRecipe);
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.open();
    }

    public static void openAdminDeleteElevatorRecipe(Player player, ElevatorType tempElevatorType, ElevatorRecipeGroup recipeGroup) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        ElevatorGUIHelper.openConfirmMenu(player, confirmed -> {
            if (confirmed.booleanValue()) {
                elevatorType.getRecipeMap().remove(recipeGroup.getRecipeKey());
                ElevatorRecipeService.refreshRecipes();
            }
            ElevatorGUIHelper.openAdminEditRecipesMenu(player, elevatorType);
        });
    }

    public static void openAdminEditRecipesMenu(Player player, ElevatorType tempElevatorType) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        PagedDisplay<ElevatorRecipeGroup> display = new PagedDisplay<ElevatorRecipeGroup>(Elevators.getInstance(), player, elevatorType.getRecipeGroups(), "Admin > Settings > Recipes", () -> ElevatorGUIHelper.openAdminSettingsMenu(player, elevatorType));
        display.onCreateItem(recipeGroup -> {
            DyeColor color = DyeColor.getByWoolData((byte)((byte)(Math.abs(recipeGroup.getRecipeKey().hashCode()) % 16)));
            if (!recipeGroup.supportMultiColorOutput() || color == null) {
                color = recipeGroup.getDefaultOutputColor();
            }
            String chatColor = ColorHelper.getChatStringFromColor(color.getColor().asRGB());
            ItemStack icon = ItemStackHelper.createItem(chatColor + ChatColor.BOLD + recipeGroup.getRecipeKey(), ItemStackHelper.getVariant(Material.RED_SHULKER_BOX, color), recipeGroup.amount);
            ItemMeta meta = icon.getItemMeta();
            if (!$assertionsDisabled && meta == null) {
                throw new AssertionError();
            }
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.add("");
            lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + "Left Click: " + ChatColor.GRAY + "Edit Recipe");
            lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + "Shift Click: " + ChatColor.GRAY + "Delete Recipe");
            meta.setLore(lore);
            icon.setItemMeta(meta);
            return icon;
        });
        display.onClick((item, event, myDisplay) -> {
            myDisplay.stopReturn();
            if (event.isShiftClick()) {
                ElevatorGUIHelper.openAdminDeleteElevatorRecipe(player, elevatorType, item);
            } else {
                ElevatorGUIHelper.openAdminEditElevatorRecipeMenu(player, elevatorType, item);
            }
        });
        display.onLoad((tempDisplay, page) -> {
            int addRecipeIndex = display.getDisplay().getInventory().getSize() - 1;
            display.getDisplay().setItemSimple(addRecipeIndex, ItemStackHelper.createItem(ChatColor.GOLD + "" + ChatColor.BOLD + "Add Recipe", Material.NETHER_STAR, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                ElevatorGUIHelper.openAdminEditElevatorRecipeMenu(player, elevatorType, null);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        });
        display.open();
    }

    public static void openAdminSettingsMenu(Player player, ElevatorType tempElevatorType) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        List<ElevatorSetting<?>> settings = ElevatorSettingService.getElevatorSettings();
        int itemAmount = settings.size() + 3;
        List<ElevatorAction> upActions = elevatorType.getActionsUp();
        List<ElevatorAction> downActions = elevatorType.getActionsDown();
        int inventorySize = Math.floorDiv(itemAmount + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Admin > Settings");
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> ElevatorGUIHelper.openAdminMenu(player));
        for (int i = 0; i < settings.size(); ++i) {
            ElevatorSetting<?> setting = settings.get(i);
            display.setItemSimple(i + 9, setting.createIcon(setting.getCurrentValueGlobal(elevatorType), true), (event, myDisplay) -> {
                myDisplay.stopReturn();
                setting.clickGlobal(player, elevatorType, () -> ElevatorGUIHelper.openAdminSettingsMenu(player, elevatorType), (InventoryClickEvent)event);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        }
        display.setItemSimple(inventory.getSize() - 3, ItemStackHelper.createItem(ChatColor.GOLD + "" + ChatColor.BOLD + "Recipes", Material.MAP, 1), (event, myDisplay) -> {
            myDisplay.stopReturn();
            ElevatorGUIHelper.openAdminEditRecipesMenu(player, elevatorType);
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.setItemSimple(inventory.getSize() - 1, ItemStackHelper.createItem(ChatColor.GOLD + "" + ChatColor.BOLD + "Downwards Actions", Material.SPECTRAL_ARROW, 1), (event, myDisplay) -> {
            myDisplay.stopReturn();
            ElevatorGUIHelper.openAdminActionsMenu(player, elevatorType, downActions);
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.setItemSimple(inventory.getSize() - 2, ItemStackHelper.createItem(ChatColor.GOLD + "" + ChatColor.BOLD + "Upwards Actions", Material.TIPPED_ARROW, 1), (event, myDisplay) -> {
            myDisplay.stopReturn();
            ElevatorGUIHelper.openAdminActionsMenu(player, elevatorType, upActions);
        }, new SimpleDisplay.DisplayClickFlag[0]);
        display.setReturnButton(0, ItemStackHelper.createItem(ChatColor.GRAY + "" + ChatColor.BOLD + "BACK", Material.ARROW, 1), new SimpleDisplay.DisplayClickFlag[0]);
        display.open();
    }

    public static void openAdminDeleteElevatorTypeMenu(Player player, ElevatorType tempElevatorType) {
        ElevatorType elevatorType = ElevatorTypeService.getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        ElevatorGUIHelper.openConfirmMenu(player, confirmed -> {
            if (confirmed.booleanValue()) {
                ElevatorTypeService.unregisterElevatorType(elevatorType);
            }
            ElevatorGUIHelper.openAdminMenu(player);
        });
    }

    public static void openCreateElevatorTypeMenu(Player player) {
        player.closeInventory();
        SimpleInput input = new SimpleInput(Elevators.getInstance(), player);
        input.onComplete(result -> {
            if (result == null) {
                ElevatorGUIHelper.openAdminMenu(player);
                return SimpleInput.SimpleInputResult.STOP;
            }
            if (ElevatorTypeService.getElevatorType(result) != null) {
                MessageHelper.sendFormattedMessage((CommandSender)player, ElevatorConfigService.getRootConfig().locale.nonUniqueElevatorKey, new Object[0]);
                return SimpleInput.SimpleInputResult.CONTINUE;
            }
            ElevatorGUIHelper.openAdminSettingsMenu(player, ElevatorTypeService.createElevatorType(result));
            return SimpleInput.SimpleInputResult.STOP;
        });
        input.onCancel(() -> ElevatorGUIHelper.openAdminMenu(player));
        MessageHelper.sendFormattedMessage((CommandSender)player, ElevatorConfigService.getRootConfig().locale.enterMessage, new Object[0]);
        input.start();
    }

    public static void openAdminMenu(Player player) {
        PagedDisplay<ElevatorType> display = new PagedDisplay<ElevatorType>(Elevators.getInstance(), player, ElevatorTypeService.getExistingElevatorTypes(), "Admin");
        display.onCreateItem(elevatorType -> {
            DyeColor color = DyeColor.getByWoolData((byte)((byte)(Math.abs(elevatorType.getTypeKey().hashCode()) % 16)));
            if (elevatorType.canElevatorBeDyed() && !elevatorType.getRecipeGroups().isEmpty()) {
                color = elevatorType.getRecipeGroups().get(0).getDefaultOutputColor();
            }
            ItemStack icon = ItemStackHelper.createItemStackFromElevatorType(elevatorType, color);
            ItemMeta meta = icon.getItemMeta();
            if (!$assertionsDisabled && meta == null) {
                throw new AssertionError();
            }
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.add("");
            lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + "Type Key: " + elevatorType.getTypeKey());
            lore.add("");
            lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + "Left Click: " + ChatColor.GRAY + "Edit Elevator");
            lore.add(ChatColor.GOLD + "" + ChatColor.BOLD + "Shift Click: " + ChatColor.GRAY + "Delete Elevator");
            meta.setLore(lore);
            icon.setItemMeta(meta);
            return icon;
        });
        display.onClick((item, event, myDisplay) -> {
            myDisplay.stopReturn();
            if (event.isShiftClick()) {
                ElevatorGUIHelper.openAdminDeleteElevatorTypeMenu(player, item);
            } else {
                ElevatorGUIHelper.openAdminSettingsMenu(player, item);
            }
        });
        display.onLoad((tempDisplay, page) -> {
            int addElevatorIndex = display.getDisplay().getInventory().getSize() - 1;
            display.getDisplay().setItemSimple(addElevatorIndex, ItemStackHelper.createItem(ChatColor.GOLD + "" + ChatColor.BOLD + "Add Elevator", Material.NETHER_STAR, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                ElevatorGUIHelper.openCreateElevatorTypeMenu(player);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        });
        display.open();
    }

    public static void openInteractMenu(Player player, Elevator elevator) {
        if (!elevator.isValid()) {
            MessageHelper.sendElevatorChangedMessage(player, new ElevatorEventData(elevator, elevator, 1, 0.0));
            if (elevator.getShulkerBox() != null && ElevatorHelper.isElevatorDisabled(elevator.getShulkerBox())) {
                ElevatorHelper.setElevatorEnabled(elevator.getShulkerBox());
                ShulkerBoxHelper.playClose(elevator.getShulkerBox());
            }
            player.closeInventory();
            return;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)"Elevator");
        ElevatorHelper.setElevatorDisabled(elevator.getShulkerBox());
        ShulkerBoxHelper.playOpen(elevator.getShulkerBox());
        ElevatorGUIHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        ArrayList<String> nameLore = new ArrayList<String>();
        nameLore.add("");
        nameLore.add(ChatColor.GRAY + "Current Value: ");
        nameLore.add(ChatColor.GOLD + "" + ChatColor.BOLD + ElevatorDataContainerService.getFloorName(elevator));
        ItemStack protectionItem = ItemStackHelper.createItem(ChatColor.RED + "" + ChatColor.BOLD + "Protection", Material.DIAMOND_SWORD, 1);
        ItemStack nameItem = ItemStackHelper.createItem(ChatColor.YELLOW + "" + ChatColor.BOLD + "Floor Name", Material.NAME_TAG, 1, nameLore);
        ItemStack settingsItem = ItemStackHelper.createItem(ChatColor.DARK_GRAY + "" + ChatColor.BOLD + "Settings", Material.SEA_LANTERN, 1);
        List protectionHooks = ElevatorHookService.getProtectionHooks().stream().filter(i -> i.getConfig().allowCustomization).filter(i -> i.createIconForElevator(player, elevator) != null).collect(Collectors.toList());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> {
            ElevatorHelper.setElevatorEnabled(elevator.getShulkerBox());
            ShulkerBoxHelper.playClose(elevator.getShulkerBox());
        });
        boolean canRename = ElevatorHookService.canRenameElevator(player, elevator, false);
        if (protectionHooks.isEmpty()) {
            if (canRename) {
                display.setItemSimple(11, nameItem, (event, myDisplay) -> ElevatorGUIHelper.openMenuFromDisplay(myDisplay, player, elevator, ElevatorGUIHelper::openInteractNameMenu), new SimpleDisplay.DisplayClickFlag[0]);
                display.setItemSimple(15, settingsItem, (event, myDisplay) -> ElevatorGUIHelper.openMenuFromDisplay(myDisplay, player, elevator, ElevatorGUIHelper::openInteractSettingsMenu), new SimpleDisplay.DisplayClickFlag[0]);
            } else {
                display.setItemSimple(13, settingsItem, (event, myDisplay) -> ElevatorGUIHelper.openMenuFromDisplay(myDisplay, player, elevator, ElevatorGUIHelper::openInteractSettingsMenu), new SimpleDisplay.DisplayClickFlag[0]);
            }
            display.open();
            return;
        }
        if (canRename) {
            display.setItemSimple(10, protectionItem, (event, myDisplay) -> ElevatorGUIHelper.openMenuFromDisplay(myDisplay, player, elevator, ElevatorGUIHelper::openInteractProtectMenu), new SimpleDisplay.DisplayClickFlag[0]);
            display.setItemSimple(13, nameItem, (event, myDisplay) -> ElevatorGUIHelper.openMenuFromDisplay(myDisplay, player, elevator, ElevatorGUIHelper::openInteractNameMenu), new SimpleDisplay.DisplayClickFlag[0]);
            display.setItemSimple(16, settingsItem, (event, myDisplay) -> ElevatorGUIHelper.openMenuFromDisplay(myDisplay, player, elevator, ElevatorGUIHelper::openInteractSettingsMenu), new SimpleDisplay.DisplayClickFlag[0]);
        } else {
            display.setItemSimple(11, protectionItem, (event, myDisplay) -> ElevatorGUIHelper.openMenuFromDisplay(myDisplay, player, elevator, ElevatorGUIHelper::openInteractProtectMenu), new SimpleDisplay.DisplayClickFlag[0]);
            display.setItemSimple(15, settingsItem, (event, myDisplay) -> ElevatorGUIHelper.openMenuFromDisplay(myDisplay, player, elevator, ElevatorGUIHelper::openInteractSettingsMenu), new SimpleDisplay.DisplayClickFlag[0]);
        }
        if (protectionHooks.size() == 1) {
            ProtectionHook hook = (ProtectionHook)protectionHooks.get(0);
            ItemStack protectionIcon = hook.createIconForElevator(player, elevator);
            display.setItemSimple(canRename ? 10 : 11, protectionIcon, (event, myDisplay) -> {
                myDisplay.stopReturn();
                hook.onProtectionClick(player, elevator, () -> ElevatorGUIHelper.openInteractMenu(player, elevator));
            }, new SimpleDisplay.DisplayClickFlag[0]);
        }
        display.open();
    }

    public static void openInteractProtectMenu(Player player, Elevator elevator) {
        if (!elevator.isValid()) {
            ElevatorGUIHelper.openInteractMenu(player, elevator);
            return;
        }
        List protectionHooks = ElevatorHookService.getProtectionHooks().stream().filter(i -> i.getConfig().allowCustomization).filter(i -> i.createIconForElevator(player, elevator) != null).collect(Collectors.toList());
        Inventory inventory = ElevatorGUIHelper.createInventoryWithMinSlots(protectionHooks.size() + 9, "Elevator > Protection");
        ElevatorGUIHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> ElevatorGUIHelper.openInteractMenu(player, elevator));
        for (Map.Entry hookData : ElevatorGUIHelper.mapToInventorySlot(protectionHooks).entrySet()) {
            int slot = hookData.getValue() + 9;
            ItemStack icon = ((ProtectionHook)hookData.getKey()).createIconForElevator(player, elevator);
            BiConsumer<InventoryClickEvent, SimpleDisplay> onClick = (event, myDisplay) -> {
                myDisplay.stopReturn();
                ((ProtectionHook)hookData.getKey()).onProtectionClick(player, elevator, () -> ElevatorGUIHelper.openInteractProtectMenu(player, elevator));
            };
            display.setItemSimple(slot, icon, onClick, new SimpleDisplay.DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(ChatColor.GRAY + "" + ChatColor.BOLD + "BACK", Material.ARROW, 1), new SimpleDisplay.DisplayClickFlag[0]);
        display.open();
    }

    public static void openInteractNameMenu(Player player, Elevator elevator) {
        if (!elevator.isValid()) {
            ElevatorGUIHelper.openInteractMenu(player, elevator);
            return;
        }
        String currentName = ElevatorDataContainerService.getFloorName(elevator);
        ElevatorGUIHelper.tryOpenSign(player, value -> true, result -> {
            ElevatorDataContainerService.setFloorName(elevator, result);
            ElevatorGUIHelper.openInteractMenu(player, elevator);
        }, () -> ElevatorGUIHelper.openInteractMenu(player, elevator), ElevatorConfigService.getRootConfig().locale.enterFloorName, true, currentName, ChatColor.BOLD + "^^^^^^^^", "Enter floor", "name above");
    }

    private static List<ElevatorAction> getActionsWithSettings(Elevator elevator, boolean up) {
        ArrayList<ElevatorAction> actions = new ArrayList<ElevatorAction>(up ? elevator.getElevatorType(false).getActionsUp() : elevator.getElevatorType(false).getActionsDown());
        actions.removeIf(i -> i.getSettings().isEmpty());
        actions.removeIf(i -> i.getSettings().stream().noneMatch(s -> s.canBeEditedIndividually(elevator)));
        return actions;
    }

    public static void openInteractActionSettingsMenu(Player player, Elevator elevator, ElevatorAction action, Runnable onReturn) {
        if (!elevator.isValid()) {
            onReturn.run();
            return;
        }
        ArrayList settings = new ArrayList(action.getSettings());
        settings.removeIf(i -> !i.canBeEditedIndividually(elevator));
        int inventorySize = Math.floorDiv(settings.size() + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Settings > Actions > Action");
        ElevatorGUIHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory);
        action.onStartEditing(player, display, elevator);
        display.onReturn(() -> {
            action.onStopEditing(player, display, elevator);
            onReturn.run();
        });
        for (int i2 = 0; i2 < settings.size(); ++i2) {
            ElevatorActionSetting setting = (ElevatorActionSetting)settings.get(i2);
            display.setItemSimple(i2 + 9, setting.createIcon(setting.getIndividualElevatorValue(elevator), false), (event, myDisplay) -> {
                myDisplay.stopReturn();
                setting.clickIndividual(player, elevator, () -> ElevatorGUIHelper.openInteractActionSettingsMenu(player, elevator, action, onReturn), (InventoryClickEvent)event);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(ChatColor.GRAY + "" + ChatColor.BOLD + "BACK", Material.ARROW, 1), new SimpleDisplay.DisplayClickFlag[0]);
        display.open();
    }

    public static void openInteractActionsMenu(Player player, Elevator elevator, List<ElevatorAction> actions) {
        if (!elevator.isValid()) {
            ElevatorGUIHelper.openInteractSettingsMenu(player, elevator);
            return;
        }
        int inventorySize = Math.floorDiv(actions.size() + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Elevator > Settings > Actions");
        ElevatorGUIHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> ElevatorGUIHelper.openInteractSettingsMenu(player, elevator));
        for (int i = 0; i < actions.size(); ++i) {
            ElevatorAction action = actions.get(i);
            display.setItemSimple(i + 9, action.getIcon(), (event, myDisplay) -> {
                myDisplay.stopReturn();
                ElevatorGUIHelper.openInteractActionSettingsMenu(player, elevator, action, () -> ElevatorGUIHelper.openInteractActionsMenu(player, elevator, actions));
            }, new SimpleDisplay.DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(ChatColor.GRAY + "" + ChatColor.BOLD + "BACK", Material.ARROW, 1), new SimpleDisplay.DisplayClickFlag[0]);
        display.open();
    }

    public static void openInteractSettingsMenu(Player player, Elevator elevator) {
        if (!elevator.isValid()) {
            ElevatorGUIHelper.openInteractMenu(player, elevator);
            return;
        }
        List settings = ElevatorSettingService.getElevatorSettings().stream().filter(i -> i.canBeEditedIndividually(elevator)).collect(Collectors.toList());
        int itemAmount = settings.size();
        List<ElevatorAction> upActions = ElevatorGUIHelper.getActionsWithSettings(elevator, true);
        List<ElevatorAction> downActions = ElevatorGUIHelper.getActionsWithSettings(elevator, false);
        if (!upActions.isEmpty()) {
            ++itemAmount;
        }
        if (!downActions.isEmpty()) {
            ++itemAmount;
        }
        int inventorySize = Math.floorDiv(itemAmount + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Elevator > Settings");
        ElevatorGUIHelper.fillEmptySlotsWithPanes(inventory, elevator.getDyeColor());
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> ElevatorGUIHelper.openInteractMenu(player, elevator));
        for (int i2 = 0; i2 < settings.size(); ++i2) {
            ElevatorSetting setting = (ElevatorSetting)settings.get(i2);
            display.setItemSimple(i2 + 9, setting.createIcon(setting.getIndividualElevatorValue(elevator), false), (event, myDisplay) -> {
                myDisplay.stopReturn();
                setting.clickIndividual(player, elevator, () -> ElevatorGUIHelper.openInteractSettingsMenu(player, elevator), (InventoryClickEvent)event);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        }
        if (!downActions.isEmpty()) {
            display.setItemSimple(inventory.getSize() - 1, ItemStackHelper.createItem(ChatColor.GOLD + "" + ChatColor.BOLD + "Downwards Actions", Material.SPECTRAL_ARROW, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                ElevatorGUIHelper.openInteractActionsMenu(player, elevator, downActions);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        }
        if (!upActions.isEmpty()) {
            display.setItemSimple(inventory.getSize() - (downActions.isEmpty() ? 1 : 2), ItemStackHelper.createItem(ChatColor.GOLD + "" + ChatColor.BOLD + "Upwards Actions", Material.TIPPED_ARROW, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                ElevatorGUIHelper.openInteractActionsMenu(player, elevator, upActions);
            }, new SimpleDisplay.DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(ChatColor.GRAY + "" + ChatColor.BOLD + "BACK", Material.ARROW, 1), new SimpleDisplay.DisplayClickFlag[0]);
        display.open();
    }

    static {
        boolean bl = $assertionsDisabled = !ElevatorGUIHelper.class.desiredAssertionStatus();
        if (!Elevators.getFoliaLib().isFolia()) {
            try {
                SignGUI.builder();
                signEnabled = true;
            }
            catch (SignGUIVersionException e) {
                signEnabled = false;
            }
            anvilEnabled = true;
            try {
                VersionWrapper wrapper = new VersionMatcher().match();
                Method toNMSMethod = wrapper.getClass().getDeclaredMethod("sendPacketCloseWindow", Player.class, Integer.TYPE);
                toNMSMethod.setAccessible(true);
                try {
                    toNMSMethod.invoke((Object)wrapper, null, -1);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getTargetException() instanceof NoClassDefFoundError) {
                        anvilEnabled = false;
                        Elevators.getElevatorsLogger().warning("AnvilAPI is not up-to-date. Using backup chat input system.");
                    } else if (!(ite.getTargetException() instanceof NullPointerException)) {
                        Elevators.getElevatorsLogger().warning(ite.getTargetException().toString());
                        anvilEnabled = false;
                    }
                }
            }
            catch (Exception ex) {
                Elevators.getElevatorsLogger().warning("AnvilAPI is not up-to-date. Using backup chat input system.");
                Elevators.getElevatorsLogger().warning(ex.toString());
                anvilEnabled = false;
            }
        }
    }
}

