/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.models.settings;

import me.keehl.elevators.models.ElevatorSetting;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.configs.versions.configv5_1_0.ConfigElevatorType;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MaxStackSizeSetting
extends ElevatorSetting<Integer> {
    public MaxStackSizeSetting() {
        super("change-max-stack-size", "Max Stack Size", "This controls the maximum stack size of elevator item stacks.", Material.COMPARATOR, ChatColor.YELLOW);
        this.setGetValueGlobal(ConfigElevatorType::getMaxStackSize);
        this.addAction("Left Click", "Increase Quantity");
        this.addAction("Right Click", "Decrease Quantity");
    }

    @Override
    public void onClickGlobal(Player player, ElevatorType elevatorType, Runnable returnMethod, InventoryClickEvent clickEvent, Integer currentValue) {
        int newValue = currentValue + (clickEvent.isLeftClick() ? 1 : -1);
        newValue = Math.min(Math.max(newValue, 1), 64);
        elevatorType.setMaxStackSize(newValue);
        returnMethod.run();
    }
}

