/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.models.ElevatorRecipeGroup;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.configs.versions.configv5_1_0.ConfigRoot;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.permissions.Permissible;

public class ElevatorRecipeService {
    private static boolean initialized = false;
    private static final Map<ElevatorType, ElevatorRecipeGroup> elevatorRecipeGroupMap = new HashMap<ElevatorType, ElevatorRecipeGroup>();

    public static void init() {
        if (initialized) {
            return;
        }
        Elevators.pushAndHoldLog();
        ElevatorConfigService.addConfigCallback(root -> ElevatorRecipeService.refreshRecipes());
        initialized = true;
        Elevators.popLog(logData -> Elevators.log("Recipe service enabled. " + ChatColor.YELLOW + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static void refreshRecipes() {
        Elevators.pushAndHoldLog();
        ConfigRoot root = ElevatorConfigService.getRootConfig();
        Iterator it = Bukkit.getServer().recipeIterator();
        ArrayList<ShapedRecipe> recipesToUnlearn = new ArrayList<ShapedRecipe>();
        boolean removedRecipes = false;
        while (it.hasNext()) {
            ShapedRecipe shapedRecipe;
            Recipe recipe = (Recipe)it.next();
            if (!(recipe instanceof ShapedRecipe) || !(shapedRecipe = (ShapedRecipe)recipe).getKey().getNamespace().equalsIgnoreCase("elevators")) continue;
            it.remove();
            recipesToUnlearn.add(shapedRecipe);
            removedRecipes = true;
        }
        elevatorRecipeGroupMap.clear();
        if (VersionHelper.doesVersionSupportRemoveRecipe()) {
            recipesToUnlearn.forEach(VersionHelper::removeRecipe);
        }
        Bukkit.getOnlinePlayers().forEach(i -> i.undiscoverRecipes((Collection)recipesToUnlearn.stream().map(ShapedRecipe::getKey).collect(Collectors.toList())));
        if (removedRecipes) {
            Elevators.log("Unregistered old recipes");
        }
        ArrayList<NamespacedKey> recipeKeys = new ArrayList<NamespacedKey>();
        int recipes = 0;
        for (ElevatorType elevatorType : root.elevators.values()) {
            for (ElevatorRecipeGroup recipeGroup : elevatorType.getRecipeGroups()) {
                recipeGroup.load(elevatorType);
                elevatorRecipeGroupMap.put(elevatorType, recipeGroup);
                recipeKeys.addAll(recipeGroup.getNameSpacedKeys());
                ++recipes;
            }
        }
        Bukkit.getOnlinePlayers().forEach(i -> i.discoverRecipes((Collection)recipeKeys));
        int recipeCount = recipes;
        Elevators.popLog(logData -> Elevators.log("Registered " + recipeCount + " recipe groups. " + ChatColor.YELLOW + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static void discoverRecipesForPlayer(Player player) {
        for (ElevatorRecipeGroup recipeGroup : elevatorRecipeGroupMap.values()) {
            player.discoverRecipes(recipeGroup.getNameSpacedKeys());
        }
    }

    public static boolean doesPermissibleHaveCraftPermission(Permissible permissible, ShapedRecipe recipe) {
        return elevatorRecipeGroupMap.values().stream().anyMatch(i -> i.doesPermissibleHavePermissionForRecipe(permissible, recipe));
    }
}

