/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.listeners;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import io.papermc.lib.PaperLib;
import java.util.List;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.ElevatorPermHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorEventData;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.models.settings.DisplayNameSetting;
import me.keehl.elevators.models.settings.LoreLinesSetting;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.ElevatorSettingService;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PaperEventExecutor {
    public static void onJump(PlayerJumpEvent e) {
        Block block = e.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).getBlock();
        ShulkerBox box = ShulkerBoxHelper.getShulkerBox(block);
        if (box == null) {
            return;
        }
        ElevatorType elevatorType = ElevatorHelper.getElevatorType(box);
        if (elevatorType == null) {
            return;
        }
        if (ElevatorConfigService.isWorldDisabled(e.getPlayer().getWorld())) {
            if (ElevatorHelper.hasOrAddPlayerCoolDown(e.getPlayer(), "message")) {
                MessageHelper.sendWorldDisabledMessage(e.getPlayer(), new ElevatorEventData(elevatorType));
            }
            return;
        }
        Elevator elevator = new Elevator(box, elevatorType);
        if (!ElevatorHookService.canUseElevator(e.getPlayer(), elevator, true)) {
            return;
        }
        ElevatorEventData closest = ElevatorHelper.findDestinationElevator(e.getPlayer(), elevator, (byte)1);
        if (closest == null) {
            return;
        }
        if (!ElevatorPermHelper.canUseElevator(e.getPlayer(), closest)) {
            if (ElevatorHelper.hasOrAddPlayerCoolDown(e.getPlayer(), "message")) {
                MessageHelper.sendCantUseMessage(e.getPlayer(), closest);
            }
            return;
        }
        ElevatorHelper.onElevatorUse(e.getPlayer(), closest);
    }

    public static void onHopperTake(InventoryMoveItemEvent event) {
        if (event.getSource().getType() != InventoryType.SHULKER_BOX && event.getDestination().getType() != InventoryType.SHULKER_BOX) {
            return;
        }
        ItemStack item = event.getItem();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (item.getType().equals((Object)Material.COMMAND_BLOCK) && meta.getDisplayName().equalsIgnoreCase("elevator")) {
            event.setCancelled(true);
            return;
        }
        ElevatorType elevatorType = ElevatorHelper.getElevatorType(event.getItem());
        if (elevatorType != null) {
            meta.setDisplayName(MessageHelper.formatColors((String)ElevatorSettingService.getSettingValue(elevatorType, DisplayNameSetting.class)));
            meta.setLore(MessageHelper.formatColors((List)ElevatorSettingService.getSettingValue(elevatorType, LoreLinesSetting.class)));
            event.getItem().setItemMeta(meta);
        }
        if (event.getSource().getType() == InventoryType.SHULKER_BOX && ElevatorHelper.isElevator(PaperLib.getHolder((Inventory)event.getSource(), (boolean)false).getHolder())) {
            event.setCancelled(true);
        }
        if (event.getDestination().getType() == InventoryType.SHULKER_BOX && ElevatorHelper.isElevator(PaperLib.getHolder((Inventory)event.getDestination(), (boolean)false).getHolder())) {
            event.setCancelled(true);
        }
    }
}

